/* 
	oxbytes.h -- v1.430 definition of bytecodes for oxbow interpreter `bterp'

	Copyright (c) 1995
	Norman D. Culver dba
	Oxbow Software
	1323 S.E. 17th Street #662
	Ft. Lauderdale, FL 33316
	(954) 463-4754
	ndc@icanect.net
	All rights reserved.

 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by Norman D. Culver dba Oxbow Software''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/

#if NEED_BYTECODES

#if SUPPORT_LONG_DOUBLE
#define XSZ (sizeof(long double))
#else
#define XSZ (sizeof(double))
#endif


#define A1 (0<<2)
#define A2 (1<<2)
#define A3 (2<<2)
#define A4 (3<<2)

#define S1 (0<<2)
#define S2 (1<<2)
#define S3 (2<<2)
#define S4 (3<<2)

#define D1 (0)
#define D2 (1)
#define D3 (2)
#define D4 (3)

#define B1 (0)
#define B2 (1)
#define B4 (2)
#define B8 (3)
#define BX (4)

#define J1 (0)
#define J2 (1)
#define J3 (2)
#define J4 (3)

#define BYTE	(0)
#define SHORT	(1)
#define LONG	(2)
#define UBYTE	(3)
#define USHORT	(4)
#define ULONG	(5)
#define FLOAT	(6)
#define DOUBLE	(7)

#define SLONGLONG (6)
#define SULONGLONG (7)

#define CLONGLONG	(8)
#define CULONGLONG	(9)
#define CLONGDOUBLE (10)	

#define LONGLONG	(0)
#define ULONGLONG	(1)
#define LONGDOUBLE	(2)

#define LS		(0x00)
#define UNUSED1	(LS|A4)
#define NEG		(0x10)
#define MOVSS	(NEG|12)
#define LM		(0x20)
#define COMP	(0x30)
#define JMP		(0x34)
#define NOT		(0x38)
#define SS		(0x40)
#define UNUSED2	(SS|A4)
#define TRUTHOF	(0x50)
#define LI		(0x58)
#define LUI		(0x5C)
#define LAI		(0x60)
#define SM		(0x70)

#define ADD		(0x80|(0<<3))
#define SUB		(0x80|(1<<3))
#define MUL		(0x80|(2<<3))
#define DIV		(0x80|(3<<3))
#define OR		(0x80|(4<<3))
#define JMPT	(OR|4)
#define AND		(0x80|(5<<3))
#define JMPF	(AND|4)
#define MOD		(0x80|(6<<3))
#define MOVAAX	(MOD|6)
#define XTD		(MOD|7)
#define XOR		(0x80|(7<<3))
#define MOVSM	(XOR|4)
#define GT		(0x80|(8<<3))
#define LT		(0x80|(9<<3))
#define GE		(0x80|(10<<3))
#define LE		(0x80|(11<<3))
#define NE		(0x80|(12<<3))
#define EQ		(0x80|(13<<3))
#define ARG		(0x80|(14<<3))
#define ARGA	(ARG|1)
#define ARGF	(ARG|2)
#define SWAP4DEEP	(ARG|3)
#define LOCATE	(ARG|4)
#define MOVMS	(0x80|(15<<3))
#define MOVMM	(MOVMS|4)


/* Immediate subgroup */
#define SMI		(1<<4)
#define SSI		(2<<4)
#define MODI	(3<<4)
#define DEREF	(4<<4)
#define DEREF1	(5<<4)

/* Miscellaneous */
#define DUMP	(NOT|4)
#define CALL	(NOT|5)
#define SWAP	(NOT|6)
#define DUP		(NOT|7)
#define LINENO	(TRUTHOF|0)
#define CVT		(TRUTHOF|4)
#define ABSSTK	(TRUTHOF|5)
#define IMMED	(TRUTHOF|6)
#define RET		(TRUTHOF|7)
#define DUP4 	(NEG|8)
#define SWAP4 	(NEG|9)
#define MOVDA1	(NEG|10)
#define MOVDA2	(NEG|11)
#define MOVDA4	(LAI|4)
#define MOVDA8	(LAI|5)
#define MOVDAX	(LAI|6)
#define MOVAA1	(LAI|7)
#define LJMPT	(LAI|8)
#define LJMPF	(LAI|12)
#define NFUNC	(UNUSED1|0)
#define NOP		(UNUSED1|1)
#define MOVAAC	(UNUSED1|2)
#define ABSMEM	(UNUSED1|3)
#define MOVAA8	(UNUSED2|0)
#define REGAIN	(UNUSED2|1)
#define MOVAA2	(UNUSED2|2)
#define MOVAA4	(UNUSED2|3)

/* extended subgroup */
#define GETBITFIELD (LM|A4|1)
#define PUTBITFIELD (LM|A4|2)
#define CALLSETUP	(LM|A4|3)
#define SWITCH		(SM|A4|1)
#define PRUNESTRUCT (SM|A4|2)
#define CLRDAT		(SM|A4|3)
#define RETSTRUCT	(SM|A3|1)
#define BUILTIN		(SM|A3|2)
#define LSHI		(NEG|4)
#define LSH			(NEG|8)
#define RSH			(LAI)
#define RSHI		(LAI|8)


/* Interpreter builtins */
#define ALLOCA 1
#define SETJMP 2
#define LONGJMP 3
#define STRLEN 4
#define STRCPY 5
#define STRCAT 6
#define MEMCPY 7
#define MEMMOVE 8
#define MEMSET 9
#define BZERO 10
#define MALLOC 11
#define CALLOC 12
#define REALLOC 13
#define EXIT 14
#define ABORT 15
#define DEBUG 16
#define NODEBUG 17
#endif /* NEED_BYTECODES */

#if NEED_SPELLING

static char *Jbuf[] = {
"J1","J2","J3","J4"
};
static int Jcnt[] = {
1,2,3,4
};
static char *Dbuf[] = {
"D1","D2","D3","D4"
};
static int Dcnt[] = {
1,2,3,4
};
static char *SDbuf[] = {
" S1|D1", " S1|D2", " S1|D3"," S1|D4",
" S2|D1", " S2|D2", " S2|D3"," S2|D4",
" S3|D1", " S3|D2", " S3|D3"," S3|D4",
" S4|D1", " S4|D2", " S4|D3"," S4|D4"
};
static int SDcnt[] = {
2,3,4,5,3,4,5,6,4,5,6,7,5,6,7,8
};
static char *ABbuf[] = {
"A1|B1","A1|B2","A1|B4","A1|B8",
"A2|B1","A2|B2","A2|B4","A2|B8",
"A3|B1","A3|B2","A3|B4","A3|B8",
"A4|B1","A4|B2","A4|B4","A4|B8"
};
static int ABcnt[] = {
2,3,5,9,3,4,6,10,4,5,9,11,5,6,8,16
};
static char *Abuf[] = {
"A1","A2","A3","A4"
};
static int Acnt[] = {
1,2,3,4
};
static char *Bbuf[] = {
"B1","B2","B4","B8","BX"
};
static int Bcnt[] = {
1,2,4,8
};
static char *Tbuf[] = {
"BYTE","SHORT","LONG","UBYTE","USHORT","ULONG","FLOAT","DOUBLE",
"LONGLONG","ULONGLONG","LONGDOUBLE"
};
static char *XTbuf[] = {
"LONGLONG","ULONGLONG","LONGDOUBLE","","","","LONGLONG","ULONGLONG"
};
static char *BUbuf[] = {"",
"alloca ","setjmp ","longjmp ","strlen ","strcpy ","strcat ",
"memcpy ","memmove ","memset ","bzero ","malloc ","calloc ",
"realloc ","exit ","abort ","bterpdebug ", "bterpnodebug "
};

#endif /* NEED_SPELLING */

#if NEED_AOUT_FORMAT

/* OUTPUT FORMAT IS A VARIANT OF A.OUT */

struct exec
{
  unsigned long a_info;         /* Contains MAGIC number */
  unsigned a_text;              /* length of text, in bytes */
  unsigned a_data;              /* length of data, in bytes */
  unsigned a_bss;               /* length of uninitialized data area for file, in bytes */
  unsigned a_syms;              /* length of symbol table data in file, in bytes */
  unsigned a_entry;             /* start address */
  unsigned a_trsize;            /* length of relocation info for text, in bytes */
  unsigned a_drsize;            /* length of relocation info for data, in bytes */
};

#define OMAGIC 0407
#define NMAGIC 0410
#define ZMAGIC 0413

/* a.out symbol table struct */
struct nlist {
  union {
    char *n_name;
    struct nlist *n_next;
    long n_strx;
  } n_un;
  unsigned char n_type;
  char n_other;
  short n_desc;
  unsigned long n_value;
};
#define N_UNDF 0x00
#define N_ABS 0x02
#define N_TEXT 0x04
#define N_DATA 0x06
#define N_BSS 0x08
#define N_NDC 0x10
#define N_COMM 0x12
#define N_FN 0x0f
#define N_EXT 0x01
#define N_TYPE 0x1e
#define N_STAB 0xe0
#define N_INDR 0x0a				/* Symbol is indirect */
#define N_SETA  0x14            /* Absolute set element symbol */
#define N_SETT  0x16            /* Text set element symbol */
#define N_SETD  0x18            /* Data set element symbol */
#define N_SETB  0x1A            /* Bss set element symbol */
#define N_SETV  0x1C            /* Pointer to set vector in data area.  */
#define N_SWTAB 0x20			/* A switch table entry */

struct relocation_info
{
  long r_address;
  unsigned long r_symbolnum:24;
  unsigned long r_pcrel:1;
  unsigned long r_length:2;
  unsigned long r_extern:1;
  unsigned long r_pad:4;
};

#endif /* NEED_AOUT_FORMAT */
