#include "mwutil.h"

static int IsEGA (void)
{
  SWI_REGS regs;
  regs.eax = 0x1200;
  regs.ebx = 0xFF10;
  _dx_real_int (0x10,&regs);
  return (hiBYTE(regs.ebx) != 0xFF);
}

/*---------------------------------------------------*/

void textmode (int mode)
{
  SWI_REGS regs;
  int mode_to_set = mode;

  if (mode == LASTMODE)
      mode = mode_to_set = conio_scr_info.currmode;
  if (mode == C4350)
      mode_to_set = 0x03;     /* set mode 3 and load 8x8 font */

  regs.eax = mode_to_set;
  _dx_real_int (0x10,&regs);

  if (IsEGA())
  {
    if (mode == C80 || mode == BW80 || mode == C4350)
    {
      /* Enable cursor size emulation */
      regs.eax = 0x1200;
      regs.ebx = 0x34;
      _dx_real_int (0x10,&regs);
    }
    if (mode == C4350)
    {
      /* load 8x8 font */
      regs.eax = 0x1112;
      regs.ebx = 0;
      _dx_real_int (0x10,&regs);
    }
  }
  _conio_reinit = 1;
  conio_init();
}
