include mwutil.ah

_TEXT segment
      extrn conio_init : near
      extrn _directcursor : dword


;-------------------------------------------------------------
; void gotoxy (int x, int y);
;
; Moves the cursor to a (X,Y) screen position by using the
; fastest alternative. Coordinates (X,Y) are relative to values
; in _conio_scr_info

PubProc gotoxy
        call conio_init
        mov dl,[esp+4]                  ; DL = X
        mov dh,[esp+8]                  ; DH = Y
        mov conio_scr_info.curx,dl      ; store in screen-info
        mov conio_scr_info.cury,dh

        add dl,conio_scr_info.winleft   ; make absolute X
        add dh,conio_scr_info.wintop    ; make absolute Y
        sub edx,0202h

@whatGoto:
        cmp _directcursor,0             ; how to move cursor?
        jne gotoXY_BIOS                 ; yes, use "safe" BIOS method
      ; jmp short gotoXY_direct         ; no, use fast direct version
      ; fall-through

;------------------------------------------------------------------------
;
; Move the screen cursor by directly manipulating the CRT controller
;
; In  : DL = X, DH = Y
; Out : EAX,ECX changed

gotoXY_direct:
        push edx
        movzx eax, conio_scr_info.screenwidth
        mul dh                         ; EAX = y * _conio_scr_info.screenwidth
        movzx edx, byte ptr [esp]
        add eax, edx                   ; EAX = EAX + x
        add ax, screen_start           ; EAX = EAX + screen_start
                                       ; xy = EAX
        mov ecx,eax
        mov dx,CRT_base
        mov al,0Eh
        out dx,al                      ; outportb(CRT_base,0x0E);
        inc dx
        mov al,ch
        out dx,al                      ; outportb(CRT_base+1,xy >> 8);
        dec dx
        mov al,0Fh
        out dx,al                      ; outportb(CRT_base,0x0F);
        inc dx
        mov al,cl
        out dx,al                      ; outportb(CRT_base+1,xy & 0xFF);

        pop edx                        ; restore (X,Y)
        movzx eax,screen_page
        push es
        mov cx, SS_DOSMEM
        mov es,cx
        mov es:[450h+2*eax],dx         ; save new pos in BIOS
        pop es
        ret


;-------------------------------------------------------------
; void gotoxy_abs (int x, int y);
;
; Moves the cursor to a (X,Y) screen position by using the
; fastest alternative. Coordinates (X,Y) are absolute

PubProc gotoxy_abs
        mov dl,[esp+4]                  ; DL = X
        mov dh,[esp+8]                  ; DH = Y
        jmp short @whatGoto


;----------------------------------------------------------------------
; gotoXY_BIOS.
; In :  DL=X, DH=Y
;
; Moves the cursor to a absolute screen position by calling BIOS
;

gotoXY_BIOS:
        push esi
        push edi
        push ebx
        mov bh, byte ptr screen_page   ; slow BIOS version
        mov ah,2
        int 10h
        pop ebx
        pop edi
        pop esi
        ret


_TEXT ends
end
