/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
adjoint(int n)
{
int      row;
int      col;
fraction f;

double pbA    [MXR][MXC*TWOCOL];matrix mA    ={MXR,MXC*TWOCOL,&pbA    [0][0]};
double pbCofac[MXR][MXC*TWOCOL];matrix mCofac={MXR,MXC*TWOCOL,&pbCofac[0][0]};
double pbAdjnt[MXR][MXC*TWOCOL];matrix mAdjnt={MXR,MXC*TWOCOL,&pbAdjnt[0][0]};

                     mA.rows=n;                   mA.cols= n*TWOCOL;
                 mCofac.rows=n;               mCofac.cols= n*TWOCOL;
                 mAdjnt.rows=n;               mAdjnt.cols= n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mA,9,9);

  clrscrn();
  printf("                                                     A :\n");
  printmF(&mA);

  printf("                                                mAdjnt :\n");
  mcofactorF(&mA,&mCofac);
    adjointF(    &mCofac,&mAdjnt);
     printmF(            &mAdjnt);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            Find the adjoint matrix of mA        ");
  printf("\n            ******************************      \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"adjointf.exe\"                \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"adjointf.exe 2\" -> mA 2x2      ");
  printf("\n                \"adjointf.exe 3\" -> mA 3x3      ");
  printf("\n                \"adjointf.exe 4\" -> mA 4x4      ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 2){n=2;}


  adjoint(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



