#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Microsoft Visual C++ 2.x 32 bit version. Supports Phar Lap
#               TNT DOS Extender and 32 bit Windows development.
#
# $Id: vc32.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources
   D            := .dll   # Dynamic Link Library file
   R            := .res   # Compiled resource file

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT SHW BETA
.IMPORT .IGNORE : TNT_PATH FPU USE_WIN32 USE_WIN95 BUILD_DLL IMPORT_DLL

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := cl       # C-compiler and flags
   CFLAGS       := /YX /w
   AS           := tasm     # Assembler and flags
   ASFLAGS      := /mx /m /D__FLAT__ /D__COMM__ /i$(SCITECH)\INCLUDE
.IF $(USE_WIN32)
   LD           := cl
   LDFLAGS       = $(CFLAGS)
.ELSE
   LD           := 386link  # Loader and flags
   LDFLAGS       = $(CFLAGS)
.ENDIF
   RC           := rc       # Watcom resource compiler
   RCFLAGS      :=          # Mark as Win32 compatible resources
   LIB          := lib      # Librarian
   LIBFLAGS     :=
   ILIB         := lib      # Import librarian
   ILIBFLAGS    := /MACHINE:IX86

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += /Yd /Zi  # Turn on debugging for C compiler
   ASFLAGS      += /zi      # Turn on debugging for assembler
.ELSE
   ASFLAGS      += /q       # Suppress object records not needed for linking
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += /G5 /O2 /Ox
.ELIF $(OPT_SIZE)
   CFLAGS       += /G5 /O1
.END

# Optionally turn on direct i387 FPU instructions

.IF $(FPU)
   CFLAGS       += /DFPU387
   ASFLAGS      += /DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += /DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += /DBETA
   ASFLAGS      += /DBETA
.END

# DOS extender dependant flags
.IF $(USE_WIN32)                # Build 32 bit Windows NT app
.IF $(BUILD_DLL)
   CFLAGS       += /ML /LD -DBUILD_DLL
   ASFLAGS      += -DBUILD_DLL
.ELSE
   CFLAGS       += /ML
.ENDIF
   DX_ASFLAGS   += -D__WINDOWS32__
   LIB_OS       = WIN32
.ELSE
   USE_TNT      := 1
   DX_CFLAGS    += /DTNT
   DX_ASFLAGS   += -DTNT
   LIB_OS       = DOS32
.ENDIF

# Place to look for PMODE library files
.IF $(MK_PMODE)
.ELSE
PMLIB           := tnt\pmode.lib
.END

# Define where to install library files
   LIB_BASE     := $(SCITECH)\$(LIB_DIR)\$(LIB_OS)\VC
   LIB_DEST     := $(LIB_BASE)

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; +$(CC) /nologo $(CFLAGS) /c $<
   %$O: %$P ; +$(CC) /nologo $(CFLAGS) /c $<
   .SWAP %$O: %$A ; +$(AS) $(ASFLAGS) $(<:s,/,\)

# Implicit rule for building resource files
   %$R: %.rc ; +$(RC) $(RCFLAGS) -r $<

# Implicit rule for building a DLL using a response file
   %$D: ; +rclink $(LD) $(RC) $@ $(mktmp $(LDFLAGS) /Fe$@ $(&:s/\/\\) $(EXELIBS) kernel32.lib gdi32.lib)

# Implicit rule for building a library file using response file. Note that
# we use a special .VCD file that contains the EXPORT definitions for the
# Microsoft compiler, since the LIB utility automatically adds leading
# underscores to exported functions.
.IF $(BUILD_DLL)
#  %$L: ; $(ILIB) $(ILIBFLAGS) $@ +$?
.ELIF $(IMPORT_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) /DEF:$(?:b).vcd /OUT:$@
.ELSE
   %$L: ; $(LIB) $(LIBFLAGS) /out:$@ @$(mktmp $(?:t"\n")\n)
.ENDIF

# Implicit rule for building an executable file using response file
.IF $(USE_WIN32)
.IF $(USE_WIN95)
   %$E: ; +$(LD) $(LDFLAGS) /Fe$@ @$(mktmp $(&:s/\/\\) $(EXELIBS) kernel32.lib gdi32.lib winmm.lib)
.ELSE
   %$E: ; +$(LD) $(LDFLAGS) /Fe$@ @$(mktmp $(&:s/\/\\) $(EXELIBS) kernel32.lib gdi32.lib winmm.lib) -link -subsystem:windows,3.10
.ENDIF
.ELSE
   %$E: ; +$(LD) @msvc32.dos -exe $@ @$(mktmp,$*.lnk $(&:s/\/\\) $(PMLIB) $(EXELIBS))
.ENDIF

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

RCSINC :=  $(SCITECH)\INCLUDE

