#include <jlib.h>
#include <jx_font.h>

/* shows the combinations of simple font drawing types */

int main(int argc ,char **argv)
{
 font *f;
 buffer_rec *offscreen;
 int i;

 JLIB_DEBUG_ON;

 if (argc != 3) {
    puts("fonttst1 <font> <text> : draws some <text> in <font>.");
    exit(0);
 }

 screen_set_video_mode();

 /* load and check font */
 f=font_load(argv[1]);
 if(f==NULL){
    jlib_exit("font load failed");
 }

 /* set up a white color */
 screen_put_pal(15,255,255,255);

 offscreen=buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);


 /* draw default, stencilled in color */
 font_string(f,offscreen,0,0,argv[2],15,NULL,0);

 screen_blit_fs_buffer(offscreen);
 getch();

 /* then stamped */
 buff_fill(offscreen,15); /* to show stamping */
 font_string(f,offscreen,0,0,argv[2],15,NULL,FONT_STAMP);

 screen_blit_fs_buffer(offscreen);
 getch();

 buff_clear(offscreen);

 /* draw stencilled & underlined */
 font_string(f,offscreen,0,0,argv[2],15,NULL,FONT_UNDERLINE);

 screen_blit_fs_buffer(offscreen);
 getch();
 buff_clear(offscreen);

 /* then stamped and underlined */
 buff_fill(offscreen,15); /* to show stamping */
 font_string(f,offscreen,0,0,argv[2],15,NULL,FONT_STAMP|FONT_UNDERLINE);

 screen_blit_fs_buffer(offscreen);
 getch();

 screen_restore_video_mode();
 return 1;
}
