/* Written 1996  Jonathan Paul Griffiths.
 * From code originally written by Csaba Biegl in the package libgrx 2.0
 * This code is modified from the test program \grx20\test\fontdisp.c
 * The Original Copyright of this code follows:

 Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
Source code with the above copyright is distributed under the following terms:

 (1) The test programs for the graphics library (code in the 'test'
     sub-directory) is distributed without restrictions. This code
     is free for use in commercial, shareware or freeware applications.

 * See the file "readme.jon" for detailed terms concerning the rest of the
 * jx_font JLib Extension package.
 *
 * NOTES: this code is only intended to run under DOS and Linux.
 *        it's not my best work,  but its fine for a run-once conversion.
 */
#include <stdio.h>
#include "grx20.h"
#include <jlib.h>
#include <jx_font.h>

void BitSet(char *set, long number, int value);
void convert(GrFont *f,char *name)
{
 int  chr,wdt,xpos,ypos,totalsize=0,newpos,i;
 char far *bmp;
 FILE *fp;
 UBYTE *inbuff;
 unsigned long comp_length;
 char *outname;

 outname = strrchr (name, '.');
 strcpy(outname,".jfn");        
 outname = name;

 /* open font file */
 if((fp=fopen(outname,"wb"))== NULL){
    jlib_exit("convert fopen() failed");
 }
 
 /* write preliminary details */
 fputc(FONT_MAGIC,fp);
 fputc(0,fp);/* nothing in reserved byte */
 fputc(0,fp);/* not color */
 fputc((UBYTE)f->h.proportional,fp);
 fputc((UBYTE)f->h.width,fp);
 fputc((UBYTE)f->h.height,fp);
 fputc((UBYTE)f->h.baseline+1,fp);
 fputc((UBYTE)f->h.minchar,fp);
 fputc((UBYTE)(f->h.minchar+f->h.numchars-1),fp);
 printf("chars %d %d \n",f->h.minchar,f->h.numchars);
 /* calculate space needed for bit-array */
 for(chr = f->h.minchar; chr < (f->h.minchar + f->h.numchars); chr++) {
     wdt = GrFontCharWidth(f,chr);
     totalsize+=(f->h.height*wdt); /* size in BITS needed */
 }

 printf("totalsize = %d,  bits= %d\n",totalsize,(totalsize+7)>>3);

 /* ... and malloc() it */
 if((inbuff=malloc(((totalsize+7)>>3)*sizeof(UBYTE)))==NULL){ /* size in BYTES */
    jlib_exit("convert malloc() Failed");
 }

 newpos=0;

 /* pack the font into the bit array (gives 8 x compression over sprite system */
 for(chr = f->h.minchar; chr < (f->h.minchar + f->h.numchars); chr++) {
     wdt = GrFontCharWidth(f,chr);
     bmp = GrFontCharBitmap(f,chr);
     fputc((UBYTE)wdt,fp); /* write width */

     for(ypos = 0; ypos < f->h.height; ypos++) {
         for(xpos = 0; xpos < wdt; xpos++) {
              BitSet(inbuff,newpos+(ypos*wdt)+xpos,((bmp[xpos >> 3] & (0x80 >> (xpos & 7))) ? 1:0));
         }
         bmp += ((wdt + 7) >> 3);
     }
     newpos+=(wdt*f->h.height);
 }

 /* write the bit array length */
 comp_length=(totalsize+7)>>3;

printf("uncomplen =%d\n",comp_length);
 fputc((UBYTE)(comp_length & 0xff),fp);
 fputc((UBYTE)((comp_length >> 8)  & 0xff),fp);
 fputc((UBYTE)((comp_length >> 16) & 0xff),fp);
 fputc((UBYTE)((comp_length >> 24)  & 0xff),fp);
      
 /* write the bit array */
 for(i=0;i<comp_length;i++){
     fputc(inbuff[i],fp);
 }

 /* done */
 fclose(fp);
}

int main(int argc, char **argv)
{
 int i;
 GrFont *f;

 for(i=0;i<argc;i++){
     if((f=GrLoadFont(argv[i]))!=NULL){
        convert(f,argv[i]);
     }
 }

 return(0);
}

/* this function is modified public domain from the "snippets" code collection */
void BitSet(char *set, long number, int value)
{
  set+=number>>3; /* shifts instead of / and % eliminate div. by zero probs */

  if(value){
     *set |= (1 << (number & 7 ));              /* set bit      */
  }
  else{
     *set &= (~(1 << (number & 7)));           /* clear bit    */
  }
}
