#include "stdafx.h"
#include <stdio.h>
#include "iport.h"      // IPORT header file

int main(int argc, char* argv[])
{
    IIpConnection* connection;
    char str[255];

    // Initialize Windows Sockets.
    if ( IP_OPEN() == -1 )
    {
        puts( "error: can't initialize WinSock" );
        return 0;
    }

    // Start the connection
    if ( OpenConnection ( "localhost", 10723, TRANS_UDP, NULL, NULL, &connection ) == -1 )
    {
        puts( "error: can't resolve ip address." );
        IP_CLOSE();
        return 0;
    }

    // Wait for any keyboard input
    while ( 1 )
    {
        gets ( str );
        if ( str[0] == '`' )
            break;

        // use SendDatagram with TRANS_UDP
        connection->SendDatagram( str, strlen ( str ) );
    }

    puts("Finishing...");

    // Close connections.
    CloseConnection( connection );

    // Uninitialize Windows Sockets.
    IP_CLOSE();

    // quit from program
    return 0;
}

