/**
 * Copyright (c) 1985 Sun Microsystems, Inc.
 * Copyright (c) 1980 The Regents of the University of California.
 * Copyright (c) 1976 Board of Trustees of the University of Illinois.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that the above copyright notice and this paragraph are duplicated in all
 * such forms and that any documentation, advertising materials, and other
 * materials related to such distribution and use acknowledge that the
 * software was developed by the University of California, Berkeley, the
 * University of Illinois, Urbana, and Sun Microsystems, Inc.  The name of
 * either University or Sun Microsystems may not be used to endorse or
 * promote products derived from this software without specific prior written
 * permission. THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "globals.h"

#ifndef lint
# ifndef ANSIC
static char     sccsid[] = "@(#)io.c	6.0 (Berkeley) 92/06/15";
# endif         /* ANSIC */
#endif          /* not lint */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#ifdef ANSIC
# include <stdarg.h>
# define bzero(achBuf, cbLength) memset(achBuf, 0, cbLength)
static int      pad_output(int, int);
#endif          /* ANSIC */

static int      comment_open = 0;
static int      paren_target = 0;

/* dump_line is the routine that actually effects the printing of the new
 * source. It prints the label section, followed by the code section with the
 * appropriate nesting level, followed by any comments
 */
#ifdef ANSIC
void            dump_line(void)
#else           /* ANSIC */
void            dump_line()
#endif          /* ANSIC */
{
    register int    cur_col;
    register int    target_col;
    static int      not_first_line = 0; /* = 0 ? PETER */

    if (ps.procname[0]) {
        if (troff) {
            if (comment_open) {
                comment_open = 0;
                fprintf(output, ".*/\n");
            }
            fprintf(output, ".Pr \"%s\"\n", ps.procname);
        }
        ps.ind_level = 0;
        ps.procname[0] = 0;
    }
    if (s_code == e_code && s_lab == e_lab && s_com == e_com) {
        if (suppress_blanklines > 0)
            suppress_blanklines--;
        else {
            ps.bl_line = true;
            n_real_blanklines++;
        }
    } else if (!inhibit_formatting) {
        suppress_blanklines = 0;
        ps.bl_line = false;
        if (prefix_blankline_requested && not_first_line)
            if (swallow_optional_blanklines) {
                if (n_real_blanklines == 1)
                    n_real_blanklines = 0;
            } else {
                if (n_real_blanklines == 0)
                    n_real_blanklines = 1;
            }
        while (--n_real_blanklines >= 0)
            putc('\n', output);
        n_real_blanklines = 0;
        if (ps.ind_level == 0) {
            if (!btype_3)
                ps.ind_stmt = 0;/* this is a class A kludge. don't do
                                 * additional statement indentation if we are
                                 * at bracket level 0 */
            else if (*s_code != '{')
                ps.ind_stmt = 0;/* this one is a class AA kludge: defeat the
                                 * class A kludge if the statement is '{' */
        }
        if (e_lab != s_lab || e_code != s_code)
            ++code_lines;       /* keep count of lines with code */


        if (e_lab != s_lab) {   /* print lab, if any */
            if (comment_open) {
                comment_open = 0;
                fprintf(output, ".*/\n");
            }
            while (e_lab > s_lab && (e_lab[-1] == ' ' || e_lab[-1] == '\t'))
                e_lab--;
            cur_col = pad_output(1, compute_label_target());
            fprintf(output, "%.*s", e_lab - s_lab, s_lab);
            cur_col = count_spaces(cur_col, s_lab);
        } else
            cur_col = 1;        /* there is no label section */

        ps.pcase = false;

        if (s_code != e_code) { /* print code section, if any */
            register char  *p = NULL;

            if (comment_open) {
                comment_open = 0;
                fprintf(output, ".*/\n");
            }
            target_col = compute_code_target();
            {
                register int    i;

                for (i = 0; i < ps.p_l_follow; i++)
                    if (ps.paren_indents[i] >= 0)
                        ps.paren_indents[i] = -(short) (ps.paren_indents[i] + target_col);
            }
            cur_col = pad_output(cur_col, target_col);
            for (p = s_code; p < e_code; p++)
                if (*p == (char) 0200)
                    fprintf(output, "%d", target_col * 7);
                else
                    putc(*p, output);
            cur_col = count_spaces(cur_col, s_code);
        }
        if (s_com != e_com)
            if (troff) {
                int             all_here = 0;
                register char  *p = NULL;

                if (ps.cc_comment)
                    all_here++;
                else if (e_com[-1] == '/' && e_com[-2] == '*')
                    e_com -= 2, all_here++;
                while (e_com > s_com && e_com[-1] == ' ')
                    e_com--;
                *e_com = 0;
                p = s_com;
                while (*p == ' ')
                    p++;
                if (p[0] == '/' && (p[1] == '*' || p[1] == '/'))
                    p += 2, all_here++;
                else if (p[0] == '*')
                    p += p[1] == '/' ? 2 : 1;
                while (*p == ' ')
                    p++;
                if (*p == 0)
                    goto inhibit_newline;
                if (comment_open < 2 && ps.box_com) {
                    comment_open = 0;
                    fprintf(output, ".*/\n");
                }
                if (comment_open == 0) {
                    if ('a' <= *p && *p <= 'z')
                        *p += 'A' - 'a';
                    if (e_com - p < 50 && all_here == 2) {
                        register char  *follow = p;

                        fprintf(output, "\n.nr C! \\w\1");
                        while (follow < e_com) {
                            switch (*follow) {
                            case '\n':
                                putc(' ', output);
                            case 1:
                                break;
                            case '\\':
                                putc('\\', output);
                            default:
                                putc(*follow, output);
                            }
                            follow++;
                        }
                        putc(1, output);
                    }
                    fprintf(output, "\n./* %dp %d %dp\n",
                            ps.com_col * 7,
                          (s_code != e_code || s_lab != e_lab) - ps.box_com,
                            target_col * 7);
                }
                comment_open = 1 + ps.box_com;
                while (*p) {
                    if (*p == BACKSLASH)
                        putc(BACKSLASH, output);
                    putc(*p++, output);
                }
            } else {            /* print comment, if any */
                register int    target = ps.com_col;
                register char  *com_st = s_com;

                target += ps.comment_delta;
                while (*com_st == '\t')
                    com_st++, target += tabsize;    /* JHT 22oct89 */
                while (target <= 0)
                    if (*com_st == ' ')
                        target++, com_st++;
                    else if (*com_st == '\t') {
                        target += (tabsize - ((target - 1) % tabsize)); /* JHT 22oct89 */
                        com_st++;
                    } else
                        target = 1;
                if (cur_col > target) { /* if comment won't fit on this line,
                                         * put it on the next one */
                    putc('\n', output);
                    cur_col = 1;
                    ++ps.out_lines;
                }
                while (e_com > com_st && isspace(e_com[-1]))
                    e_com--;
                cur_col = pad_output(cur_col, target);
                if (!ps.box_com && !ps.cc_comment) {
                    if (star_comment_cont && (com_st[1] != '*' || e_com <= com_st + 1))
                        if (com_st[1] == ' ' && com_st[0] == ' ' && e_com > com_st + 1)
                            com_st[1] = '*';
                        else
                            fwrite(" * ", com_st[0] == '\t' ? 2 : com_st[0] == '*' ? 1 : 3, 1, output);
                }
                fwrite(com_st, e_com - com_st, 1, output);
                ps.comment_delta = ps.n_comment_delta;
                cur_col = count_spaces(cur_col, com_st);
                ++ps.com_lines; /* count lines with comments */
            }
        if (ps.use_ff)
            putc('\014', output);
        else
            putc('\n', output);
inhibit_newline:
        ++ps.out_lines;
        if (ps.just_saw_decl == 1 && blanklines_after_declarations) {
            prefix_blankline_requested = 1;
            ps.just_saw_decl = 0;
        } else
            prefix_blankline_requested = postfix_blankline_requested;
        postfix_blankline_requested = 0;
    }
    ps.decl_on_line = ps.in_decl;   /* if we are in the middle of a
                                     * declaration, remember that fact for
                                     * proper comment indentation */
    ps.ind_stmt = ps.in_stmt & ~ps.in_decl; /* next line should be indented
                                             * if we have not completed this
                                             * stmt and if we are not in the
                                             * middle of a declaration */
    ps.use_ff = false;
    ps.dumped_decl_indent = 0;
    *(e_lab = s_lab) = '\0';    /* reset buffers */
    *(e_code = s_code) = '\0';
    *(e_com = s_com) = '\0';
    ps.ind_level = ps.i_l_follow;
    ps.paren_level = ps.p_l_follow;
    paren_target = -ps.paren_indents[ps.paren_level - 1];
    not_first_line = 1;
    return;
};

#ifdef ANSIC
int             compute_code_target(void)
#else           /* ANSIC */
compute_code_target()
#endif          /* ANSIC */
{
    register int    target_col = ps.ind_size * ps.ind_level + 1;

    if (ps.paren_level)
        if (!lineup_to_parens)
            target_col += continuation_indent * ps.paren_level;
        else {
            register int    w;
            register int    t = paren_target;

            if ((w = count_spaces(t, s_code) - max_col) > 0
                && count_spaces(target_col, s_code) <= max_col) {
                t -= w + 1;
                if (t > target_col)
                    target_col = t;
            } else
                target_col = t;
        }
    else if (ps.ind_stmt)
        target_col += continuation_indent;
    return target_col;
}

#ifdef ANSIC
int             compute_label_target(void)
#else           /* ANSIC */
compute_label_target()
#endif          /* ANSIC */
{
    return
        ps.pcase ?
        (cplus && ps.in_decl) ? cplus_ppp_indent
        : (int) (case_ind * ps.ind_size) + 1
        : *s_lab == '#' ? 1
        : ps.ind_size * (ps.ind_level - label_offset) + 1;
}


/**
 * Copyright (C) 1976 by the Board of Trustees of the University of Illinois
 * All rights reserved
 *
 * NAME: fill_buffer
 *
 * FUNCTION: Reads one block of input into input_buffer
 *
 * HISTORY: initial coding, November 1976, D A Willcox of CAC.
 * 1/7/77, D A Willcox of CAC, Added check for switch back to partly full input
 * buffer from temporary buffer.
 */

#ifdef ANSIC
void            fill_buffer(void)
#else           /* ANSIC */
fill_buffer()
#endif          /* ANSIC */
{                               /* this routine reads stuff from the input */
    register char  *p = NULL;
    register int    i;
    register FILE  *f = input;

    if (bp_save != 0) {         /* there is a partly filled input buffer left */
        buf_ptr = bp_save;      /* don't read anything, just switch buffers */
        buf_end = be_save;
        bp_save = be_save = 0;
        if (buf_ptr < buf_end)
            return;             /* only return if there is really something
                                 * in this buffer */
    }
    for (p = buf_ptr = in_buffer; p < &in_buffer[inp_bufs];) {
        if ((i = getc(f)) == EOF) {
            *p++ = ' ';
            *p++ = '\n';
            if (p >= &in_buffer[inp_bufs]) {
                diag(1, "Internal buffer overflow - Line is too long.");
                fflush(output);
                exit(1);
            }
            had_eof = true;
            break;
        }
        *p++ = (char) i;
        if (i == '\n')
            break;
    }
    buf_end = p;
    if (p[-2] == '/' && p[-3] == '*') {
        if (in_buffer[3] == 'I' && strncmp(in_buffer, "/**INDENT**", 11) == 0)
            fill_buffer();      /* flush indent error message */
        else {
            int             com = 0;

            p = in_buffer;
            while (*p == ' ' || *p == '\t')
                p++;
            if (*p == '/' && p[1] == '*') {
                p += 2;
                while (*p == ' ' || *p == '\t')
                    p++;
                if (p[0] == 'I' && p[1] == 'N' && p[2] == 'D' && p[3] == 'E'
                    && p[4] == 'N' && p[5] == 'T') {
                    p += 6;
                    if (*p == ':') {
#define MAX_SOURCE_ARG 100
                        char            argbuf[MAX_SOURCE_ARG] = "";
                        /* how big can they get?... */
                        char           *a = NULL;

                        p++;    /* skip the : */
                        /* since set_option changes flags, process pending
                         * stuff now */
                        if (s_com != e_com || s_lab != e_lab || s_code != e_code)
                            dump_line();
                        while (1) {
                            a = argbuf; /* accumulate an option */
                            while (*p <= ' ')   /* skip whitespace */
                                p++;
                            if (*p == '*')
                                break;
                            while (*p > ' ')
                                *a++ = *p++;
                            *a++ = '\0';
                            set_option(argbuf);
                        }
                        goto End_Magic_Comment;
                    }
                    while (*p == ' ' || *p == '\t')
                        p++;
                    if (*p == '*')
                        com = 1;
                    else if (*p == 'O')
                        if (*++p == 'N')
                            p++, com = 1;
                        else if (*p == 'F' && *++p == 'F')
                            p++, com = 2;
                    while (*p == ' ' || *p == '\t')
                        p++;
                    if (p[0] == '*' && p[1] == '/' && p[2] == '\n' && com) {
                        if (s_com != e_com || s_lab != e_lab || s_code != e_code)
                            dump_line();
                        if (!(inhibit_formatting = com - 1)) {
                            n_real_blanklines = 0;
                            postfix_blankline_requested = 0;
                            prefix_blankline_requested = 0;
                            suppress_blanklines = 1;
                        }
                    }
                }
            }
        }
    }
End_Magic_Comment:
    if (inhibit_formatting) {
        p = in_buffer;
        do
            putc(*p, output);
        while (*p++ != '\n');
    }
    return;
};

/**
 * Copyright (C) 1976 by the Board of Trustees of the University of Illinois
 * All rights reserved
 *
 * NAME: pad_output
 *
 * FUNCTION: Writes tabs and spaces to move the current column up to the desired
 * position.
 *
 * ALGORITHM: Put tabs and/or blanks into pobuf, then write pobuf.
 *
 * PARAMETERS: current integer The current column
 *             target  integer The desired column
 *
 * RETURNS: Integer value of the new column.  (If current >= target, no action
 * is taken, and current is returned.
 *
 * GLOBALS: None
 *
 * CALLS: write (sys)
 *
 * CALLED BY: dump_line
 *
 * HISTORY: initial coding 	November 1976	D A Willcox of CAC
 */


#ifdef ANSIC
int             pad_output(int current, int target)
#else           /* ANSIC */
pad_output(current, target)
    int             current;    /* the current column value */
    int             target;     /* position we want it at */
#endif          /* ANSIC */
/* writes tabs and blanks (if necessary) to get the current output position
 * up to the target column */
{
    register int    tstop;      /* Current tab stop being visited */

    if (troff)
        fprintf(output, "\\h'|%dp'", (target - 1) * 7);
    else {
        if (current >= target)
            return (current);   /* line is already long enough */
        if ((tabsize >= 2) && (usetabs)) {
            /* Compute where next tab stop lies: */
            tstop = current + tabsize - ((current - 1) % tabsize);

            for (; tstop <= target; tstop += tabsize)
                putc('\t', output); /* Tab to each tabstop */

            tstop -= tabsize;   /* Account for overshoot */
        } else
            tstop = current;

        while (tstop++ < target)
            putc(' ', output);  /* Space over to where we want to be */
    }
    return (target);
};

/**
 * Copyright (C) 1976 by the Board of Trustees of the University of Illinois
 * All rights reserved
 *
 * NAME: count_spaces
 *
 * FUNCTION: Find out where printing of a given string will leave the current
 * character position on output.
 *
 * ALGORITHM: Run through input string and add appropriate values to current
 * position.
 *
 * RETURNS: Integer value of position after printing "buffer" starting in
 * column "current".
 *
 * HISTORY: initial coding 	November 1976	D A Willcox of CAC
 */


#ifdef ANSIC
int             count_spaces(int current, char *buffer)
#else           /* ANSIC */
int             count_spaces(current, buffer)
    int             current;
    char           *buffer;
#endif          /* ANSIC */
/* this routine figures out where the character position will be after
 * printing the text in buffer starting at column "current" */
{
    register char  *buf = NULL; /* used to look through buffer */
    register int    cur = 0;    /* current character counter */

    cur = current;

    for (buf = buffer; *buf != '\0'; ++buf) {
        switch (*buf) {

        case '\n':
        case 014:               /* form feed */
            cur = 1;
            break;

        case '\t':
            cur = cur + (tabsize - ((cur - 1) % tabsize));
            break;

        case '\b':              /* this is a backspace */
            --cur;
            break;

        default:
            ++cur;
            break;
        }                       /* end of switch */
    }                           /* end of for loop */
    return (cur);
};

int             found_err;

#ifdef ANSIC
void            diag(int level, char *msg,...)
{
    va_list
    a;

    va_start(a, msg);
    if (level)
        found_err = 1;
    if (output == stdout) {
        fprintf(stdout, "/**INDENT** %s@%d: ", level == 0 ? "Warning" : "Error", line_no);
        vfprintf(stdout, msg, a);
        fprintf(stdout, " */\n");
    } else {
        fprintf(stderr, "%s@%d: ", level == 0 ? "Warning" : "Error", line_no);
        vfprintf(stderr, msg, a);
        fprintf(stderr, "\n");
    }
}
#else           /* ANSIC */
diag(level, msg, a, b)
{
    int             found_err;
    if (level)
        found_err = 1;
    if (output == stdout) {
        fprintf(stdout, "/**INDENT** %s@%d: ", level == 0 ? "Warning" : "Error", line_no);
        fprintf(stdout, msg, a, b);
        fprintf(stdout, " */\n");
    } else {
        fprintf(stderr, "%s@%d: ", level == 0 ? "Warning" : "Error", line_no);
        fprintf(stderr, msg, a, b);
        fprintf(stderr, "\n");
    }
}
#endif          /* ANSIC */

#ifdef ANSIC
void            writefdef(struct fstate * f, int nm)
#else           /* ANSIC */
writefdef(f, nm)
    register struct fstate *f;
    int             nm;
#endif          /* ANSIC */
{
    fprintf(output, ".ds f%c %s\n.nr s%c %d\n", nm, f->font, nm, f->size);
}

#ifdef ANSIC
char           *chfont(struct fstate * of, struct fstate * nf, char *s)
#else           /* ANSIC */
char           *
                chfont(of, nf, s)
    register struct fstate *of;
    register struct fstate *nf;
    char           *s;
#endif          /* ANSIC */
{
    if (of->font[0] != nf->font[0]
        || of->font[1] != nf->font[1]) {
        *s++ = '\\';
        *s++ = 'f';
        if (nf->font[1]) {
            *s++ = '(';
            *s++ = nf->font[0];
            *s++ = nf->font[1];
        } else
            *s++ = nf->font[0];
    }
    if (nf->size != of->size) {
        *s++ = '\\';
        *s++ = 's';
        if (nf->size < of->size) {
            *s++ = '-';
            *s++ = (char) ('0' + of->size - nf->size);
        } else {
            *s++ = '+';
            *s++ = (char) ('0' + nf->size - of->size);
        }
    }
    return s;
}

#ifdef ANSIC
void            parsefont(register struct fstate * f, char *s0)
#else           /* ANSIC */
parsefont(f, s0)
    register struct fstate *f;
    char           *s0;
#endif          /* ANSIC */
{
    register char  *s = s0;
    int             sizedelta = 0;

    bzero(f, sizeof *f);
    while (*s) {
        if (isdigit(*s))
            f->size = (char) (f->size * 10 + *s - '0');
        else if (isupper(*s))
            if (f->font[0])
                f->font[1] = *s;
            else
                f->font[0] = *s;
        else if (*s == 'c')
            f->allcaps = 1;
        else if (*s == '+')
            sizedelta++;
        else if (*s == '-')
            sizedelta--;
        else {
            fprintf(stderr, "indent: bad font specification: %s\n", s0);
            exit(1);
        }
        s++;
    }
    if (f->font[0] == 0)
        f->font[0] = 'R';
    if (bodyf.size == 0)
        bodyf.size = 11;
    if (f->size == 0)
        f->size = (char) (bodyf.size + sizedelta);
    else if (sizedelta > 0)
        f->size += bodyf.size;
    else
        f->size = bodyf.size - f->size;
}
