/*******************************************************************
* TESTFUNC.C - This file contains all of the test functions used   *
* in the article "More loop optimization techniques" in the IMC    *
* May 1991 issue.                                                  *
*                                                                  *
* There are 3 sets of test functions, corresponding to the test    *
* cases discussed in the article. By uncommenting one of the       *
* #define statements below you can choose which set of test        *
* functions to run. For example, to test the code from Figures 1a  *
* and 1b, you would uncomment the line: "#define FIGURE1 0"        *
*******************************************************************/

/*-------- Select test functions by uncommenting ONE of these ----*/
#define FIGURE1 0
//#define FIGURE2 0
//#define FIGURE3 0

/*-------- Global variables used by test functions ---------------*/
int x[100], y[100], z[100];

/*******************************************************************
* This empty function is used to determine the standard function   *
* call overhead.                                                   *
*******************************************************************/
void emptyfunc(void)
    {
    }

/*******************************************************************
* These functions test the code shown in Figures 1a and 1b         *
*******************************************************************/
#ifdef FIGURE1
void testfunc1( void )
    {
    int counter;

    for (counter = 0 ; counter < 100; counter++)
        z[counter] = (y[counter] * 8);
    }

void testfunc2( void )
    {
    int counter;

    for (counter = 0 ; counter < 100; counter += 2)
        {
        z[counter] = (y[counter] * 8);
        z[counter + 1] = (y[counter + 1] * 8);
        }
    }
#endif

/*******************************************************************
* These functions test the code shown in Figures 2a and 2b         *
*******************************************************************/
#ifdef FIGURE2
void testfunc1( void )
    {
    int counter;

    for (counter = 0 ; counter < 50; counter += 2)
        {
        z[counter] = (y[counter] * 8);
        z[counter + 1] = (y[counter + 1] * 8);
        }
    }

void testfunc2( void )
{
    int counter;
    register int *p = z;
    register int *q = y;

    for (counter = 0 ; counter < 50; counter += 2)
        {
        *p = (*q << 3);
        p++;
        q++;
        *p = (*q << 3);
        }
}
#endif

/*******************************************************************
* These functions test the code shown in Figures 3a and 3b         *
*******************************************************************/
#ifdef FIGURE3
void testfunc1( void )
    {
    int counter;

    for (counter = 0 ; counter < 50; counter++)
        z[counter] = (y[counter] * 8);

    for (counter = 0 ; counter < 50; counter++)
        x[counter] = z[counter] + y[counter];
    }

void testfunc2( void )
    {
    int counter;

    for (counter = 0 ; counter < 50; counter++)
        {
        z[counter] = (y[counter] * 8);
        x[counter] = z[counter] + y[counter];
        }
    }
#endif
