; strrchr
;   AAA=str
;   BBB=008
;   F=
;   O=
; str008.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strrchr:FN_CALL PTR
p_fn_strrchr P_FN_CALL strrchr
EXTERNDEF C p_fn_fc_strrchr:FN_CALL PTR
p_fn_fc_strrchr P_FN_CALL @strrchr
EXTERNDEF C p_fn_strrchr_sss:FN_CALL PTR
p_fn_strrchr_sss P_FN_CALL strrchr_sss
EXTERNDEF C p_fn_fc_strrchr:FN_CALL PTR
p_fn_fc_strrchr_sss P_FN_CALL @strrchr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strrchr() -- Search string for char, in reverse
;char __near * fn_call strrchr(const char __near * const, const int chr);
; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	character to search for
;RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to '\0' if character not found
;		to character if found
; NOTES:
;   will search for '\0', and find it at end of string
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strrchr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = p_Str, source
	    mov ax, [chr]
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
strrchr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strrchr() -- Search string for char, in reverse
;char __near * __fastcall fn_call strrchr(const char __near * const, const int chr);
; GIVEN:
; __fastcall
;   BX	    p_str, (source) offset from ds
;   AX	    chr
; RETURNS:
;   AX		near pointer, offset from ds
;		to '\0' if character not found
;		to character if found
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strrchr PROC FN_CALL USES si bx
	    mov si, bx	    ;ds:si = p_Str, source
			    ; ax = chr
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
@strrchr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strrchr_sss() -- Search string for char, in reverse
;char __near * fn_call strrchr_sss(const char __near * const, const int chr);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	character to search for
;RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to '\0' if character not found
;		to character if found
; NOTES:
;   will search for '\0', and find it at end of string
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strrchr_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds/ss:si = p_Str
	    mov ax, [chr]
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
strrchr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; strrchr_sss
;char __near * __fastcall fn_call strrchr(const char __near * const, const int chr);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ss
;   AX	    chr
; RETURNS:
;   AX		near pointer, offset from ss
;		to '\0' if character not found
;		to character if found
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strrchr_sss PROC FN_CALL USES ds si bx
	    mov si, bx	    ;ds/ss:si = p_Str
			    ; ax = chr
	    mov bx, ss
	    mov ds, bx

	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
@strrchr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
