/* string.h, clibc_16.lib */
/* Byron Young, 2002 */

#ifndef CLIBC_16_STRING_H
#define CLIBC_16_STRING_H

/*
*
* EXPECTED DEFINED MACROS
* NOTE:
*   if none of the following are defined, defaults to:
*	DEBUG_YES, CLIBC_16_FN_CALL_NEARCALL, CLIBC_16_EXTERN_PTRS_NO
*	CLIBC_16_FUNCTION_SEG_NAME _TEXT, CLIBC_16_EXTERN_PTRS_SEG_NAME _DATA.
*
* DEBUG - Determines if some debug info is generated.
*		     DEBUG_NO=0
*		     DEBUG_YES=1 (Default)
* CLIBC_16_FN_CALL - Near or far function calls.
*		     CLIBC_16_FN_CALL_NEARCALL=0 (Default)
*		     CLIBC_16_FN_CALL_FARCALL=1
* CLIBC_16_EXTERN_PTRS - If generate pointers to functions
*		     CLIBC_16_EXTERN_PTRS_NO=0 (Default)
*		     CLIBC_16_EXTERN_PTRS_YES=1
* CLIBC_16_FN_CALL_FARCALL_SEG - Combine method for far call functions.
*		     CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE=0 (Default)
*		     CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE=1
* CLIBC_16_FUNCTION_SEG_NAME - (base) name of function code segment.
*		     Defaults to either _TEXT or _CLIBC_16.
* CLIBC_16_EXTERN_PTRS_SEG_NAME - Data seg name for pointers.
*		     Defaults to _DATA.
*/

/* some values */
#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef DEBUG_YES
# define DEBUG_YES 1
#endif

#ifndef DEBUG_NO
# define DEBUG_NO 0
#endif

#ifndef CLIBC_16_FN_CALL_FARCALL
# define CLIBC_16_FN_CALL_FARCALL 1
#endif

#ifndef CLIBC_16_FN_CALL_NEARCALL
# define CLIBC_16_FN_CALL_NEARCALL 0
#endif

#ifndef CLIBC_16_EXTERN_PTRS_YES
# define  CLIBC_16_EXTERN_PTRS_YES 1
#endif

#ifndef CLIBC_16_FC_EXT_PTRS_NO
# define CLIBC_16_FC_EXT_PTRS_NO 0
#endif

#ifndef CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
# define CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE 0
#endif

#ifndef CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
# define CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE 1
#endif

/* defaults */
#ifndef DEBUG
# define DEBUG DEBUG_YES
#endif

#ifndef CLIBC_16_FN_CALL
# define CLIBC_16_FN_CALL CLIBC_16_FN_CALL_NEARCALL
#endif

#ifndef CLIBC_16_EXTERN_PTRS
# define CLIBC_16_EXTERN_PTRS CLIBC_16_EXTERN_PTRS_NO
#endif

/* set up defaults */
#if CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_FARCALL
# ifndef CLIBC_16_FUNCTION_SEG_NAME
#  define CLIBC_16_FUNCTION_SEG_NAME _CLIBC_16
# endif
# ifndef CLIBC_16_FN_CALL_FARCALL_SEG
#  define CLIBC_16_FN_CALL_FARCALL_SEG CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
# elif CLIBC_16_FN_CALL_FARCALL_SEG!=CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
#  undef CLIBC_16_FN_CALL_FARCALL_SEG
#  define CLIBC_16_FN_CALL_FARCALL_SEG CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
# endif
#elif CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_NEARCALL
# ifdef CLIBC_16_FN_CALL_FARCALL_SEG
#  undef CLIBC_16_FN_CALL_FARCALL_SEG
#  pragma message("Undefined CLIBC_16_FN_CALL_FARCALL_SEG")
# endif
# ifndef CLIBC_16_FUNCTION_SEG_NAME
#  define CLIBC_16_FUNCTION_SEG_NAME _TEXT
# endif
#else
# error CLIBC_16_FN_CALL Invalid.
#endif

#if CLIBC_16_EXTERN_PTRS==CLIBC_16_EXTERN_PTRS_NO
# ifdef CLIBC_16_EXTERN_PTRS_SEG_NAME
#  undef CLIBC_16_EXTERN_PTRS_SEG_NAME
#  pragma message("Undefined CLIBC_16_EXTERN_PTRS_SEG_NAME.")
# endif
#elif CLIBC_16_EXTERN_PTRS==CLIBC_16_EXTERN_PTRS_YES
# ifndef CLIBC_16_EXTERN_PTRS_SEG_NAME
#  define CLIBC_16_EXTERN_PTRS_SEG_NAME _DATA
# endif
#else
# error CLIBC_16_EXTERN_PTRS Invalid.
#endif

/* stringizing substitution macros */
#ifndef stringeyes_x
# define stringeyes_x(aabb) #aabb
#endif

#ifndef stringeyes
# define stringeyes(bbaa) stringeyes_x(bbaa)
#endif

#ifndef stringeyes_mult
# define stringeyes_mult(bbaa) "STRING"stringeyes_x(bbaa)
#endif

/* this should never happen! */
#ifdef fn_call_string
# undef fn_call_string
# pragma message("Redefined fn_call_string")
#endif

/* this should never happen! */
#ifdef CLIBC_16_FUNCTION_SEG_NAME_STRING
# undef CLIBC_16_FUNCTION_SEG_NAME_STRING
# pragma message("Undefined CLIBC_16_FUNCTION_SEG_NAME_STRING")
#endif

/* this should never happen! */
#  ifdef CLIBC_16_CS_STRING
#   undef CLIBC_16_CS_STRING
#   pragma message("Undefined CLIBC_16_CS_STRING")
#  endif

/* more settings */
#if CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_NEARCALL
# ifndef fn_call_dist
#  define fn_call_dist __near
# endif
# define fn_call_string __near __based(__segname(stringeyes(CLIBC_16_FUNCTION_SEG_NAME)))
# ifndef CLIBC_16_CS
#  define CLIBC_16_CS code_seg(stringeyes(CLIBC_16_FUNCTION_SEG_NAME),"CODE")
# endif
#else /* CLIBC_16_FN_CALL_FARCALL */
# ifndef fn_call_dist
#  define fn_call_dist __far
# endif
# if CLIBC_16_FN_CALL_FARCALL_SEG==CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
#  define fn_call_string __far __based(__segname(stringeyes(CLIBC_16_FUNCTION_SEG_NAME)))
#  ifndef CLIBC_16_CS
#   define CLIBC_16_CS code_seg(stringeyes(CLIBC_16_FUNCTION_SEG_NAME)),"CODE")
#  endif
# else /* CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE */
#  define fn_call_string __far __based(__segname(stringeyes_mult(CLIBC_16_FUNCTION_SEG_NAME)))
#  define CLIBC_16_CS_STRING code_seg(stringeyes_mult(CLIBC_16_FUNCTION_SEG_NAME)),"CODE")
#  define CLIBC_16_FUNCTION_SEG_NAME_STRING stringeyes_mult(CLIBC_16_FUNCTION_SEG_NAME))
# endif
#endif

/* end of "standard" part */
/* begin string.h specific */

#ifdef FASTCALL_STRING_ALL
# define FASTCALL_STRCPY
# define FASTCALL_STRCPY_SSS
# define FASTCALL_STRCPY_DSS
# define FASTCALL_STRLEN
# define FASTCALL_STRLEN_SSS
# define FASTCALL_SKIPSP
# define FASTCALL_SKIPSP_SSS
# define FASTCALL_SKIPTOSP
# define FASTCALL_SKIPTOSP_SSS
# define FASTCALL_STRCAT
# define FASTCALL_STRCAT_SSS
# define FASTCALL_STRCAT_DSS
# define FASTCALL_STRCMP
# define FASTCALL_STRCMP_SSS
# define FASTCALL_STRCMP_DSS
# define FASTCALL_STRCHR
# define FASTCALL_STRCHR_SSS
# define FASTCALL_STRSTR
# define FASTCALL_STRSTR_SSS
# define FASTCALL_STRSTR_DSS
# define FASTCALL_STRRCHR
# define FASTCALL_STRRCHR_SSS
# define FASTCALL_STRICMP
# define FASTCALL_SKIPSPR
# define FASTCALL_SKIPSPR_SSS
# define FASTCALL_SKIPTOSR
# define FASTCALL_SKIPTOSR_SSS
# define FASTCALL_STRLWR
# define FASTCALL_STRLWR_SSS
# define FASTCALL_STRUPR
# define FASTCALL_STRUPR_SSS
# define FASTCALL_STRNCPY
# define FASTCALL_STRNCPY_SSS
# define FASTCALL_STRNCPY_DSS
# define FASTCALL_STRNCAT
# define FASTCALL_STRNCAT_SSS
# define FASTCALL_STRNCAT_DSS
# define FASTCALL_MEMMOVE
# define FASTCALL_MEMMOVE_SSS
# define FASTCALL_MEMMOVE_DSS
# define FASTCALL_MEMSET
# define FASTCALL_MEMSET_SSS
# define FASTCALL_MEMCMP
# define FASTCALL_MEMCMP_SSS
# define FASTCALL_MEMCMP_DSS
#endif
#pragma message (stringeyes(fn_call_string))

/* strcpy */
#ifdef FASTCALL_STRCPY
char __near * __fastcall fn_call_string strcpy(char __near * const, const char __near * const);
#else
char __near * fn_call_string strcpy(char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRCPY
# define DEFINED_P_FN_STRCPY
  typedef char __near *	(fn_call_dist * P_FN_STRCPY)(char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRCPY
# define DEFINED_P_FN_FC_STRCPY
  typedef char __near *	(fn_call_dist __fastcall * P_FN_FC_STRCPY)(char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRCPY_SSS
char __near * __fastcall fn_call_string strcpy_sss(char __near * const, const char __near * const);
#else
char __near * fn_call_string strcpy_sss(char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRCPY_DSS
char __near * __fastcall fn_call_string strcpy_dss(char __near * const, const char __near * const);
#else
char __near * fn_call_string strcpy_dss(char __near * const, const char __near * const);
#endif

/* strlen */
#ifdef FASTCALL_STRLEN
size_t __fastcall fn_call_string strlen(const char __near * const);
#else
size_t fn_call_string strlen(const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRLEN
# define DEFINED_P_FN_STRLEN
  typedef size_t (fn_call_dist * P_FN_STRLEN)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRLEN
# define DEFINED_P_FN_FC_STRLEN
  typedef size_t (fn_call_dist __fastcall * P_FN_FC_STRLEN)(const char __near * const);
#endif

#ifdef FASTCALL_STRLEN_SSS
size_t __fastcall fn_call_string strlen_sss(const char __near * const);
#else
size_t fn_call_string strlen_ssss(const char __near * const);
#endif

/* skipsp */
#ifdef FASTCALL_SKIPSP
char __near * __fastcall fn_call_string skipsp(const char __near * const);
#else
char __near * fn_call_string skipsp(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPSP
# define DEFINED_P_FN_SKIPSP
  typedef char __near *	(fn_call_dist * P_FN_SKIPSP)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPSP
# define DEFINED_P_FN_FC_SKIPSP
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPSP)(const char __near * const);
#endif

#ifdef FASTCALL_SKIPSP_SSS
char __near * __fastcall fn_call_string skipsp_sss(const char __near * const);
#else
char __near * fn_call_string skipsp_sss(const char __near * const);
#endif

/* skiptosp */
#ifdef FASTCALL_SKIPTOSP
char __near * __fastcall fn_call_string skiptosp(const char __near * const);
#else
char __near * fn_call_string skiptosp(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPTOSP
# define DEFINED_P_FN_SKIPTOSP
  typedef char __near * (fn_call_dist * P_FN_SKIPTOSP)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPTOSP
# define DEFINED_P_FN_FC_SKIPTOSP
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPTOSP)(const char __near * const);
#endif

#ifdef FASTCALL_SKIPTOSP_SSS
char __near * __fastcall fn_call_string skiptosp_sss(const char __near * const);
#else
char __near * fn_call_string skiptosp_sss(const char __near * const);
#endif

/* strcat */
#ifdef FASTCALL_STRCAT
char __near * __fastcall fn_call_string strcat(char __near * const, const char __near * const);
#else
char __near * fn_call_string strcat(char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRCAT
# define DEFINED_P_FN_STRCAT
  typedef char __near * (fn_call_dist * P_FN_STRCAT)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRCAT
# define DEFINED_P_FN_FC_STRCAT
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRCAT)(const char __near * const);
#endif

#ifdef FASTCALL_STRCAT_SSS
char __near * __fastcall fn_call_string strcat_sss(char __near * const, const char __near * const);
#else
char __near * fn_call_string strcat_sss(char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRCAT_DSS
char __near * __fastcall fn_call_string strcat_dss(char __near * const, const char __near * const);
#else
char __near * fn_call_string strcat_dss(char __near * const, const char __near * const);
#endif

/* strcmp */
#ifdef FASTCALL_STRCMP
int __fastcall fn_call_string strcmp(const char __near * const, char __near * const);
#else
int fn_call_string strcmp(const char __near * const, char __near * const);
#endif

#ifndef DEFINED_P_FN_STRCMP
# define DEFINED_P_FN_STRCMP
  typedef int (fn_call_dist * P_FN_STRCMP)(const char __near * const, char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRCMP
# define DEFINED_P_FN_FC_STRCMP
  typedef int (fn_call_dist __fastcall * P_FN_FC_STRCMP)(const char __near * const, char __near * const);
#endif

#ifdef FASTCALL_STRCMP_SSS
int __fastcall fn_call_string strcmp_sss(const char __near * const, char __near * const);
#else
int fn_call_string strcmp_sss(const char __near * const, char __near * const);
#endif

#ifdef FASTCALL_STRCMP_DSS
int __fastcall fn_call_string strcmp_dss(const char __near * const, char __near * const);
#else
int fn_call_string strcmp_dss(const char __near * const, char __near * const);
#endif

/* strchr */
#ifdef FASTCALL_STRCHR
char __near * __fastcall fn_call_string strchr(const char __near * const,const int);
#else
char __near *	fn_call_string strchr(const char __near * const,const int);
#endif

#ifndef DEFINED_P_FN_STRCHR
# define DEFINED_P_FN_STRCHR
  typedef char __near * (fn_call_dist * P_FN_STRCHR)(const char __near * const,const int);
#endif

#ifndef DEFINED_P_FN_FC_STRCHR
# define DEFINED_P_FN_FC_STRCHR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRCHR)(const char __near * const,const int);
#endif

#ifdef FASTCALL_STRCHR_SSS
char __near * __fastcall fn_call_string strchr_sss(const char __near * const,const int);
#else
char __near *	fn_call_string strchr_sss(const char __near * const,const int);
#endif

/* strstr */
#ifdef FASTCALL_STRSTR
char __near * __fastcall fn_call_string strstr(const char __near * const, const char __near * const);
#else
char __near *	fn_call_string strstr(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRSTR
# define DEFINED_P_FN_STRSTR
  typedef char __near * (fn_call_dist * P_FN_STRSTR)(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRSTR
# define DEFINED_P_FN_FC_STRSTR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRSTR)(const char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRSTR_SSS
char __near * __fastcall fn_call_string strstr_sss(const char __near * const, const char __near * const);
#else
char __near *	fn_call_string strstr_sss(const char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRSTR_DSS
char __near * __fastcall fn_call_string strstr_sss(const char __near * const, const char __near * const);
#else
char __near *	fn_call_string strstr_sss(const char __near * const, const char __near * const);
#endif

/* strrchr */
#ifdef FASTCALL_STRRCHR
char __near * __fastcall fn_call_string strrchr(const char __near * const, const int);
#else
char __near * fn_call_string strrchr(const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_STRRCHR
# define DEFINED_P_FN_STRRCHR
  typedef char __near * (fn_call_dist * P_FN_STRRCHR)(const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_STRRCHR
# define DEFINED_P_FN_FC_STRRCHR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRRCHR)(const char __near * const, const int);
#endif

#ifdef FASTCALL_STRRCHR_SSS
char __near * __fastcall fn_call_string strrchr_sss(const char __near * const, const int);
#else
char __near * fn_call_string strrchr_sss(const char __near * const, const int);
#endif

/* stricmp */
#ifdef FASTCALL_STRICMP
int __fastcall fn_call_string stricmp(const char __near * const, const char __near * const);
#else
int fn_call_string stricmp(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRICMP
# define DEFINED_P_FN_STRICMP
  typedef int (fn_call_dist * P_FN_STRICMP)(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRICMP
# define DEFINED_P_FN_FC_STRICMP
  typedef int (fn_call_dist __fastcall * P_FN_FC_STRICMP)(const char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRICMP_SSS
int __fastcall fn_call_string stricmp_sss(const char __near * const, const char __near * const);
#else
int fn_call_string stricmp_sss(const char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRICMP_DSS
int __fastcall fn_call_string stricmp_dss(const char __near * const, const char __near * const);
#else
int fn_call_string stricmp_dss(const char __near * const, const char __near * const);
#endif

/* skipspr */
#ifdef FASTCALL_SKIPSPR
char __near * __fastcall fn_call_string skipspr(const char __near * const);
#else
char __near * fn_call_string skipspr(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPSPR
# define DEFINED_P_FN_SKIPSPR
  typedef char __near * (fn_call_dist * P_FN_SKIPSPR)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPSPR
# define DEFINED_P_FN_FC_SKIPSPR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPSPR)(const char __near * const);
#endif

#ifdef FASTCALL_SKIPSPR_SSS
char __near * __fastcall fn_call_string skipspr_sss(const char __near * const);
#else
char __near * fn_call_string skipspr_sss(const char __near * const);
#endif

/* skiptosr */
#ifdef FASTCALL_SKIPTOSR
char __near * __fastcall fn_call_string skiptosr(const char __near * const);
#else
char __near * fn_call_string skiptosr(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPTOSR
# define DEFINED_P_FN_SKIPTOSR
  typedef char __near * (fn_call_dist * P_FN_SKIPTOSR)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPTOSR
# define DEFINED_P_FN_FC_SKIPTOSR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPTOSR)(const char __near * const);
#endif

#ifdef FASTCALL_SKIPTOSR_SSS
char __near * __fastcall fn_call_string skiptosr_sss(const char __near * const);
#else
char __near * fn_call_string skiptosr_sss(const char __near * const);
#endif

/* strlwr */
#ifdef FASTCALL_STRLWR
char __near * __fastcall fn_call_string strlwr(char __near * const);
#else
char __near * fn_call_string strlwr(char __near * const);
#endif

#ifndef DEFINED_P_FN_STRLWR
# define DEFINED_P_FN_STRLWR
  typedef char __near * (fn_call_dist * P_FN_STRLWR)(char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRLWR
# define DEFINED_P_FN_FC_STRLWR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRLWR)(char __near * const);
#endif

#ifdef FASTCALL_STRLWR_SSS
char __near * __fastcall fn_call_string strlwr_sss(char __near * const);
#else
char __near * fn_call_string strlwr_sss(char __near * const);
#endif

/* strupr */
#ifdef FASTCALL_STRUPR
char __near * __fastcall fn_call_string strupr(char __near * const);
#else
char __near * fn_call_string strupr(char __near * const);
#endif

#ifndef DEFINED_P_FN_STRUPR
# define DEFINED_P_FN_STRUPR
  typedef char __near * (fn_call_dist * P_FN_STRUPR)(char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRUPR
# define DEFINED_P_FN_FC_STRUPR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRUPR)(char __near * const);
#endif

#ifdef FASTCALL_STRUPR_SSS
char __near * __fastcall fn_call_string strupr_sss(char __near * const);
#else
char __near * fn_call_string strupr_sss(char __near * const);
#endif

/* strncpy */
#ifdef FASTCALL_STRNCPY
char __near * __fastcall fn_call_string strncpy(char __near * const, const char __near * const, const size_t);
#else
char __near * fn_call_string strncpy(char __near * const, const char __near * const, const size_t);
#endif

#ifndef DEFINED_P_FN_STRNCPY
# define DEFINED_P_FN_STRNCPY
  typedef char __near * (fn_call_dist * P_FN_STRNCPY)(char __near * const, const char __near * const, const size_t);
#endif

#ifndef DEFINED_P_FN_FC_STRNCPY
# define DEFINED_P_FN_FC_STRNCPY
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRNCPY)(char __near * const, const char __near * const, const size_t);
#endif

#ifdef FASTCALL_STRNCPY_SSS
char __near * __fastcall fn_call_string strncpy_sss(char __near * const, const char __near * const, const size_t);
#else
char __near * fn_call_string strncpy_sss(char __near * const, const char __near * const, const size_t);
#endif

#ifdef FASTCALL_STRNCPY_DSS
char __near * __fastcall fn_call_string strncpy_dss(char __near * const, const char __near * const, const size_t);
#else
char __near * fn_call_string strncpy_dss(char __near * const, const char __near * const, const size_t);
#endif

/* strncat */
#ifdef FASTCALL_STRNCAT
char __near * __fastcall fn_call_string strncat(char __near * const, const char __near * const, const int);
#else
char __near * fn_call_string strncat(char __near * const, const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_STRNCAT
# define DEFINED_P_FN_STRNCAT
  typedef char __near * (fn_call_dist * P_FN_STRNCAT)(char __near * const, const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_STRNCAT
# define DEFINED_P_FN_FC_STRNCAT
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRNCAT)(char __near * const, const char __near * const, const int);
#endif

#ifdef FASTCALL_STRNCAT_SSS
char __near * __fastcall fn_call_string strncat_sss(char __near * const, const char __near * const, const int);
#else
char __near * fn_call_string strncat_sss(char __near * const, const char __near * const, const int);
#endif

#ifdef FASTCALL_STRNCAT_DSS
char __near * __fastcall fn_call_string strncat_dss(char __near * const, const char __near * const, const int);
#else
char __near * fn_call_string strncat_dss(char __near * const, const char __near * const, const int);
#endif

/* memmove */
#ifdef FASTCALL_MEMMOVE
void __near * __fastcall fn_call_string memmove(void __near * const, void __near * const, const int);
#else
void __near * fn_call_string memmove(void __near * const, void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_MEMMOVE
# define DEFINED_P_FN_MEMMOVE
  typedef void __near * (fn_call_dist * P_FN_MEMMOVE)(void __near * const, void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_MEMMOVE
# define DEFINED_P_FN_FC_MEMMOVE
  typedef void __near * (fn_call_dist __fastcall * P_FN_FC_MEMMOVE)(void __near * const, void __near * const, const int);
#endif

#ifdef FASTCALL_MEMMOVE_SSS
void __near * __fastcall fn_call_string memmove_sss(void __near * const, void __near * const, const int);
#else
void __near * fn_call_string memmove_sss(void __near * const, void __near * const, const int);
#endif

#ifdef FASTCALL_MEMMOVE_DSS
void __near * __fastcall fn_call_string memmove_dss(void __near * const, void __near * const, const int);
#else
void __near * fn_call_string memmove_dss(void __near * const, void __near * const, const int);
#endif

/* memset */
#ifdef FASTCALL_MEMSET
void __near * __fastcall fn_call_string memset(void __near * const, const int, const int);
#else
void __near * fn_call_string memset(void __near * const, const int, const int);
#endif

#ifndef DEFINED_P_FN_MEMSET
# define DEFINED_P_FN_MEMSET
  typedef void __near * (fn_call_dist * P_FN_MEMSET)(void __near * const, const int, const int);
#endif

#ifndef DEFINED_P_FN_FC_MEMSET
# define DEFINED_P_FN_FC_MEMSET
  typedef int (fn_call_dist __fastcall * P_FN_FC_MEMSET)(int);
#endif

#ifdef FASTCALL_MEMSET_SSS
void __near * __fastcall fn_call_string memset_sss(void __near * const, const int, const int);
#else
void __near * fn_call_string memset_sss(void __near * const, const int, const int);
#endif

/* memcmp */
#ifdef FASTCALL_MEMCMP
int __fastcall fn_call_string memcmp(const void __near * const, const void __near * const, const int);
#else
int fn_call_string memcmp(const void __near * const, const void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_MEMCMP
# define DEFINED_P_FN_MEMCMP
  typedef int (fn_call_dist * P_FN_MEMCMP)(const void __near * const, const void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_MEMCMP
# define DEFINED_P_FN_FC_MEMCMP
  typedef int (fn_call_dist __fastcall * P_FN_FC_MEMCMP)(const void __near * const, const void __near * const, const int);
#endif

#ifdef FASTCALL_MEMCMP_SSS
int __fastcall fn_call_string memcmp_sss(const void __near * const, const void __near * const, const int);
#else
int fn_call_string memcmp_sss(const void __near * const, const void __near * const, const int);
#endif

#ifdef FASTCALL_MEMCMP_DSS
int __fastcall fn_call_string memcmp_dss(const void __near * const, const void __near * const, const int);
#else
int fn_call_string memcmp_dss(const void __near * const, const void __near * const, const int);
#endif

/* external function pointers */
#if CLIBC_16_EXTERN_PTRS == CLIBC_16_EXTERN_PTRS_YES

/* strcpy */
extern P_FN_STRCPY const p_fn_strcpy;
extern P_FN_FC_STRCPY const p_fn_fc_strcpy;
extern P_FN_STRCPY const p_fn_strcpy_sss;
extern P_FN_FC_STRCPY const p_fn_fc_strcpy_sss;
extern P_FN_STRCPY const p_fn_strcpy_dss;
extern P_FN_FC_STRCPY const p_fn_fc_strcpy_dss;

/* strlen */
extern P_FN_STRLEN const p_fn_strlen;
extern P_FN_FC_STRLEN const p_fn_fc_strlen;
extern P_FN_STRLEN const p_fn_strlen_sss;
extern P_FN_FC_STRLEN const p_fn_fc_strlen_sss;

/* skipsp */
extern P_FN_SKIPSP const p_fn_skipsp;
extern P_FN_FC_SKIPSP const p_fn_fc_skipsp;
extern P_FN_SKIPSP const p_fn_skipsp_sss;
extern P_FN_FC_SKIPSP const p_fn_fc_skipsp_sss;

/* skiptosp */
extern P_FN_SKIPTOSP const p_fn_skiptosp;
extern P_FN_FC_SKIPTOSP const p_fn_fc_skiptosp;
extern P_FN_SKIPTOSP const p_fn_skiptosp_sss;
extern P_FN_FC_SKIPTOSP const p_fn_fc_skiptosp_sss;

/* strcat */
extern P_FN_STRCAT const p_fn_strcat;
extern P_FN_FC_STRCAT const p_fn_fc_strcat;
extern P_FN_STRCAT const p_fn_strcat_sss;
extern P_FN_FC_STRCAT const p_fn_fc_strcat_sss;
extern P_FN_STRCAT const p_fn_strcat_dss;
extern P_FN_FC_STRCAT const p_fn_fc_strcat_dss;

/* strcmp */
extern P_FN_STRCMP const p_fn_strcmp;
extern P_FN_FC_STRCMP const p_fn_fc_strcmp;
extern P_FN_STRCMP const p_fn_strcmp_sss;
extern P_FN_FC_STRCMP const p_fn_fc_strcmp_sss;
extern P_FN_STRCMP const p_fn_strcmp_dss;
extern P_FN_FC_STRCMP const p_fn_fc_strcmp_dss;

/* strchr */
extern P_FN_STRCHR const p_fn_strchr;
extern P_FN_FC_STRCHR const p_fn_fc_strchr;
extern P_FN_STRCHR const p_fn_strchr_sss;
extern P_FN_FC_STRCHR const p_fn_fc_strchr_sss;

/* strstr */
extern P_FN_STRSTR const p_fn_strstr;
extern P_FN_FC_STRSTR const p_fn_fc_strstr;
extern P_FN_STRSTR const p_fn_strstr_sss;
extern P_FN_FC_STRSTR const p_fn_fc_strstr_sss;
extern P_FN_STRSTR const p_fn_strstr_dss;
extern P_FN_FC_STRSTR const p_fn_fc_strstr_dss;

/* strrchr */
extern P_FN_STRRCHR const p_fn_strrchr;
extern P_FN_FC_STRRCHR const p_fn_fc_strrchr;
extern P_FN_STRRCHR const p_fn_strrchr_sss;
extern P_FN_FC_STRRCHR const p_fn_fc_strrchr_sss;

/* stricmp */
extern P_FN_STRICMP const p_fn_stricmp;
extern P_FN_FC_STRICMP const p_fn_fc_stricmp;
extern P_FN_STRICMP const p_fn_stricmp_sss;
extern P_FN_FC_STRICMP const p_fn_fc_stricmp_sss;
extern P_FN_STRICMP const p_fn_stricmp_dss;
extern P_FN_FC_STRICMP const p_fn_fc_stricmp_dss;

/* skipspr */
extern P_FN_SKIPSPR const p_fn_skipspr;
extern P_FN_FC_SKIPSPR const p_fn_fc_skipspr;
extern P_FN_SKIPSPR const p_fn_skipspr_sss;
extern P_FN_FC_SKIPSPR const p_fn_fc_skipspr_sss;

/* skiptosr */
extern P_FN_SKIPTOSR const p_fn_skiptosr;
extern P_FN_FC_SKIPTOSR const p_fn_fc_skiptosr;
extern P_FN_SKIPTOSR const p_fn_skiptosr_sss;
extern P_FN_FC_SKIPTOSR const p_fn_fc_skiptosr_sss;

/* strlwr */
extern P_FN_STRLWR const p_fn_strlwr;
extern P_FN_FC_STRLWR const p_fn_fc_strlwr;
extern P_FN_STRLWR const p_fn_strlwr_sss;
extern P_FN_FC_STRLWR const p_fn_fc_strlwr_sss;

/* strupr */
extern P_FN_STRUPR const p_fn_strupr;
extern P_FN_FC_STRUPR const p_fn_fc_strupr;
extern P_FN_STRUPR const p_fn_strupr_sss;
extern P_FN_FC_STRUPR const p_fn_fc_strupr_sss;

/* strncpy */
extern P_FN_STRNCPY const p_fn_strncpy;
extern P_FN_FC_STRNCPY const p_fn_fc_strncpy;
extern P_FN_STRNCPY const p_fn_strncpy_sss;
extern P_FN_FC_STRNCPY const p_fn_fc_strncpy_sss;
extern P_FN_STRNCPY const p_fn_strncpy_dss;
extern P_FN_FC_STRNCPY const p_fn_fc_strncpy_dss;

/* strncat */
extern P_FN_STRNCAT const p_fn_strncat;
extern P_FN_FC_STRNCAT const p_fn_fc_strncat;
extern P_FN_STRNCAT const p_fn_strncat_sss;
extern P_FN_FC_STRNCAT const p_fn_fc_strncat_sss;
extern P_FN_STRNCAT const p_fn_strncat_dss;
extern P_FN_FC_STRNCAT const p_fn_fc_strncat_dss;

/* memmove */
extern P_FN_MEMMOVE const p_fn_memmove;
extern P_FN_FC_MEMMOVE const p_fn_fc_memmove;
extern P_FN_MEMMOVE const p_fn_memmove_sss;
extern P_FN_FC_MEMMOVE const p_fn_fc_memmove_sss;
extern P_FN_MEMMOVE const p_fn_memmove_dss;
extern P_FN_FC_MEMMOVE const p_fn_fc_memmove_dss;

/* memset */
extern P_FN_MEMSET const p_fn_memset;
extern P_FN_FC_MEMSET const p_fn_fc_memset;
extern P_FN_MEMSET const p_fn_memset_sss;
extern P_FN_FC_MEMSET const p_fn_fc_memset_sss;

/* memcmp */
extern P_FN_MEMCMP const p_fn_memcmp;
extern P_FN_FC_MEMCMP const p_fn_fc_memcmp;
extern P_FN_MEMCMP const p_fn_memcmp_sss;
extern P_FN_FC_MEMCMP const p_fn_fc_memcmp_sss;
extern P_FN_MEMCMP const p_fn_memcmp_dss;
extern P_FN_FC_MEMCMP const p_fn_fc_memcmp_dss;

#endif /* external pointers */

/*
* MACROS DEFINED FOR USE UPON EXIT
* CLIBC_16_CS
*   Defined only if CLIBC_16_CS_STRING is not defined.
*   Defined only if CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE, or CLIBC_16_FN_CALL_NEARCALL
*   Contains the segment name containing all the functions.
* CLIBC_16_CS_STRING
*   Defined for use in #pragma code_seg CLIBC_16_CS_STRING
*   Defined only if CLIBC_16_CS is not defined.
*   Defined only if CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE.
* CLIBC_16_FUNCTION_SEG_NAME_STRING
*   Defined as a concat of strings to be used in __segname().
*   Defined only if CLIBC_16_CS is not defined.
*   Defined only if CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE.
* fn_call_string
*    call distance and base for functions in string group
*    equals all other fn_call_*, iff seg combine type is not multiple, and
*      function call distance is not far
* fn_call_dist
*    call distance for functions (__near, or __far)
*/
#endif /* CLIBC_16_STRING_H */
