; strncat_sss
;   AAA=str
;   BBB=015
;   F=0
;   O=1
; str01501.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strncat_sss:FN_CALL PTR
p_fn_strncat_sss P_FN_CALL strncat_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strncat_sss() -- Append strings, max length
;char __near * fn_call strncat_sss(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ss
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
BEGIN_CODE_SEGMENT <STRING>
strncat_sss PROC FN_CALL C USES ds es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov bx, ds
	    mov es, bx

	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es:di = p_str1

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat_sss ENDP
END_CODE_SEGMENT <STRING>
END
