; strcpy_sss
;   AAA=str
;   BBB=000
;   F=0
;   O=1
; str00001.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcpy_sss:FN_CALL PTR
p_fn_strcpy_sss P_FN_CALL strcpy_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcpy_sss() -- Copies string 2 to string 1, including null term char
;char __near * fn_call strcpy_sss(char const __near *, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ds
;   p_str2	near pointer, offset from ss
; RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
BEGIN_CODE_SEGMENT <STRING>
strcpy_sss PROC FN_CALL C USES si di es ds, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    mov di, [p_str1]	    ;es:di = p_str1 = destination
	    mov si, [p_str2]	    ;ds:si = p_str2 = source

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
strcpy_sss ENDP
END_CODE_SEGMENT <STRING>
END
