; skiptosp
;   AAA=str
;   BBB=003
;   F=
;   O=
; str003.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_skiptosp:FN_CALL PTR
p_fn_skiptosp P_FN_CALL skiptosp
EXTERNDEF C p_fn_fc_skiptosp:FN_CALL PTR
p_fn_fc_skiptosp P_FN_CALL @skiptosp
EXTERNDEF C p_fn_skiptosp_sss:FN_CALL PTR
p_fn_skiptosp_sss P_FN_CALL skiptosp_sss
EXTERNDEF C p_fn_fc_skiptosp:FN_CALL PTR
p_fn_fc_skiptosp_sss P_FN_CALL @skiptosp_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skiptosp - skip to next white space
; char __near * fn_call skiptosp(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
skiptosp PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skiptosp - skip to next white space
; char __near * __fastcall fn_call skiptosp(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, offset from ds
; RETURNS:
;   AX	    pointer to string, offset from ds
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@skiptosp PROC FN_CALL USES si
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
@skiptosp ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skiptosp_sss - skip to next white space
; char __near * fn_call skiptosp_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
skiptosp_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skiptosp_sss - skip to next white space
; char __near * __fastcall fn_call skiptosp_sss(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, offset from ss
; RETURNS:
;   AX	    pointer, offset from ss
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@skiptosp_sss PROC FN_CALL USES si
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
@skiptosp_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
