; skipsp
;   AAA=str
;   BBB=002
;   F=
;   O=
; str002.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_skipsp:FN_CALL PTR
p_fn_skipsp P_FN_CALL skipsp
EXTERNDEF C p_fn_fc_skipsp:FN_CALL PTR
p_fn_fc_skipsp P_FN_CALL @skipsp
EXTERNDEF C p_fn_skipsp_sss:FN_CALL PTR
p_fn_skipsp_sss P_FN_CALL skipsp_sss
EXTERNDEF C p_fn_fc_skipsp:FN_CALL PTR
p_fn_fc_skipsp_sss P_FN_CALL @skipsp_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skipsp - skip white space
; char __near * fn_call skipsp(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, (source) offset from ds
;		to the first non white space character in the string
;		if no more non white space characters in the string,
;		   then points to ending 0
; NOTES:
;   see isspace for the definition of a white space character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
skipsp PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE

    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
skipsp ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skipsp - skip white space
; char __near * __fastcall fn_call skipsp(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ds
; RETURNS:
;   AX	    pointer offset from ds
; NOTES:
;   see isspace for the definition of a white space character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@skipsp PROC FN_CALL USES si

    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
@skipsp ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skipsp_sss - skip white space
; char __near * fn_call skipsp_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, (source) offset from ss
;		to the first non white space character in the string
;		if no more non white space characters in the string,
;		   then points to ending 0
; NOTES:
;   see isspace for the definition of a white space character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
skipsp_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
skipsp_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS


; skipsp_sss - skip white space
; char __near * __fastcall fn_call skipsp_sss(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ss
; RETURNS:
;   AX	    pointer offset from ss
; NOTES:
;   see isspace for the definition of a white space character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@skipsp_sss PROC FN_CALL USES ds si
    mov ax, ss
    mov ds, ax
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
@skipsp_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
