/* strupr.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strupr.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strupr)
#endif

// strupr() -- Convert string to uppercase.
//  char * strupr(char * const)	; 
// GIVEN:
//	p_str	pointer to string to convert.
// RETURNS: (r8)
//	p_str	pointer to string converted.
// NOTES:
ret_ptr==r8
tmp==r11
p_str==r32
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strupr)
ilibc_64_proc_prologue
ilibc_64_proc_body
	mov ret_ptr=p_str
Loop:
	ld1 tmp=[p_str]
	cmp.gtu p30,p31='a',tmp
	(p30) br.cond.spnt NoChange
	cmp.ltu p30,p31='z',tmp
	(p30) br.cond.sptk NoChange
//	and tmp=0b11011111,tmp	// Generates an error! -33=-0x21=0b11011111
	and tmp=-33,tmp
NoChange:
	st1 [p_str]=tmp,1
	cmp.ne p30,p31=tmp,r0
	(p30) br.cond.sptk Loop
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strupr)
