/* stricmp.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"stricmp.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(stricmp)
#endif

// stricmp() -- Compare two strings case insensitive (lowercase).
//  int stricmp(const char * const, const char * const);
// GIVEN:
//	p_str1		String to compare.
//	p_str2		String to compare.
// RETURNS: (r8)
//	<0		p_str1<p_str2
//	0		p_str1=p_str2
//	>0		p_str1>p_str2
// NOTES:
//  converts them to lowercase prior to comparing them.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(stricmp)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str1==r32
p_str2==r33
ret_val==r8
tmp1==r10
tmp2==r11
	mov ret_val=r0
Loop:
	ld1 tmp1=[p_str1],1	// tmp1=*(p_str1++);
	ld1 tmp2=[p_str2],1	// tmp2=*(p_str2++);
	// force to lower case
	cmp.gtu p30,p31='A',tmp1
	(p30) br.cond.spnt NoChange1
	cmp.leu p30,p31='Z',tmp1
	(p30) or tmp1=0b00100000,tmp1
NoChange1:
	cmp.gtu p30,p31='A',tmp2
	(p30) br.cond.spnt NoChange2
	cmp.leu p30,p31='Z',tmp2
	(p30) and tmp1=-33,tmp2		// -33=-0x21=0b11011111
NoChange2:
	cmp.eq p30,p31=tmp1,tmp2
	(p30) br.cond.spnt Equal
	// Not Equal
	cmp.ltu p30,p31=tmp1,tmp2       // if(tmp1<tmp2)
	(p30) sub ret_val=ret_val,r0,1	// --ret_val
	(p31) add ret_val=ret_val,r0,1	// ++ret_val
	br.cond.sptk Exit
Equal:
	cmp.ne p30,p31=tmp1,r0	// if ((tmp1==tmp2)!=0)
	(p30) br.cond.sptk Loop	//  goto Loop
				// else done, and equal
Exit:
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(stricmp)
