/* strcpy.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strcpy.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strcpy)
#endif

// strcpy() -- Copies string 2 to string 1, including null term char
//  char * strcpy(char const *, const char * const); 
// GIVEN:
//	p_str1	pointer to destination string
//	p_str2	pointer to source string
// RETURNS: (r8)
//	p_str1
// NOTES:
// if strings overlap, undefined behavior
// if string pointers are equal, then returns
p_str1==r32
p_str2==r33
ret_ptr==r8
tmp==r11
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strcpy)
ilibc_64_proc_prologue
ilibc_64_proc_body
	mov ret_ptr=p_str1
	cmp.eq p30,p31=p_str1, p_str2
	(p30) br.cond.spnt.few.clr Exit
Loop:
	ld1 tmp=[p_str2],1	// ld1 tmp=[p_str2],1
	st1 [p_str1]=tmp,1	// st1 [p_str1]=tmp,1
//	add p_str1=p_str1,r0,1	// ++p_str1
//	add p_str2=p_str2,r0,1	// ++p_str2
	cmp.eq p30,p31=tmp, r0	// char == 0?
	(p31) br.cond.sptk.few Loop
Exit:
	ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strcpy)


