/* strchr.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strchr.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strchr)
#endif

// strchr() -- Search string for character.
//  char * strchr(const char * const,  const int) 
// GIVEN:
//	p_str	pointer to string to search
//	chr	character to search for
// RETURNS: (r8)
//	to the ending '\0', if char not found
//	to the character if found
// NOTES:
//  may search for '\0', and will return pointing to '\0'
ret_ptr==r8
tmp==r9
p_str==r32
chr==r33
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strchr)
ilibc_64_proc_prologue
ilibc_64_proc_body
	addl ret_ptr=0xFF, r0	// ensure only last char
	and chr=chr, ret_ptr
	mov ret_ptr=p_str
Loop:
	ld1 tmp=[ret_ptr],1
	cmp.eq p30,p31=r0,tmp	// [p_str]==0?
	(p31) br Loop
	sub ret_ptr=ret_ptr,r0,1
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strchr)











