/* string.h, clibc_16.lib */
/* Byron Young, 2002 */

#ifndef ILIBC_64_STRING_H
#define ILIBC_64_STRING_H

#include "ilibc_64/ilibc_64.h"
#include "ilibc_64/ilibc_64_ctypes.h"

/* strcpy */
char * strcpy(char * const, const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRCPY
# define DEFINED_P_FN_STRCPY
  typedef char * (* P_FN_STRCPY)(char * const, const char * const);
#endif

/* strlen */
size_t strlen(const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRLEN
# define DEFINED_P_FN_STRLEN
  typedef size_t (* P_FN_STRLEN)(const char * const);
#endif

/* skipsp */
char * skipsp(const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_SKIPSP
# define DEFINED_P_FN_SKIPSP
  typedef char * (* P_FN_SKIPSP)(const char * const);
#endif

/* skiptosp */
char * skiptosp(const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_SKIPTOSP
# define DEFINED_P_FN_SKIPTOSP
  typedef char * (* P_FN_SKIPTOSP)(const char * const);
#endif

/* strcat */
char * strcat(char * const, const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRCAT
# define DEFINED_P_FN_STRCAT
  typedef char * (* P_FN_STRCAT)(const char * const);
#endif

/* strcmp */
int strcmp(const char * const, char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRCMP
# define DEFINED_P_FN_STRCMP
  typedef int (* P_FN_STRCMP)(const char * const, char * const);
#endif

/* strchr */
char * strchr(const char * const,const int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRCHR
# define DEFINED_P_FN_STRCHR
  typedef char * (* P_FN_STRCHR)(const char * const,const int);
#endif

/* strstr */
char * strstr(const char * const, const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRSTR
# define DEFINED_P_FN_STRSTR
  typedef char * (* P_FN_STRSTR)(const char * const, const char * const);
#endif

/* strrchr */
char * strrchr(const char * const, const int) ilibc_64_code_section;
#ifndef DEFINED_P_FN_STRRCHR
# define DEFINED_P_FN_STRRCHR
  typedef char * (* P_FN_STRRCHR)(const char * const, const int);
#endif

/* stricmp */
int stricmp(const char * const, const char * const) ilibc_64_code_section;
#ifndef DEFINED_P_FN_STRICMP
# define DEFINED_P_FN_STRICMP
  typedef int (* P_FN_STRICMP)(const char * const, const char * const);
#endif

/* skipspr */
char * skipspr(const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_SKIPSPR
# define DEFINED_P_FN_SKIPSPR
  typedef char * (* P_FN_SKIPSPR)(const char * const);
#endif

/* skiptosr */
char * skiptosr(const char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_SKIPTOSR
# define DEFINED_P_FN_SKIPTOSR
  typedef char * (* P_FN_SKIPTOSR)(const char * const);
#endif

/* strlwr */
char * strlwr(char * const);

#ifndef DEFINED_P_FN_STRLWR
# define DEFINED_P_FN_STRLWR
  typedef char * (* P_FN_STRLWR)(char * const);
#endif

/* strupr */
char * strupr(char * const) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRUPR
# define DEFINED_P_FN_STRUPR
  typedef char * (* P_FN_STRUPR)(char * const);
#endif

/* strncpy */
char * strncpy(char * const, const char * const, const size_t) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRNCPY
# define DEFINED_P_FN_STRNCPY
  typedef char * (* P_FN_STRNCPY)(char * const, const char * const, const size_t);
#endif

/* strncat */
char * strncat(char * const, const char * const, const int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_STRNCAT
# define DEFINED_P_FN_STRNCAT
  typedef char * (* P_FN_STRNCAT)(char * const, const char * const, const int);
#endif

/* memmove */
void * memmove(void * const, void * const, const int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_MEMMOVE
# define DEFINED_P_FN_MEMMOVE
  typedef void * (* P_FN_MEMMOVE)(void * const, void * const, const int);
#endif

/* memset */
void * memset(void * const, const int, const int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_MEMSET
# define DEFINED_P_FN_MEMSET
  typedef void * (* P_FN_MEMSET)(void * const, const int, const int);
#endif

/* memcmp */
int memcmp(const void * const, const void * const, const int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_MEMCMP
# define DEFINED_P_FN_MEMCMP
  typedef int (* P_FN_MEMCMP)(const void * const, const void * const, const int);
#endif

/* external function pointers */
#if ILIBC_64_EXTERN_PTRS == ILIBC_64_EXTERN_PTRS_YES

/* strcpy */
extern P_FN_STRCPY const p_fn_strcpy;

/* strlen */
extern P_FN_STRLEN const p_fn_strlen;

/* skipsp */
extern P_FN_SKIPSP const p_fn_skipsp;

/* skiptosp */
extern P_FN_SKIPTOSP const p_fn_skiptosp;

/* strcat */
extern P_FN_STRCAT const p_fn_strcat;

/* strcmp */
extern P_FN_STRCMP const p_fn_strcmp;

/* strchr */
extern P_FN_STRCHR const p_fn_strchr;

/* strstr */
extern P_FN_STRSTR const p_fn_strstr;

/* strrchr */
extern P_FN_STRRCHR const p_fn_strrchr;

/* stricmp */
extern P_FN_STRICMP const p_fn_stricmp;

/* skipspr */
extern P_FN_SKIPSPR const p_fn_skipspr;

/* skiptosr */
extern P_FN_SKIPTOSR const p_fn_skiptosr;

/* strlwr */
extern P_FN_STRLWR const p_fn_strlwr;

/* strupr */
extern P_FN_STRUPR const p_fn_strupr;

/* strncpy */
extern P_FN_STRNCPY const p_fn_strncpy;

/* strncat */
extern P_FN_STRNCAT const p_fn_strncat;

/* memmove */
extern P_FN_MEMMOVE const p_fn_memmove;

/* memset */
extern P_FN_MEMSET const p_fn_memset;

/* memcmp */
extern P_FN_MEMCMP const p_fn_memcmp;

#endif /* ILIBC_64_EXTERN_PTRS */

#endif /* ILIBC_64_STRING_H */

