/* misc.h, ilibc_64.lib */
/* Byron Young, 2002 */

#ifndef ILIBC_64_MISC_H
#define ILIBC_64_MISC_H

#include "ilibc_64/ilibc_64.h"
#include "ilibc_64/ilibc_64_ctypes.h"

/* isspace */
int isspace(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISSPACE
# define DEFINED_P_FN_ISSPACE
  typedef int (* P_FN_ISSPACE)(int);
#endif

/* isalnum */
int isalnum(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISALNUM
# define DEFINED_P_FN_ISALNUM
  typedef int (* P_FN_ISALNUM)(int);
#endif

/* isalpha */
int isalpha(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISALPHA
# define DEFINED_P_FN_ISALPHA
  typedef int (* P_FN_ISALPHA)(int);
#endif

/* isascii */
int isascii(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISASCII
# define DEFINED_P_FN_ISASCII
  typedef int (* P_FN_ISASCII)(int);
#endif

/* iscntrl */
int iscntrl(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISCNTRL
# define DEFINED_P_FN_ISCNTRL
  typedef int (* P_FN_ISCNTRL)(int);
#endif

/* iscsym */
int iscsym(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISCSYM
# define DEFINED_P_FN_ISCSYM
  typedef int (* P_FN_ISCSYM)(int);
#endif

/* iscsymf */
int iscsymf(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISCSYMF
# define DEFINED_P_FN_ISCSYMF
  typedef int (* P_FN_ISCSYMF)(int);
#endif

/* isdigit */
int isdigit(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISDIGIT
# define DEFINED_P_FN_ISDIGIT
  typedef int (* P_FN_ISDIGIT)(int);
#endif

/* islower */
int islower(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISLOWER
# define DEFINED_P_FN_ISLOWER
  typedef int (* P_FN_ISLOWER)(int);
#endif

/* isupper */
int isupper(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISUPPER
# define DEFINED_P_FN_ISUPPER
  typedef int (* P_FN_ISUPPER)(int);
#endif

/* isxdigit */
int isxdigit(int) ilibc_64_code_section;

#ifndef DEFINED_P_FN_ISXDIGIT
# define DEFINED_P_FN_ISXDIGIT
  typedef int (* P_FN_ISXDIGIT)(int);
#endif

/* external function pointers */
#if ILIBC_64_EXTERN_PTRS == ILIBC_64_EXTERN_PTRS_YES
/* isspace */
extern P_FN_ISSPACE const p_fn_isspace;

/* isalnum */
extern P_FN_ISALNUM const p_fn_isalnum;

/* isalpha */
extern P_FN_ISALPHA const p_fn_isalpha;

/* isascii */
extern P_FN_ISASCII const p_fn_isascii;

/* iscntrl */
extern P_FN_ISCNTRL const p_fn_iscntrl;

/* iscsym */
extern P_FN_ISCSYM const p_fn_iscsym;

/* iscsymf */
extern P_FN_ISCSYMF const p_fn_iscsymf;

/* isdigit */
extern P_FN_ISDIGIT const p_fn_isdigit;

/* islower */
extern P_FN_ISLOWER const p_fn_islower;

/* isupper */
extern P_FN_ISUPPER const p_fn_isupper;

/* isxdigit */
extern P_FN_ISXDIGIT const p_fn_isxdigit;

#endif /* ILIBC_64_EXTERN_PTRS */

#endif /* ILIBC_64_MISC_H */


