%{
// $Header: c:\\misc\\src\\lex\\RCS/idl.l 1.5 1996-07-22 13:48:06-0700 ham Exp $
/* IDL - IfDefLevel indicator */
#include <stdio.h> // For fprintf, etc.
int  donecomment = 0;
int  hasbeenneg  = 0;
int  ifdeflevel  = 0;
int  maxdeflevel = 0;
%}

%x  COMMENT CPPCOMMENT ELSEELIF ENDIF IF
%%

 /* "Normal" C comments */
"/*"                    {printf("%2d---> ",ifdeflevel);
                         ECHO; donecomment = 1; BEGIN COMMENT;}
<COMMENT>.               yymore();
<COMMENT>\n             {ECHO; printf("%5d: %2d---> ",yy___lineno,ifdeflevel);}
<COMMENT>"*/"           {ECHO; BEGIN 0;}

 /* C++ style comments */
"//"                    {printf("%2d---> ",ifdeflevel); ECHO; BEGIN CPPCOMMENT;}
<CPPCOMMENT>.            yymore();
<CPPCOMMENT>\n          {ECHO; printf("%5d: ",yy___lineno); BEGIN 0;}

 /* ifdef, ifndef and if processing */
^[ \t]*"#"[ \t]*"ifdef"  |
^[ \t]*"#"[ \t]*"ifndef" |
^[ \t]*"#"[ \t]*"if"    {printf("%2d---> ",ifdeflevel); ifdeflevel++; 
                         if (ifdeflevel > maxdeflevel) maxdeflevel = ifdeflevel;
                         ECHO; BEGIN IF;}
<IF>.                    yymore();
<IF>\n                  {ECHO; printf("%5d: ",yy___lineno); BEGIN 0;}

 /* else and elif processing */
^[ \t]*"#"[ \t]*"else"   | 
^[ \t]*"#"[ \t]*"elif"  {ifdeflevel--; 
                         if (ifdeflevel < hasbeenneg) {
                             hasbeenneg = ifdeflevel;
                             fprintf(stderr,"Error: too many else/elif's detected at line %d\n",yy___lineno);
                             fprintf(stdout,"Error: too many else/elif's detected ");
                         }
                         printf("%2d---> ",ifdeflevel); ifdeflevel++; 
                         if (ifdeflevel > maxdeflevel) maxdeflevel = ifdeflevel;
                         ECHO; BEGIN ELSEELIF;}
<ELSEELIF>.              yymore();
<ELSEELIF>\n            {ECHO; printf("%5d: ",yy___lineno); BEGIN 0;}

 /* endif processing */
^[ \t]*"#"[ \t]*"endif" {ifdeflevel--; 
                         if (ifdeflevel < hasbeenneg) {
                             hasbeenneg = ifdeflevel;
                             fprintf(stderr,"Error: too many endif's detected at line %d\n",yy___lineno);
                             fprintf(stdout,"Error: too many endif's detected ");
                         }
                         printf("%2d---> ",ifdeflevel); ECHO; BEGIN ENDIF;}
<ENDIF>.                 yymore();
<ENDIF>\n               {ECHO; printf("%5d: ",yy___lineno); BEGIN 0;}

.                        yymore();

\n                      {if (!donecomment) printf("%2d---> ",ifdeflevel); 
                         donecomment = 0; ECHO; 
                         printf("%5d: ",yy___lineno);}

%%
main()
{
fprintf(stderr,"$Id: idl.l 1.5 1996-07-22 13:48:06-0700 ham Exp $\n");
yy___lineno++; printf("%5d: ",yy___lineno);
yylex();
fprintf(stdout,"\nMaximum ifdef level was %d\n",maxdeflevel);
if (hasbeenneg < 0) {
    fprintf(stderr,"There was/were %d more endif/else/elif's than matching if's detected\n",
                    hasbeenneg*-1);
    fprintf(stdout,"There was/were %d more endif/else/elif's than matching if's detected\n",
                    hasbeenneg*-1);
}
if (ifdeflevel && hasbeenneg >= 0) {
    fprintf(stderr,"There was/were %d more if/ifdef/ifndef's than matching endif's detected\n",
                    ifdeflevel);
    fprintf(stdout,"There was/were %d more if/ifdef/ifndef's than matching endif's detected\n",
                    ifdeflevel);
}
}

