/*
   Flat real mode for C/C++
   Copyright (C) 1999 Tobias Romann <t.rossmann@gmx.at>

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FLAT_H
#define __FLAT_H

#include <stdio.h>

/* version constants */
#define FLATC_VERSION 0x01
#define FLATC_SUB_VERSION 0x00
#define FLATC_VERSION_STR "1.00"

/* flat pointers, actually just a longs */
typedef long flatptr;

#ifdef __cplusplus
extern "C" {
#endif

/* basic functions */
int far init_flat (void);
void far exit_flat (void);
void far enable_a20 (void);
void far disable_a20 (void);

/* basic variables */
extern long em_avail;
extern unsigned em_max;
extern flatptr em_base, em_top;
extern int cpu_type;

/* memory access */
char far peekb32 (flatptr s);
long far peekw32 (flatptr s);
int far peekd32 (flatptr s);

void far pokeb32 (flatptr d, char c);
void far pokew32 (flatptr d, long l);
void far poked32 (flatptr d, int i);

flatptr far memchr32 (flatptr s, int i, long n);
long far memcmp32 (flatptr m1, flatptr m2, long n);
void far memcpy32 (flatptr d, flatptr s, long n);
void far memset32 (flatptr d, int i, long n);

/* memory management */

/* heap_node32 -- simply a long now */
typedef struct
  {
    long size;
  }heap32_node;

/* flag indicating a used memory block */
#define HEAP32_USED_BIT (0x80000000)

/* heap32_errno codes */
enum
  {
      HEAP32_ZERO, HEAP32_NOCONV, HEAP32_NOEXT, HEAP32_NOTFOUND
  };

flatptr malloc32 (long n);
void free32 (flatptr p);

void heap_sort (void);
int heap32_downsize (int n);

extern flatptr heap32_base;
extern long heap32_avail;
extern int heap32_max, heap32_items, heap32_errno;
extern heap32_node *heap32;

/* file access */
long fread32 (flatptr p, long n, FILE * fs);
long fwrite32 (flatptr p, long n, FILE * fs);

extern unsigned fbuf_size;
extern void far *fbuf_ptr;

#ifdef __cplusplus
}
#endif

/* a constant variable ;-) */
extern const int mem_mode;

/* misc. macros */
#ifndef MK_FP
#define MK_FP(seg,off) ((void far*)(((long)(seg)<<16)|(off)))
#endif

#ifndef FP_SEG
#define FP_SEG(ptr) ((unsigned)((long)(ptr)>>16))
#endif

#ifndef FP_OFF
#define FP_OFF(ptr) ((unsigned)(ptr))
#endif

#define MK_FPTR(seg, off) ((((flatptr)(seg)) << 4) + (off))
#define PTR2FPTR(ptr) (((flatptr) FP_SEG ((ptr))<<4) + FP_OFF ((ptr)))

#endif /* __FLAT_H */
