#include <dos.h>
#include "dostype.h"

extern void get_DTA(unsigned *,unsigned *),
            set_DTA(unsigned, unsigned);

findentr(DTA, search_name, s_attr)
struct DTA_STRUCT *DTA; /* NULL to use default DTA */
char *search_name;
int s_attr; /* permitted attributes (use for H,S,D) */
{
char far *far_sn=search_name;
struct DTA_STRUCT far *far_DTA=DTA;
union REGS inregs;
struct SREGS segregs;
unsigned save_DTA_SEG;
unsigned save_DTA_OFF;

if (DTA)
  {
  /* save current DTA address */
  get_DTA(&save_DTA_SEG,&save_DTA_OFF);
  /* set DTA address to argument structure */
  set_DTA(FP_SEG(far_DTA),FP_OFF(far_DTA));
  }

/* Find first match file */
inregs.h.ah=0x4e;
inregs.x.cx=s_attr;
segregs.ds=FP_SEG(far_sn);
inregs.x.dx=FP_OFF(far_sn);
int86x(0x21,&inregs,&inregs,&segregs);

if (DTA)
  /* restore DTA address */
  set_DTA(save_DTA_SEG,save_DTA_OFF);

/* return result */
if (inregs.x.cflag) return (inregs.x.ax);
else return 0;
}

findnext(DTA)
struct DTA_STRUCT *DTA; /* NULL to use default DTA */
{
struct DTA_STRUCT far *far_DTA=DTA;
union REGS inregs;
struct SREGS segregs;
unsigned save_DTA_SEG;
unsigned save_DTA_OFF;

if (DTA)
  {
  /* save current DTA address */
  get_DTA(&save_DTA_SEG,&save_DTA_OFF);
  /* set DTA address to argument structure */
  set_DTA(FP_SEG(far_DTA),FP_OFF(far_DTA));
  }

/* Find next entry */
inregs.h.ah=0x4f;
int86(0x21,&inregs,&inregs);

if (DTA)
  /* restore DTA address */
  set_DTA(save_DTA_SEG,save_DTA_OFF);

/* return result */
if (inregs.x.cflag) return (inregs.x.ax);
else return 0;
}
