/************  Listing 2  ********************** SVC.C ****************
*  svc.c --  Object Explorer, Service routines
*  Author:   Thomas E. Siering, 1991. See Listing 1 for copyright.
*  Usage:    These routines are general-purpose, not strictly related
*            to the Object Explorer software and reusable.                 
* 
*  Compiler: Microsoft C 6.0, Turbo C++ 1.0
* 
*  Compile time switches: none
* 
*  Links with: ox.c and apps.c
***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ox.h"       /* see Listing 4 */

/*-------------------------------------------------------------------
*  InstList  -- Instantiate a linked list.  Setting the InfoP pointer 
*      to NULL will identify this node as the header.  The list data
*      can be any type desired by client.
*------------------------------------------------------------------*/
PUBLIC void InstList(LNODE *ListHeader)
{
    ListHeader->InfoP = NULL;
    ListHeader->NextP = NULL;
}

/*----------------------------------------------------------------
*  AddListNode  --  Add a new node to existing linked list.
*      This linked list uses a little trick: the header's InfoP                
*      pointer field, since not otherwise utilized will point to               
*      the terminating list member thus avoiding a linear search.              
*      NOTE: This function will allocate space for the list node               
*      but NOT for the data put into list (since the data's type               
*      is of no concern to list manager).  If the client pollutes              
*      this memory (free()s it or clobbers it) disaster strikes!               
*----------------------------------------------------------------*/
PUBLIC LNODE AddListNode(LNODE ListHeader, void *NewData)
{
    LNODE *NewNode;

    if ((NewNode = (LNODE *) malloc(sizeof(LNODE))) == NULL) 
    {
        /* let the client worry about the consequences of this */
        ListHeader.InfoP = NULL;
        return (ListHeader);
    }
    NewNode->InfoP = NewData;
    NewNode->NextP = NULL;

    if (ListHeader.InfoP != NULL)
    /* link to last previous list element */
        ((LNODE *) ListHeader.InfoP)->NextP = NewNode;
    else
        ListHeader.NextP = NewNode;
    ListHeader.InfoP = NewNode;
    return (ListHeader);
}

/*-------------------------------------------------------------------
*   GetListNode  -- Retrieve a node from the linked list
*         NOTE: List node 0 is header and shouldn't need retrieval
*-------------------------------------------------------------------*/
PUBLIC LNODE *GetListNode(LNODE ListHeader, unsigned int NodeIdx)
{
    LNODE *NodeP = ListHeader.NextP;
    unsigned int   i;

    if (NodeIdx < 1)                /* nonsensical request */
        return (NULL);

    for (i = 1; i < NodeIdx; i++) 
    {
        NodeP = NodeP->NextP;
        if (NodeP == NULL)         /* erroneous index > last element */
            break;
    }
    return (NodeP);
}

/*----------------------------------------------------------------------
*   MakeASCIIZ  --  Convert string in Intel format (1 byte string length    
*        followed by actual string with no terminating 0) to ASCIIZ.
*----------------------------------------------------------------------*/
PUBLIC void *MakeASCIIZ(char *data)
{
    char *ASCIIZString;
    unsigned char StringLength;

    StringLength = *data++;

    if ((ASCIIZString = malloc((int) StringLength + 1)) == NULL)
        return (NULL);

    ASCIIZString[StringLength] = '\0';
    strncpy(ASCIIZString, data, StringLength);
    return (ASCIIZString);
}

/*-----------------------------------------------------------------
*   Output  --  Write to the output stream. This function adds an 
*     exception-handling layer to disk I/O. In addition, it handles
*     abnormal program termination, and warnings to both stderr and         
*     output. Three types of message can be handled:
*        Message - simply printed to a file                                    
*        Warning - print to file AND stderr                                    
*        Error - same as Warning, but terminate with abnormal exit code        
*-----------------------------------------------------------------*/
PUBLIC void Output(MESSAGETYPE MsgType, FILE *Stream, 
                    char *OutputFormat, ...)
{
    char OutputBuffer[133];
    va_list VarArgP;

    va_start(VarArgP, OutputFormat);
    vsprintf(OutputBuffer, OutputFormat, VarArgP);

    /* If this is (non-fatal) warning or (fatal) error, 
       then also send it to stderr */
    if (MsgType != Message)
        fprintf(stderr, "\a%s", OutputBuffer);

    /* In any case: attempt to print message to output file.  
       Exception check. */
    if ((size_t) fprintf(Stream, OutputBuffer) != strlen(OutputBuffer)) 
    {
        fprintf(stderr, "\aDisk Write Failure!\n");
        exit(0xFF);
    }

    /* If this was (fatal) error message, abort on the spot */
    if (MsgType == Error)
        exit(0xFF);

    va_end(VarArgP);
}