/* Listing 1. LEX.H -- Lexeme Definitions */

 typedef enum token      /* Token definitions.                        */
 {
     NO_TOKEN = -1, /*  Number not used as a token value.             */
     EOI      = 0,  /*  Reserve zero for end of input.                */
     EQUAL,         /*  =                                             */
     ID,            /*  string of alphanumerics, starting with alpha. */
     LP,            /*  (                                             */
     MINUS,         /*  -                                             */
     NUMBER,        /*  string of numeric characters                  */
     PLUS,          /*  +                                             */
     RP,            /*  )                                             */
     SEMI,          /*  ;                                             */
     SLASH,         /*  /                                             */
     STAR,          /*  *                                             */
     WHILE          /*  while                                         */
 }
 token ;

 extern int match( token t );    /* scanner functions in lex.c */
 extern void advance( void );
 extern char *yytext;            /* current lexeme (unterminated) */
 extern int  yyleng;             /* number of chars in lexeme     */