;
; startup code for the CC386 system.  This code provides the standard
; startup routines used by the CC386 compiler.  They are prefaced by
; init code to initialize TRAN's PMODE.
;
; This program is designed for use with TASM; in particular it uses
; the TLINK convention that if two segments are defined for the same
; class in the first .obj loaded the first is put at the BEGINNING of
; of the linked segment and the second is placed at the END.  I don't
; have any idea if MASM or the microsoft linker will deal with this
; in a way that will allow the code to work.
;
; This program:
;    1) Allocates memory
;    2) allocates and initializes descriptors
;    3) copies the C program into the allocated memory
;    4) runs the C program
;    5) cleans up
;    6) exits
;
; Copyright (c) 1997 LADsoft
;
; David Lindauer, camille@bluegrass.net
;
STACKLEN        EQU 40h                   ; size of stack in paragraphs
SELSTOALLOC 	EQU 4
MAXMEM		EQU 32

%macro GDTENTRY 3
	dw	%2 & 0ffffh
	dw	%1 & 0ffffh
	db	(%1 >> 16) & 0ffh
	dw	%3 | ((%2 >> 8) & 0f00h)
	db	%1 >> 24
%endmacro

segment	STUB_TEXT align=16 CLASS=TRAN use16
segment	PMODE_TEXT align=16 CLASS=TRAN use16
segment	EXE_STACK stack align=16 CLASS=STACK use16
;
; I USED to tack the stack on the end but Windows 95 has a bug so we
; have to embed it in the program data toward the beginning.  Because of
; the windows bug the max stack size is 64K
;
segment _TEXT class=CODE align=16 use32
		times	4096 resb 1
[extern __argv]
[extern __argc]
[extern __environ]
[extern _main]
[extern __stklen]

extern   _pm_info, _pm_init, _pm_rmstacks, _pm_pmstacks
extern	_pm_pagetables, _pm_mode
segment _CONST class=CONST align = 4 us32
segment _STRING class=STRING align=1 us32
segment cstartup class=INITDATA align=4 use32
InitStart:
segment _STARTUPEND_ class=INITDATA align=4 use32
InitEnd:
segment crundown class=EXITDATA align=4 use32
ExitStart:
segment _RUNDOWNEND_ class=EXITDATA align=4 use32
ExitEnd:
segment cppinit class=CPPINIT align=4 use32
CppStart:
		dd	cpproutine,130
segment _CPPEND_ class=CPPINIT align=4 use32
CppEnd:
segment cppexit class=CPPEXIT align=4 use32
CpprStart:
		dd	cpproutine,130
segment _CPPREND_ class=CPPEXIT align=4 use32
CpprEnd:
segment _DATA class=DATA align=4 use32
segment _BSS class=BSS align=4 use32
BssStart:
segment _BSSEND class=BSS align=4 use32
BssEnd:
                ENDS


group DGROUP _TEXT cstartup _STARTUPEND_ crundown _RUNDOWNEND_ cppinit _CPPEND_ _DATA _BSS _BSSEND

[global __rexit]
[global __rexita]
[global __stacktop]
[global __linear]
[global __rmseg]
[global __pmodew]
[global __isDLL]
[global __envseg]
[global __pspseg]

segment STUB_TEXT
;
;
; Header for external debuggers... must be FIRST THING after EXE header
;
%ifndef DEBUG
		dd	'XDBG'			; signature
		dd	'i386'
		dw	1			; some Version info
		dw	DGROUP			; to locate entry + globals
		dd	BssEnd	; to determine memory size
		dd	__stklen		; to determine stack size
		dd	start32	; true entry point
		dd	_main	; where to set a breakpoint
%endif
;
; local vars
;
banner    db  'Stub-386, Copyright (c) 1997-2003, LADsoft',10,13
		db	'DPMI subsystem Copyright (c) 1994, TRAN (Thomas Pytel)',10,13,'$'
errmsgtbl       dw      errmsg0,errmsg1,errmsg2,errmsg3
                dw      errmsg4,errmsg5,errmsg6,errmsg7

errmsg0         db      'Not enough low memory!',13,10,36
errmsg1         db      '80386 or better not detected!',13,10,36
errmsg2         db      'System already in protected mode and no VCPI or DPMI found!',13,10,36
errmsg3         db      'DPMI host is not 32bit!',13,10,36
errmsg4         db      'Could not enable A20 gate!',13,10,36
errmsg5         db      'Could not enter DPMI 32bit protected mode!',13,10,36
errmsg6         db      'Could not allocate needed DPMI selectors!',13,10,36
errmsg7		db	'MS-DOS 3.0 required for this program',10,13,'$'

nomemerr	db	'Not enough extended memory',10,13,36
initerr		db	'Unexpected error while initializing dpmi',10,13,36


regstruc_edi:
regstruc_di     dw      0,0
regstruc_esi:
regstruc_si     dw      0,0
regstruc_ebp:
regstruc_bp     dw      0,0
                dd      0
regstruc_ebx:
regstruc_bx:
regstruc_bl     db      0
regstruc_bh     db      0,0,0
regstruc_edx:
regstruc_dx:
regstruc_dl     db      0
regstruc_dh     db      0,0,0
regstruc_ecx:
regstruc_cx:
regstruc_cl     db      0
regstruc_ch     db      0,0,0
regstruc_eax:     
regstruc_ax:
regstruc_al     db      0
regstruc_ah     db      0,0,0
regstruc_flags  dw      0
regstruc_es     dw      0
regstruc_ds     dw      0
regstruc_fs     dw      0
regstruc_gs     dw      0
regstruc_ip     dw      0
regstruc_cs     dw      0
regstruc_sp     dw      0
regstruc_ss     dw      0

sel32		dw	0
selx		dw	0
psp		dw	0
modeval		db	0
newcodebase	dw	0
	align 4
linearbase	dd	0
blockhandle	dd	0
blocksize	dd	0

cdesc:
	GDTENTRY	0,0fffffh,0c09Ah	; 386 code
ddesc:
	GDTENTRY	0,0fffffh,0c096H	; 386 data, expand down
adesc:
	GDTENTRY	0,0fffffh,0c092H	; 386 data
;
;
; program start
;
..start:                                  ; execution starts here

        push cs                         ; DS = CS
        pop ds
	mov [psp],es
%ifdef	COPYRIGHT			; Joss
	mov dx,banner		; do the banner
	mov ah,9
	int 21h
%endif

	mov ah,30h   			; Check for dos 2.0
	int 21h
	cmp al,3
	jnc near @@dosok
	mov ax,7			; err if not
	jmp @@startf1

@@dosok:
;
; Init to try for VCPI
;
	mov	byte [_pm_pagetables],MAXMEM/4	; Max out at 32 MB
	mov	byte [_pm_mode],1		; select VCPI if it exists
	mov	byte [_pm_rmstacks],6
	mov	byte [_pm_pmstacks],6

        call far _pm_info                   ; get information
        jnc @@startf0             ; if no error, go on

@@startf1:
	mov si,ax			; print error message for code AX
        add si,ax
        mov dx,[errmsgtbl + si]
        mov ah,9
        int 21h
        mov ax,4cffh
        int 21h

@@startf0:
	call optimize_realmem		; optimize mem for spawns
	jnc near @@startf2
	sub	ax,ax    		; number for no mem error
	jmp 	@@startf1
@@startf2:
	mov [newcodebase],ax
	mov es,bx
	call far _pm_init			; enter protected mode
	jc near @@startf1			; if error, go to error message

;
; At this point we are in pmode
;
	mov [modeval],ch		; VCPI/DPMI/RAW/XMS flag
					; = 3 for DPMI, 2 for VCPI

	mov [psp],es			; save our PSP for later

	push ds
	pop es

	mov ax,cs       		; fix the priv levels of our descriptors
	and al,3	
	shl al,5
	or  byte [cdesc+5],al
	or  byte [ddesc+5],al
	or  byte [adesc+5],al
;
; Get program size
;
			     	
	mov ecx,BssEnd	; min mem program needs
					; 
	mov [blocksize],ecx
	mov ebx,ecx
	shr ebx,16
	
;
; Allocate memory for the program
;
; the program WILL run in extended memory
;
	mov ax,501h			; allocate memory and save the
	int 31h				; base address of it
	jnc near @@gotmem			; Should not get an error from this
					; but get out if we do
	jmp nomem
@@gotmem:
	mov ax,bx
	shl eax,16
	mov ax,cx
	mov [linearbase],eax
	mov ax,si
	shl eax,16
	mov ax,di
	mov [blockhandle],eax
;
; lock the memory
;
	mov eax,[linearbase]
	mov cx,ax
	shr eax,16
	mov bx,ax
	mov eax,[blocksize]
	mov di,ax
	shr eax,16
	mov si,ax
	mov ax,600h
	int 31h
;
; get selector increase value
;
	mov ax,3			; Now get the selector increase value
	int 31h
	mov [selx],ax
;
; Allocate selectors and initialize the descriptors for
; 32-bit segments
;
	mov ax,0			; Allocate the 32-bit selectors
	mov cx,SELSTOALLOC		; CODE, DATA/stack, 
	int 31h
	jc near initbad
	mov [sel32],ax

	mov bx,[sel32]			; set CS descriptr
	mov edi,cdesc		; 
	mov ax,000ch			;
	int 31h
	jc near initbad			; Should not get an error from this

	mov bx,[sel32]			; set DS descriptor
	mov edi,ddesc		; 
	add bx,[selx]
	mov ax,000ch
	int 31h
	jc near initbad			; Should not get an error from this
	
	mov bx,[sel32]			; set ABSOLUTE descriptor
	mov edi,adesc		; 
	add bx,[selx]
	add bx,[selx]
	mov ax,000ch
	int 31h
	jc near initbad			; Should not get an error from this

	mov bx,[sel32]			; set STACK descriptor
	mov edi,adesc		; 
	add bx,[selx]
	add bx,[selx]
	add bx,[selx]
	mov ax,000ch
	int 31h
	jc near initbad			; Should not get an error from this

; Set the base of the code and data segments to the linear address
; of the memory block
;
	mov eax,[linearbase]		; code segment
	mov dx,ax
	shr eax,16
	mov cx,ax
	mov bx,[sel32]
	mov ax,7
	int 31h
	jc near initbad
	
	mov eax,[linearbase]		; data segment
	mov dx,ax
	shr eax,16
	mov cx,ax
	mov bx,[sel32]
	add bx,[selx]
	mov ax,7
	int 31h
	jc near initbad
					; absolute segment already initted
;
; Set the limit of the code and data segments to the block size
;
	mov eax,[blocksize]		; code segment
	dec eax
	mov dx,ax
	shr eax,16
	mov cx,ax
	mov bx,[sel32]
	mov ax,8
	int 31h
	jc near initbad
	
	mov eax,0fffh			; data seg, expand up
	mov dx,ax
	shr eax,16
	mov cx,ax
	mov bx,[sel32]
	add bx,[selx]
	mov ax,8
	int 31h
	jc near initbad
					; absolute segment already initted
;
; blit the program to our memory block
;
	sub eax,eax			; calculate source
	mov ax,[newcodebase]
	shl eax,4
	mov esi,eax

	mov edi,[linearbase]		; calculate dest
	mov es,[psp]			; calculate len
	sub ecx,ecx
	mov cx,word [es:2]
	shl ecx,4
	sub ecx,esi
	cmp ecx,[blocksize]
	jc  near takeprog
	mov ecx,[blocksize]
takeprog:
	add 	esi,4096
	add	edi,4096
	sub	ecx,4096
	shr ecx,2			; guranteed to be paragraph multiple
	
	push ds				; switch to abs seg and do blit
	mov ax,[sel32]
	add ax,[selx]
	add ax,[selx]
	mov ds,ax
	mov es,ax
	cld
	db  67h				; shift us to 32 bits...
	rep movsd			; do the blit
	pop ds
	
;
; now call the 32-bit C0 routine
;
; must return with a RETF
;
	push ds

	push word 0  			; return address... returning from
	push cs				; a 32 bit segment so two dwords
	sub eax,eax
	mov ax,retpos
	push eax

	push word [sel32]			; address of 32-bit code
					; returning from this seg to 
	mov eax,start32 		; a 32-bit seg, two words
	push ax

	mov ax,[sel32]			; set up linear sel for DS load
	add ax,[selx]
	push ax
	sub eax,eax			; hi word of eax = raw/hosted flag
	cmp byte [modeval],3
	jc near nohost
	or eax,10000h
nohost:
	mov ax,_TEXT			; low word of eax = _TEXT
	mov es,[psp]        		; ES: PSP
	mov ebx,[sel32]			; EBX = stack seg
	add bx,[selx]
	add bx,[selx]
	add bx,[selx]
	mov ecx,[linearbase]		; ECX = base of pmode seg
	pop ds				; load linear sel
	
	retf

retpos:					; when 32-bit code exits with a retf
	pop ds				; we come here
	
	jc	nomem			; if they return with carry clear
					; not enough mem for stack	
getout:
	push ax				; save return code
	mov bx,[sel32]
	mov cx,SELSTOALLOC
	mov ax,1
selfrlp:
	pusha
	int 31h
	popa
	add bx,[selx]
	loop selfrlp

releasemem:
	mov eax,[blockhandle]		; Free the program block
	or eax,eax
	jz near endprog
;
; unlock the memory
;
	mov eax,[linearbase]
	mov cx,ax
	shr eax,16
	mov bx,ax
	mov eax,[blocksize]
	mov di,ax
	shr eax,16
	mov si,ax
	mov ax,601h
	int 31h
;
; release the memory
;
	mov eax,[blockhandle]		; Free the program block
	mov di,ax
	shr eax,16
	mov si,ax
	mov ax,502h
	int 31h

endprog:
	pop ax
        mov ah,4ch                      ; exit to DOS
        int 21h
nomem:
        mov word [regstruc_dx],nomemerr
	jmp puterr
initbad:
        mov word [regstruc_dx],initerr
puterr:
	call message
	mov al,0ffh			; error 255
	jmp getout

message:
        mov edi,regstruc_edi     ; offset of register structure
        xor cx,cx                       ; no parameters on stack
        mov bx,21h                      ; call interrupt 21h
        mov ax,300h                     ; INT 31h function 0300h

        mov byte [regstruc_ah],9               ; function code 9, put string
        mov word [regstruc_ds],STUB_TEXT           ; set DS:DX for DOS string put
        mov word [regstruc_ss],0               ; SS:SP = 0, PMODE will provide stack
        mov word [regstruc_sp],0

	push ds  
	pop es
        int 31h                         ; do the call to real mode
	ret

;
;
; real mode subroutines
;
optimize_realmem:
;
; check if we have space for the pmode data seg
;
	mov ax,[es:2]
	mov ecx,BssStart
	shr ecx,4
	sub ax,cx
	push ax
	jc near or_err
	sub ax,bx
	jc near or_err
	sub ax,STACKLEN
	jc near or_err
	sub ax,_TEXT
	jc near or_err
;
; now relocate the pmode program to end of real memory
;
	push ds
	push es
	mov ax,[es:2]
	sub ax,1000h
	mov es,ax
	mov di,0fffeh
	mov si,di
	mov eax,BssStart
	shr eax,4
	add ax,_TEXT
	sub ax,1000h
	mov ds,ax
	shl ecx,3
or_lp:
	std
	cmp ecx,8000h
	jbe near lastmv
	push ecx
	mov cx,8000h
	rep movsw
	pop ecx
	sub ecx,8000h
	mov ax,ds
	sub ax,1000h
	mov ds,ax
	mov ax,es
	sub ax,1000h
	mov es,ax
	jmp or_lp
lastmv:
	cmp	ax,0f000h
	jc	lastmvok
	neg	ax
	shl	ax,4
	sub	si,ax
	sub	ax,ax
	mov	ds,ax
lastmvok:
	rep movsw
	cld
	pop es
	pop ds
;
; calculate address of pmode data struct
;
	mov ax,_TEXT
	push ax
;
; resize memory
;
	add bx,ax
	sub bx,[psp]
	mov es,[psp]
	mov ah,4ah
	int 21h
	pop bx
	jc near or_err
	clc
or_err:
	pop ax
	ret

;
segment EXE_STACK
                times      STACKLEN*10h resb 1



segment	_DATA
                db      "Copyright (c) 1997-2003 LADsoft C runtime library"
		db	" (i386/DOS)"
	align 4
__linear	dd	0
__stacktop	dd	0
stackpos	times	3 dw 0
__rmseg		dw	0
__envseg        dw      0
__pspseg        dw      0
sseg		dw	0
stackhandhi	dw 	0
stackhandlo	dw	0
__pmodew  dd  1
__isDLL         dd      0

fsbase          dw      0       ; FS selector as we set it
          align 4
adesc2   equ $
	GDTENTRY	0,0fffffh,0c092H	; 386 data

xceptdata       dd      0       ; C++ xception data
destructorcnt   dd      0

threaddata      equ $
fsdata          dd      0                       ; windows xception data
                dd      threaddata

segment _TEXT
;
; C startup procedures
;
start32:
;
; save DTA and PSP
;
        mov [__pspseg],es
        mov ax,[es:02ch]
        mov [__envseg],ax
		mov [__linear],ecx	; linear mem base
		mov [sseg],bx		; save stack seg
                mov [__rmseg],ax	; real segment of real mode text
;
; Init fs and gs in case someone needs them
;
                cli
		mov 	eax,ds
		mov 	fs,eax
		mov	gs,eax
		mov	es,eax
                sti
;
; initialize FS to point to a windows-style thread struct
; they can reuse it if they don't want to do C++
;
                mov     bx,ds           ; get sel base
                mov     ax,6
                int     31h
                push    ecx
                push    edx

                mov     cx,1            ; allocate a selector
                sub     ax,ax
                int     31h
                mov     fs,ax
                mov     [fsbase],ax

                mov     ax,0ch          ; initialize descriptor
                mov     bx,fs
                mov     edi,adesc2
                int     31h 

                pop     edx
                pop     ecx
                shl     ecx,16
                mov     cx,dx
                add     ecx,fsdata
                mov     dx,cx
                shr     ecx,16
                mov     bx,fs           ; set base
                mov     ax,7
                int     31h

;
; allocate a stack
;
		mov	ebx,[__stklen]
		cmp	ebx,20*1024
		jnc	okstack
		mov	ebx,20*1024
okstack:
		mov	ecx,ebx
		shr	ebx,16
		mov	ax,501h
		int	31h
		jnc	gotstack
		stc			; no memory, say error
		retf
gotstack:
		mov	[stackhandhi],si
		mov	[stackhandlo],di
		push	ebx		; lock the region
		push	ecx
		mov	esi,[__stklen]
		mov	edi,esi
		shr	esi,16
		mov	ax,600h		; lock the region
		int	31h
		mov	ecx,[__linear]	
		mov	edx,ecx
		shr	ecx,16
		mov bx,[sseg]
		mov ax,7
		int 31h			; set the linear base of our stack sel
		pop	ecx
		pop	ebx
		shl	ebx,16
		mov	bx,cx
		sub	ebx,[__linear]
		add	ebx,[__stklen]
;
; initialize stack
;
		mov dword [stackpos],esp	; save old stack for later
		mov word [stackpos+4],ss
		cli
		movzx eax,word [sseg]		; set up stack
		mov ss,eax
		and ebx,0fffffffch		;
		sub ebx,4
		mov esp,ebx			;
		mov	[__stacktop],ebx
		sti
;
; Clear BSS
;
		mov	edi,BssStart
		mov	ecx,BssEnd
		sub	ecx,edi
		sub	eax,eax
		cld
		rep	stosb
;
; Execute startup routines
;
		push 	ds			; reset es to ds
		pop 	es
		mov	ecx,InitStart
		mov	edx,InitEnd
		call	sexproc
		cld
;
; Execute C++ class initializers
;
		mov	ecx,CppStart
		mov	edx,CppEnd
		call	sexproc
		cld
;
; Call main
;
		push	dword [__environ]
                push    dword [__argv]
		push	dword [__argc]
%ifdef DEBUG
		extern monitor_init
		call monitor_init
%endif
		call	_main
		add	esp,12

; exit/abort comes here
;
__rexit:
		push	eax		; saving C return code
;
; Execute C++ class rundown routines
;
		mov	ecx,CpprStart
		mov	edx,CpprEnd
		call	sexproc
		cld
;
; Execute rundown routines
;
		mov	ecx,ExitStart
		mov	edx,ExitEnd
		call	sexproc
;
; get original stack and exit
;
exitpos:
		pop	eax		; return code in EAX
__rexita:
		lss	esp,[stackpos]
		push	ax
		mov 	si,[stackhandhi]; free ours
		mov	di,[stackhandlo]
		mov	ax,502h
		int	31h
;
; release our FS selector
;
                mov     ax,ds
                mov     fs,ax
                mov     bx,[fsbase]
                mov     ax,1
                int     31h
;
; finish up
;
		pop	ax
		clc
		retf			; exit back to the 16-bit seg
;
; Handle startup/rundown routines
;
sexproc:
		cmp	ecx,edx		
		jz	short sexpdone	
		mov	edi,ecx
		sub	ebx,ebx
		sub	eax,eax
spl2:
		cmp	edi,edx
		jz	short spo
		test	dword [edi+4],-1
		jz	short spl3
		cmp	eax,[edi+4]
		jnc	short spl3
		mov	ebx,edi
		mov	eax,[edi+4]
spl3:
		add	edi,8
		jmp	spl2
spo:
		or	ebx,ebx
		jz	short sexpdone
		mov	dword [ebx+4],0
		push	edx
		push	ecx
		call	dword [ebx]
		pop	ecx
		pop	edx
		jmp	sexproc
sexpdone:
		ret

; This is called as the first thing from the C++ main routine
cpproutine:
		ret