/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
 return(       cos(x));
}
char  feq[] = " cos(x)";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
 return(  (-sin(x)) );
}
char Dfeq[] = " (-sin(x)) ";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);

double c = -1.0;
double t;
/*-------------------------------- PROGRaM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf("  f : x-> %s\n\n", feq);
 printf(" Df : x-> %s\n\n",Dfeq);

 printf("\n\n With c = %0.3lf, the equation of the tangent is :\n\n",c);
 printf("       Df(c) (x-c) + f(c) = ");
 eq_Tan(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );

 printf("\n\n the equation of the  normal is :\n\n");
 printf("    -1/Df(c) (x-c) + f(c) =");
 eqNorm(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );
 printf("\n\n");
 getchar();

 clrscrn();
 printf(" Find PB, the length of the normal from P to the y axis.\n\n");

 t = ((*Pfunct)(c));
 printf(" P(%6.3lf, %6.3lf)    -> P(c, f(c))            \n", c, t);

 t = ((*Pfunct)(c))+c/((*PfunctDeriv)(c));
 printf(" B(%6.3lf, %6.3lf)    -> B(0, f(c)+c/Df(c)  \n\n",0., t);

 t = c*sqrt(1+(1/pow(((*PfunctDeriv)(c)),2)));
 printf(" PB  = %6.3lf         -> c sqrt(1+ 1/Df(c)**2)   ", t);

     gplt_NormPy(-3.5,      /* xmin  plot [xmin:xmax] [ymin:ymax] */
                  3.5,      /* xmax  */
                 -3.0,      /* ymin  */
                  3.0,      /* ymax  */
                 c,
               feq,
         (*Pfunct),
         (*PfunctDeriv)
              );

 printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
 printf("  * open the file f_Df.plt with Gnuplot.\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

