/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <direct.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>


extern char **_argv;  /* if not in Borland */

char optfilename[_MAX_PATH];


/***
 *
 *  Function   :    load_options
 *
 *  Topics     :    Load options from a file.
 *
 *  Decisions  :    The file has the same name as the program
 *                  with extension .OPT and is searched in
 *                  current directory, then in program directory.
 *                  If option file is not found, options are not modified.
 *
 *  Parameters :    out  void * options     ptr to variable containing options
 *                  in   size_t size        size of data to read
 *
 *  Return     :    number of bytes read
 *                  -1 if file was not found
 *
 ***/

int load_options( void *options, size_t size )

{ char *ptr;
  FILE *optfile;
  int r;

  strcpy( optfilename, _argv[0] );
  fnreduce( optfilename );
  ptr = strrchr( optfilename, '.' ) + 1;
  strcpy( ptr, "OPT" );

  ptr = strrchr( optfilename, '\\' ) + 1;
  optfile = fopen( ptr, "rb" );
  if ( optfile ) { strcpy( optfilename, ptr );
                   fnreduce( optfilename );
                 }
            else {
                   optfile = fopen( optfilename, "rb" );
                   if ( ! optfile ) { *optfilename = '\0';
                                      return -1;
                                    }
                 }

  r = fread( options, 1, size, optfile );
  fclose( optfile );
  return r;
}



/***
 *
 *  Function   :    save_options
 *
 *  Topics     :    Save options into a file.
 *
 *  Decisions  :    If options were previously loaded, this file is used.
 *                  Otherwise, the file has the same name as the program
 *                  with extension .OPT and is located in program directory.
 *
 *  Parameters :    in  void * options     ptr to variable containing options
 *                  in  size_t size        size of data to read
 *
 *  Return     :    number of bytes written
 *                  -1 if file not opened
 *
 ***/

int save_options( const void *options, size_t size )

{ char *ptr;
  FILE *optfile;
  int r;

  if ( ! *optfilename )
     {
       strcpy( optfilename, _argv[0] );
       fnreduce( optfilename );
       ptr = strrchr( optfilename, '.' ) + 1;
       strcpy( ptr, "OPT" );
     }

  optfile = fopen( optfilename, "wb" );
  if ( ! optfile ) return -1;

  r = fwrite( options, 1, size, optfile );
  fclose( optfile );
  return r;
}
