/*
 * make.h
 *
 * 88-10-01 v1.0	created	by greg	yachuk,	placed in the public domain
 * 88-10-06 v1.1	changed	prerequisite list handling
 *
 */

#define	MAXNEGTIME	0x80000000

#ifndef	TRUE
#define	TRUE	(1)
#define	FALSE	(!TRUE)
#endif

#define	equal(s,t)			(!strcmp((s),(t)))
#define	get_target(t)		hash_target((t), NULL)
#define	get_file(f)			hash_file((f), NULL)
#define	append_preq(t,p)	(fileptr*)append_node((char**)(t),(char**)(p),sizeof(fileptr*))
#define	append_shell(t,s)	(shellptr*)append_node((char**)(t),(char**)(s),sizeof(shellptr*))

typedef	unsigned short t_mask;

typedef	struct targnode
{
	t_mask	tmask;				/* mask	to avoid string	compares */
	struct targnode	*tnext;		/* next	target in global target	list */
	struct filenode	*tfile;		/* file	node for this target */
	struct filenode	**tpreq;	/* pre-req list	for this target	*/
	struct shellnode **tshell;	/* command list	for this target	*/
}	targnode, *targptr;

typedef	struct filenode
{
	t_mask	fmask;				/* mask	to avoid string	compares */
	char   *fname;				/* name	of this	file (targ, preq...) */
	long	ftime;				/* last	MODIFY time for	this file */
	struct filenode	*fnext;		/* next	file node in global file list */
}	filenode, *fileptr;

typedef	struct shellnode
{
	char   *scmd;				/* text	of command */
	struct shellnode *snext;	/* next	shell node for a target	*/
	struct shellnode *slink;	/* next	shell node in global list */
	unsigned char s_silent:1;	/* don't echo before executing */
	unsigned char s_ignore:1;	/* ignore exit status */
	unsigned char s_shell:1;	/* force spawning of command.com */
}	shellnode, *shellptr;

typedef	struct symnode
{
	t_mask	smask;				/* mask	to avoid string	compares */
	char   *sname;				/* name	of a symbol */
	char   *svalue;				/* value of a symbol */
	short	senv;				/* flag	environment variable */
	struct symnode *snext;		/* next	symbol node in global list */
}	symnode, *symptr;

extern targptr target_list;		/* global list of targets */
extern fileptr file_list;		/* global list of file nodes */
extern symptr  symbol_list;		/* global list of symbol nodes */
extern shellptr	shell_list;		/* global list of shell	nodes */

extern targptr first_targ;		/* first target	(if nothing named) */
extern targptr suffix_targ;		/* target node of ".SUFFIXES" */

extern short debug;				/* -d */
extern short touchenv;			/* -e */
extern short ignore;			/* -i */
extern short single_ign;		/* -k */
extern short noexec;			/* -n */
extern short readdef;			/* -r */
extern short silent;			/* -s */
extern short touch;				/* -t */
extern short display;			/* -D */

#ifndef	MSDOS
char   *getenv();
#define	P_WAIT		1
#define	P_NOWAIT	2
#define	P_OVERLAY	3
#endif

#define	REGISTER	register
