/* Program LCDFonts  -  Must be compiled using a SMALL memory model */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>

int main()
{
   const INTER_ROWS = 20;                    /* Blank pixels between two rows */
   const char *PATH_TO_BGI = "C:\\BC\\BGI";  /* Insert your path here! */
   const char *FONT_NAME[4] = {"LCNE", "LCDN", "LCLE", "LCDL"};

   int driver, mode, err;
   int user_font[4];
   int i;


   for (i = 0; i < 4; i++)
   {
      user_font[i] = installuserfont(FONT_NAME[i]);
      if (graphresult() != grOk)
      {
	 printf("Error installing %s", FONT_NAME[i]);
	 return 1;
      }
   }

   driver = DETECT;
   initgraph(&driver, &mode, PATH_TO_BGI);
   err = graphresult();
   if (err != grOk)
   {
      printf("Graphics error: %s\n", grapherrormsg(err));
      return 1;
   }

   bar(0,0, getmaxx(),getmaxy());    /* White background */
   setcolor(BLACK);
   settextjustify(LEFT_TEXT, TOP_TEXT);
   moveto(30,30);

   for (i = 0; i < 4; i++)
   {
      settextstyle(user_font[i], HORIZ_DIR, 4);
      err = graphresult();
      if (err != grOk)
      {
	 closegraph();
	 printf("Graphics error: %s\n", grapherrormsg(err));
	 return 1;
      }
      outtext("0123456789");
      moveto(30, gety() + textheight("0") + INTER_ROWS);
   }

   settextjustify(CENTER_TEXT, TOP_TEXT);
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
   outtextxy(getmaxx() / 2, getmaxy() - 20, "* PRESS ENTER *");

   getch();                  /* wait for a key */
   while (kbhit()) getch();  /* empty buffer */
   closegraph();
   return 0;
}
