#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*        Reactions dialog box       */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwtop.h"						/* macros, function prototypes, etc.	*/
#include "gep1.h"						/* gepasi's variables					*/
#include "topgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE2, ClearReactions, AddReactLst, EdReact )

void ClearReactions( void )
{
 int i, j;

 for( i=0; i<totmet; i++ )
 {
  metname[i][0] = '\0';
  intmet[i] = 1;
  for( j=0; j<nsteps; j++ )
   stoiu[i*MAX_MET + j] = 0;
 }
 for( i=0; i<nsteps; i++ )
  for( j=0; j<MAX_MOL; j++ )
   (*rs)[i][j] = 0;
 nsteps  = 0;
 totmet  = 0;
}


void AddReactLst( HWND hControl, int j, int is_index, int scroll,
				  int *totm, char (huge *metn)[NAME_L],
				  int huge *sto, int *im, unsigned char *rev,
				  int (huge *rs)[MAX_STEP][MAX_MOL] )
{
 int i, k, st, first, buffWidth, tempstoi[MAX_MET];
 char auxstr[256], buff[256];
 HANDLE hDC;

 *buff = '\0';
 /* setup the stoicheiometries of the substrates					*/
 for( i=0; i<*totm; i++ ) tempstoi[i] = 0;
 for( i=0; i<MAX_MOL; i++ )
  if ((*rs)[j][i]<0) tempstoi[ -(*rs)[j][i]-1 ]--;
 for( k=0, first=1; k<MAX_MOL; k++ )
 {
  if ((*rs)[j][k]<0)
  {
   i = -(*rs)[j][k]-1;
   st = tempstoi[i];
   if( st < 0 )
   {
    if ( st == -1 )
     wsprintf( auxstr, "%s%s", first==1 ? (LPSTR) "" : (LPSTR) " + ", &metn[i][0] );
    else
     wsprintf( auxstr, "%s%i*%s", first==1 ? (LPSTR) "" : (LPSTR) " + ", -st, &metn[i][0] );
    _fstrcat( buff, auxstr );
    first = 0;
   }
   for( ; (i == -(*rs)[j][k]-1) && (k<=MAX_MOL) ; k++);
   k--;
  }
 }
 if( rev[j] )											/* the connector		*/
  _fstrcat( buff, " = " );
 else
  _fstrcat( buff, " -> " );

 /* setup the stoicheiometries of the products						*/
 for( i=0; i<*totm; i++ ) tempstoi[i] = 0;
 for( i=0; i<MAX_MOL; i++ )
  if ((*rs)[j][i]>0) tempstoi[ (*rs)[j][i]-1 ]++;
 for( k=0, first=1; k<MAX_MOL; k++ )
 {
  if ((*rs)[j][k]>0)
  {
   i = (*rs)[j][k]-1;
   st = tempstoi[i];
   if( st > 0 )
   {
    if( st == 1 )
     wsprintf( auxstr, "%s%s", first==1 ? (LPSTR) "" : (LPSTR) " + ", &metn[i][0] );
    else
     wsprintf( auxstr, "%s%i*%s", first==1 ? (LPSTR) "" : (LPSTR) " + ", st, &metn[i][0] );
    _fstrcat( buff, auxstr );
    first = 0;
   }
   for( ; (i == (*rs)[j][k]-1) && (k<=MAX_MOL) ; k++);
   k--;
  }
 }

 hDC = GetDC( hControl );
 buffWidth = 5 + LOWORD( GetTextExtent( hDC, buff, _fstrlen(buff) ) );
 SetTextJustification( hDC, 0, 0 );
 ReleaseDC( hControl, hDC );
 if( buffWidth > lbWidth )
 {
  lbWidth = buffWidth;
  SendMessage( hControl, LB_SETHORIZONTALEXTENT, lbWidth, (DWORD) 0 );
 }
 if( is_index )
 {
  SendMessage( hControl, LB_DELETESTRING, j, 0 );
  SendMessage( hControl, LB_INSERTSTRING, j, (DWORD) (LPSTR) buff );
 }
 else
  SendMessage( hControl, LB_INSERTSTRING, -1, (DWORD) (LPSTR) buff );
 if( scroll ) SendMessage( hControl, WM_VSCROLL, SB_BOTTOM, 0 );
}

/*
  EdReact - dialog box procedure for TOP_PARSER dialog box
*/

BOOL FAR PASCAL EdReact( HWND hDlg, WORD message, WORD wParam, LONG lParam )
{
 static HWND   hEditBox, hReacLst, hStepNam;
 char	buffer[256], buff2[256], step_name[NAME_L];
 int 	i, j, nr, rv;
 static int idx;


 switch( message )
 {
  case WM_INITDIALOG:                                   /*message: initialize dialog box        */

   lbWidth = 0;											/* set the width of the list box to 0	*/
   idx = -1;											/* set an invalid alteration index		*/

   /* get handles to the controls							*/
   hEditBox = GetDlgItem( hDlg, IDC_REACT );
   hReacLst = GetDlgItem( hDlg, IDC_REACTLST );
   hStepNam = GetDlgItem( hDlg, IDC_REACTNAM );

   /* setup the mirrors										*/
   _fmemcpy( (void __far *) metn,
   	         (void __far *) metname,
   	         (size_t) MAX_MET * NAME_L * sizeof( char ) );
   _fmemcpy( (void __far *) stepn,
   	         (void __far *) stepname,
   	         (size_t) MAX_STEP * NAME_L * sizeof( char ) );
   _fmemcpy( (void __far *) sto,
   	         (void __far *) stoiu,
             (size_t) MAX_MET * MAX_STEP * sizeof( int ) );
   _fmemcpy( (void __far *) lp,
   	         (void __far *) loop,
             (size_t) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
   _fmemcpy( (void __far *) intm,
   			 (void __far *) intmet,
   			 (size_t) MAX_MET * sizeof( int ) );
   _fmemcpy( (void __far *) kinet,
   	         (void __far *) kinetu,
             (size_t) MAX_STEP * sizeof( int ) );
   _fmemcpy( (void __far *) nmd,
 	         (void __far *) nmod,
             (size_t) MAX_STEP * sizeof( unsigned char ) );
   _fmemcpy( (void __far *) rvr,
 	         (void __far *) revers,
             (size_t) MAX_STEP * sizeof( unsigned char ) );
   _fmemcpy( (void __far *) rs,
 	         (void __far *) rstr,
             (size_t) MAX_STEP * MAX_MOL * sizeof( int ) );
   nst = nsteps;
   totm = totmet;
   nlps = nloops;
   kass = kinass;
   lass = loopass;

   /* add all steps to the list box										*/
   for( j=0; j<nst; j++ ) AddReactLst( hReacLst, j, 1, (j==nst), &totm, metn, sto, intm, rvr, rs );

   /* write the name of the new reaction in the name edit box			*/
   wsprintf( (LPSTR) step_name, "R%d", nst+1 );
   SendMessage( hStepNam, WM_SETTEXT, 0, (DWORD) (LPSTR) step_name );

   return( TRUE );

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_ADD:
     SendMessage( hEditBox, WM_GETTEXT, 256, (DWORD) (LPSTR) buffer );
     if( idx == -1 )                                    /* new item		*/
     {
      /* verify if we reached the maximum number of steps				*/
      if( nst == MAX_STEP )
      {
       LoadString(hInst, IDS_ERR_STEP_EXCEED, szString, sizeof(szString));
       MessageBeep( MB_OK );
       MessageBox(NULL, szString, NULL, MB_ICONINFORMATION);
       return( TRUE );
      }
      /* if not assign the next step number to this one					*/
      j = nst;
     }
     else j = idx;										/* alterion		*/
     rv = reaction( buffer, j, &totm, metn, sto, rs, intm, rvr );
     if( rv == -2 )
     {
      LoadString(hInst, IDS_ERR_MET_EXCEED, szString, sizeof(szString));
      MessageBeep( MB_OK );
      MessageBox(NULL, szString, NULL, MB_ICONINFORMATION);
      return( TRUE );
     }
     if( rv == 0 )
     {
      SendMessage( hStepNam, WM_GETTEXT, NAME_L, (DWORD) (LPSTR) stepn[j] );
      AddReactLst( hReacLst, j, 1, (j==nst), &totm, metn, sto, intm, rvr, rs );
      if ( idx == -1 ) nst++;
      else
      {
       idx = -1;								/* reset idx			*/
       if( ktype[kinet[j]].nmodf>0 )			/* if there were modfs	*/
       {
        nlps--;
        for(i=0;i<MAX_MET;i++) (*lp)[j][i] = 0;	/* reset row of loop	*/
        if( ktype[kinet[j]].nmodf == nmd[j] ) lass--;	/* decrease lass				*/
       }
       if( kinet[j] != NOT ) kass --;
       kinet[j] = 0;							/* reset kinetic type	*/
      }
      /* clear the reaction edit box									*/
      SetWindowText( hEditBox, (LPSTR) "" );
      /* write the name of the new reaction in the name edit box		*/
      wsprintf( (LPSTR) step_name, "R%d", nst+1 );
      SendMessage( hStepNam, WM_SETTEXT, 0, (DWORD) (LPSTR) step_name );
     }
     else
     {
      LoadString(hInst, IDS_ERR_SYNTAX, szString, sizeof(szString));
      MessageBox(NULL, szString, NULL, MB_ICONINFORMATION);
     }
     return( TRUE );

    case IDC_DEL:
     if( ( idx = (int) SendMessage( hReacLst, LB_GETCURSEL, 0, 0 ) ) == LB_ERR )
     {
      LoadString(hInst, IDS_ERR_DEL, szString, sizeof(szString));
      MessageBox(NULL, szString, NULL, MB_ICONINFORMATION);
     }
     if( SendMessage( hReacLst, LB_DELETESTRING, idx, 0 ) == LB_ERR )
     {
      LoadString(hInst, IDS_ERR_DEL, szString, sizeof(szString));
      MessageBox(NULL, szString, NULL, MB_ICONINFORMATION);
     }
     else
     {
      nst--;
      if( kinet[idx] != NOT )
      {
       kass--;
       if( ktype[kinet[idx]].nmodf>0 ) nlps--;		/* if there were modfs	*/
       if( ktype[kinet[idx]].nmodf==nmd[idx] ) lass--;	/* decrease lass				*/
      }
      for( j=idx; j<nst; j++ )
      {
       lstrcpy( (LPSTR) stepn[j], (LPSTR) stepn[j+1] );
       kinet[j] = kinet[j+1];
       nmd[j] = nmd[j+1];
       for( i=0; i<MAX_MET; i++ )
       {
        (*lp)[j][i] = (*lp)[j+1][i];
        sto[i*MAX_MET + j] = sto[i*MAX_MET + j+1];
       }
      }
      kinet[nst] = 0;
      nmd[nst] = 0;
      idx = -1;
     }
      SetFocus( hEditBox );
     return( TRUE );

    case IDC_REACT:
     switch( HIWORD( lParam ) )
     {
      case EN_ERRSPACE:
      case EN_MAXTEXT:
       LoadString(hInst, IDS_ERR_BUF_FUL, szString, sizeof(szString));
       MessageBox(NULL, szString, NULL, MB_ICONINFORMATION);
       GlobalFree( hMetn );
       GlobalFree( hSto );
       EndDialog( hDlg, FALSE );
       return( TRUE );
     }
     break;

    case IDC_REACTLST:
     if( HIWORD( lParam ) == LBN_DBLCLK )
     {
      idx = (int) SendMessage( hReacLst, LB_GETCURSEL, 0, 0 );
      SendMessage( hReacLst, LB_GETTEXT, idx, (DWORD) (LPSTR) buffer );
      SendMessage( hEditBox, WM_SETTEXT, 0, (DWORD) (LPSTR) buffer );
      SendMessage( hStepNam, WM_SETTEXT, 0, (DWORD) (LPSTR) stepn[idx] );
      SetFocus( hEditBox );
      SendMessage( hEditBox, WM_KEYDOWN, 0x23, 0 );		/* put cursor at the end	*/
      return( TRUE );
     }
     else return( FALSE );

    case IDOK:
     ClearReactions();
     nr = (int) SendMessage( hReacLst, LB_GETCOUNT, 0, 0 );
     for( i=0; i<nr; i++ )
     {
      SendMessage( hReacLst, LB_GETTEXT, i, (DWORD) (LPSTR) buffer );
      reaction( buffer, i, &totmet, metname, stoiu, rstr, intmet, revers );
      nsteps++;
     }
/*     _fmemcpy( (void __far *) order,
   	           (void __far *) ord,
               (size_t) MAX_STEP * MAX_MET * sizeof( signed char ) );*/
     _fmemcpy( (void __far *) intmet,
   			   (void __far *) intm,
   			   (size_t) MAX_MET * sizeof( int ) );
     _fmemcpy( (void __far *) kinetu,
   	           (void __far *) kinet,
               (size_t) MAX_STEP * sizeof( int ) );
     _fmemcpy( (void __far *) loop,
               (void __far *) lp,
               (size_t) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
     _fmemcpy( (void __far *) nmod,
 	           (void __far *) nmd,
               (size_t) MAX_STEP * sizeof( unsigned char ) );
     _fmemcpy( (void __far *) revers,
 	           (void __far *) rvr,
               (size_t) MAX_STEP * sizeof( unsigned char ) );
     _fmemcpy( (void __far *) stepname,
   	           (void __far *) stepn,
   	           (size_t) MAX_STEP * NAME_L * sizeof( char ) );
     nloops = nlps;
     kinass = kass;
     loopass = lass;
     notsaved = 1;
     EndDialog( hDlg, IDOK );
     return( TRUE );

    case IDC_HELP:                        /* Help on this Dialog Box			  */
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Reaction editor" );
     return( TRUE );

    case IDCANCEL:                        /*Cancel box or sys menu close command  */
     EndDialog( hDlg, IDCANCEL );
     return( TRUE );
   }
   break;
 }
 return( FALSE );                                       /*didn't process a message              */
} /* End of EdReact                                           */

