#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*              Links                */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE16, Links, EdLinks)

extern void AddPLst( HWND hControl, int idx, BOOL scroll );


int FAR PASCAL Links(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static HWND hSelect, hButt, hDel;
 int i,j,nRc;
 FARPROC		lpfnProc2;				/* pointer to dialog procedures			*/

 switch( Message )
 {
  case WM_INITDIALOG:
   /* allocate memory for the mirror				*/
   hScp = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, sizespar );
   if( hScp == NULL )
   {
    LoadString(hInst, IDS_ERR_NOEXEC, szString, sizeof(szString));
    MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
    EndDialog(hDlg, IDCANCEL);
    return TRUE;
   }

   /* lock the memory block							*/
   scp  = (struct sp huge *) GlobalLock( hScp );

   /* copy params to its mirror						*/
   _fmemcpy( (void __far *) scp,
             (void __far *) spar,
		     (size_t) sizespar );
   nlks = nlinks;

   /* get handles for controls						*/
   hSelect = GetDlgItem( hDlg, IDC_SELECT );
   hButt = GetDlgItem( hDlg, IDC_CHANGE );
   hDel = GetDlgItem( hDlg, IDC_DEL );

   /* initialize hSelect: add all elements with links	*/
   for( i=0, lbWidth=0; i<nlks; i++ )
    for( j=0; j<nscanpar; j++ )
     if( (scp[j].lidx) ==  i )
      AddPLst( hSelect, j, TRUE );
   if( nlks==0 )
   {
    EnableWindow( hButt, FALSE );
    EnableWindow( hDel, FALSE );
   }
   else SendMessage( hSelect, LB_SETCURSEL, 0, 0 );
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_ADD:
     lno = nlks;
     lpfnProc2 = MakeProcInstance((FARPROC) EdLinks, hInst);
     nRc = DialogBox(hInst, (LPSTR)"ED_LINK", hDlg, lpfnProc2);
     FreeProcInstance(lpfnProc2);
     if( nRc>=0 )
     {
      AddPLst( hSelect, nRc, TRUE );
      nlks++;
      if( nlks==1 )
      {
       EnableWindow( hButt, TRUE );
       EnableWindow( hDel, TRUE );
      }
     }
     else SendMessage( hDlg, WM_COMMAND, IDCANCEL, 0 );
     return TRUE;

    case IDC_CHANGE:
     /* get the index of the element selected					*/
     i = (int) SendMessage( hSelect, LB_GETCURSEL, 0, 0 );
     if( i != LB_ERR )
     {
      lno = i;
      lpfnProc2 = MakeProcInstance((FARPROC) EdLinks, hInst);
      nRc = DialogBox(hInst, (LPSTR)"ED_LINK", hDlg, lpfnProc2);
      FreeProcInstance(lpfnProc2);
      if( nRc==-1 ) SendMessage( hDlg, WM_COMMAND, IDCANCEL, 0 );
      else
      {
       SendMessage( hSelect, LB_DELETESTRING, i, 0 );
       for( j=0; j<nscanpar; j++ )
        if( (scp[j].lidx) ==  i )
         SendMessage( hSelect, LB_INSERTSTRING, i, (DWORD) scp[j].title );
      }
     }
     return TRUE;

    case IDC_DEL:
     /* get the index of the element selected					*/
     i = (int) SendMessage( hSelect, LB_GETCURSEL, 0, 0 );
     if( i != LB_ERR )
     {
      for( j=0; j<nscanpar; j++ )
      {
       if( scp[j].lidx > i ) scp[j].lidx--;
       else
        if( (scp[j].lidx) ==  i )
        {
         scp[j].lidx = -1;
         scp[j].operation = 1;
         scp[j].linkedto = -1;
         scp[j].factor = 1;
        }
      }
      nlks--;
      if( nlks==0 )
      {
       EnableWindow( hButt, FALSE );
       EnableWindow( hDel, FALSE );
      }
      SendMessage( hSelect, LB_DELETESTRING, (WORD) i, 0 );
     }
     return TRUE;

    case IDC_SELECT:
     if( HIWORD( lParam ) == LBN_DBLCLK )
     {
      SendMessage( hDlg, WM_COMMAND, IDC_CHANGE, 0 );
      return TRUE;
     }
     else return FALSE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Links dialog box" );
     return TRUE;

    case IDOK:
     nlinks = nlks;
	 /* copy params back from its mirror								*/
     _fmemcpy( (void __far *) spar,
               (void __far *) scp,
		       (size_t) sizespar );
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hScp );
     GlobalFree( hScp );
     /* signal that changes have been made					*/
	 notsaved = 1;
     EndDialog(hDlg, IDOK);
     return TRUE;

    case IDCANCEL:
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hScp );
     GlobalFree( hScp );
     EndDialog(hDlg, IDCANCEL);
     return TRUE;
   }    /* End of WM_COMMAND                                 */
   return FALSE;

  default:
   return FALSE;
 }
} /* End of METABMsgProc                                      */


int FAR PASCAL EdLinks(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static int nsel;
 static HWND hAvail, hSelect, hS1, hS2, hFactor;
 int  i, old;
 char buff[128];

 switch(Message)
 {
  case WM_INITDIALOG:
   /* get handles to controls						*/
   hAvail = GetDlgItem( hDlg, IDC_PARAMLST );
   hSelect = GetDlgItem( hDlg, IDC_SELECT );
   hS1 = GetDlgItem( hDlg, IDSTAT_6 );
   hS2 = GetDlgItem( hDlg, IDSTAT_7 );
   hFactor = GetDlgItem( hDlg, IDE_M0 );

   /* init hAvail and hSelect: add all output elmnts*/
   for( i=0, lbWidth=0; i<nscanpar; i++ )
   {
    AddPLst( hAvail,  i, FALSE );
    AddPLst( hSelect, i, FALSE );
   }

   if( lno==nlks ) i = -1;
   else
   {
    for( i=0; i<nscanpar; i++ )
     if( scp[i].lidx == lno) break;
   }

   if( i==-1) strcpy( buff, "1" );
   else gcvt( scp[i].factor, 8, buff );
   SendMessage( hFactor, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

   if( i==-1 ) buff[0] = '\0';
   else _fstrcpy( (LPSTR) buff, scp[i].title );
   SendMessage( hS1, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   SendMessage( hAvail, LB_SETCURSEL, (WORD) i, 0 );

   if( i==-1 ) SendMessage( hSelect, LB_SETCURSEL, (WORD) -1, 0 );
   else SendMessage( hSelect, LB_SETCURSEL, (WORD) scp[i].linkedto, 0 );

   if( (i==-1) || (scp[i].linkedto==-1) ) buff[0] = '\0';
   else _fstrcpy( (LPSTR) buff, scp[scp[i].linkedto].title );
   SendMessage( hS2, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

   nsel = i;

   InvalidateRect( hDlg, NULL, FALSE );
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_PARAMLST:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      /* keep the old selection value								*/
      old = nsel;
      /* get the newly selected element in the available box		*/
      nsel = (int) SendMessage( hAvail, LB_GETCURSEL, 0, 0 );
      if( nsel != LB_ERR )
      {
       if( old != -1 )
       {
        scp[nsel].lidx = scp[old].lidx;
        scp[nsel].factor = scp[old].factor;
        scp[nsel].operation = scp[old].operation;
        scp[nsel].linkedto = scp[old].linkedto;
        scp[old].lidx = -1;
        scp[old].factor = 1;
        scp[old].operation = 1;
        scp[old].linkedto = -1;
       }
       else
        scp[nsel].lidx = lno;
       SendMessage( hS1, WM_SETTEXT, 0, (DWORD) (LPSTR) scp[nsel].title );
      }
      return TRUE;
     }
     else return FALSE;

    case IDC_SELECT:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      /* get the index of the element selected					*/
      i = (int) SendMessage( hSelect, LB_GETCURSEL, 0, 0 );
      if( (i != LB_ERR) && (nsel != -1) )
      {
       scp[nsel].linkedto = i;
       SendMessage( hS2, WM_SETTEXT, 0, (DWORD)(LPSTR) scp[scp[nsel].linkedto].title );
      }
      return TRUE;
     }
     else return FALSE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Edit link" );
     return TRUE;

    case IDOK:
     /* get the value of factor											*/
     i = (int) SendMessage( hFactor, WM_GETTEXT, 128, (DWORD)(LPSTR) buff );
     if( i>0 ) scp[nsel].factor = strtod( buff, NULL );
     scp[nsel].lidx = lno;
     if( (scp[nsel].factor==HUGE_VAL) || (scp[nsel].factor==-HUGE_VAL) )
     {
      LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hFactor );
      return TRUE;
     }
     EndDialog(hDlg, nsel);
     return TRUE;

    case IDCANCEL:
     /* unlock and free the mirror memory block             */
     EndDialog(hDlg, -1 );
     return TRUE;
   }    /* End of WM_COMMAND                                */
   return FALSE;

  default:
   return FALSE;
 }
} /* End of METABMsgProc                                    */

