/*
 * $Id$
 * make descriptions file from .TIC files in current directory
 *
 * $Log$
 */

# include <stdio.h>
# include <stddef.h>
# include <stdlib.h>
# include <ctype.h>
# include <string.h>
# include <memory.h>
# include <dos.h>
# include <direct.h>
# include <errno.h>

# include "dosdir.h"
# ifndef MAX_PATH
#  define MAX_PATH 128
# endif

# define DESCFILE "files.bbs"
# define argused(x) (x = x)



char descfile[MAX_PATH] = DESCFILE;

int line = 0;
int	desconly = 0;

static char
*skip_whi (char *s)
{
	while (isspace (*s))
		++s;
	return s;
}

static int
match (const char* s, const char *v)
{
	int l = strlen (v);
	return memcmp (s, v, l);
}


int
gatherdesc (FILE **fp, char* spec)
{
	int 			j, l, carg;
	FILE			*ip;
	char			cwd[MAX_PATH];
	struct FFIND	ff;

	GETCWD (cwd, MAX_PATH);
	l = strlen (cwd);
	if (l && cwd[l-1] != '\\')
		cwd[l++] = '\\';
	strcpy (cwd + l, spec);
	j = FINDFIRST (cwd, _A_NORMAL, &ff);
	while (j == 0)
	{
		if (strcmp (f_name(&ff), descfile) != 0)
		{

			strcpy (cwd + l, f_name(&ff));
			ip = fopen (cwd, "r");
			if (ip == NULL)
				fprintf (stderr, "tic2desc: Open %s - %s\n", f_name(&ff), strerror (errno));
			else
			{
				int lines, gotone;
				char aname[25], faddr[25], fname[25], fdesc[256], buf[512];
				char fname1[25];

				*aname = *fname = *faddr = *fdesc = '\0';
				for (lines = gotone = 0; !gotone && lines++ < 15 && fgets (buf, 512, ip) != NULL; )
				{
					char* p = strchr (buf, '\n');
					if (p != NULL)
						*p = '\0';

					if (match (buf, "Area") == 0)
					{
						strncpy (aname, skip_whi (buf+4), 24);
						aname[24] = '\0';
					}
					else if (match (buf, "From") == 0)
					{
						strncpy (faddr, skip_whi (buf + 4), 24);
						faddr[24] = '\0';
					}
					else if (match (buf, "File") == 0)
					{
						strncpy (fname, skip_whi (buf + 4), 24);
						fname[24] = '\0';
					}
					else if (match (buf, "Desc") == 0)
					{
						strncpy (fdesc, skip_whi (buf + 4), 255);
						fdesc[255] = '\0';
					}
				}

				if (*fname)
				{
					strlwr (fname);
					strupr (aname);

					if (*fp == NULL)
					{
						char * pp, bak[MAX_PATH];

						strcpy (bak, descfile);
						pp = strrchr (bak, '.');
						if (pp == NULL)
							pp = bak + strlen(bak);
						strcpy (pp, ".BAK");
						remove (bak);
						rename (descfile, bak);
						*fp = fopen (descfile, "w");
						if (*fp == NULL)
						{
							fprintf (stderr, "tic2desc: Can't create '%s' = %s\n", descfile, strerror(errno));
							rename (bak, descfile);
							break;
						}
					}

					strcpy (fname1, fname);
					strupr (fname1);
					if (desconly)
					{
						fprintf (*fp, "%-13s%s\n", f_name(&ff), fname);
						fprintf (*fp, "%-13s%s\n", fname1,      fdesc);
					}
					else
					{
						fprintf (*fp, "%-13s%-9s%-13sFrom %s\n", f_name(&ff), aname, fname, faddr);
						fprintf (*fp, "%-13s%-9s%-13s%s\n",      fname1,      aname, fname, fdesc);
					}
					printf (".");

				}
				else
					fprintf (stderr, "tic2desc: No filename in %s\n", f_name(&ff));

				fclose (ip);
			}
		}
		j = FINDNEXT (&ff);
	}
	FINDCLOSE (&ff);
	return 0;
}



int
main (int argc, char *argv[])
{
	int r = 0;
	int carg;
	FILE *fp;

	for (carg = 0; ++carg < argc; )
	{
		char *argp = argv[carg];
		if (*argp == '-' || *argp == '/')
		{
			++argp;
			switch (tolower (*argp))
			{
			case 'f':			/* Filename for descriptions */
				if (!*++argp)
					argp = argv[++carg];
				strcpy (descfile, argp);
				break;
			case 'd':			/* Descriptions only */
				++desconly;
				break;
			}
		}
	}

	argused(argc);
	argused(argv);
	fp = NULL;
	r |= gatherdesc (&fp, "*.bad");
	r |= gatherdesc (&fp, "*.tic");
	if (fp != NULL)
	{
		fclose (fp);
		printf ("\n");
	}
	return r;
}

