/*
 * DOS & OS/2 compiler portability module
 * Provides "portability"" for 'findfirst' calls between
 * DOS/OS2 compilers compilers.
 *
 * $Id$
 *
 * $Log$
 */

#if !defined(_DOSDIR_H)
#define _DOSDIR_H 1

#if defined(_cplusplus)
extern "C"
{
#endif

# if defined(OS2)
#  include <os2.h>
/* Note: this section needs to be updated for 32-bit */

#	  if defined(_MSC_VER)
#	   include <direct.h>
#      define GETCWD getcwd
#	  endif

#  if defined(__cplusplus)
#   define INLINE		inline
#  else
#   if defined(_MSC_VER) && !defined(__STDC__)
#    define INLINE		__inline
#   else
#    define INLINE		static
#   endif
#  endif

#  define ALLFILES "*"

struct FFIND
{
	HDIR				dh;
	struct _FILEFINDBUF	f;
};

INLINE int
FINDFIRST (char *spec, USHORT attr, struct FFIND *ff)
{
	USHORT cnt = 1;
	ff->dh = (HDIR) -1;
	return (int) DosFindFirst ((PSZ)spec, &ff->dh, attr, &ff->f, (USHORT)sizeof(struct _FILEFINDBUF), &cnt, 0L);
}

INLINE int
FINDNEXT (struct FFIND *ff)
{
	USHORT cnt = 1;
	return (int) DosFindNext (ff->dh, &ff->f, sizeof(struct _FILEFINDBUF), &cnt);
}

INLINE int
FINDCLOSE (struct FFIND *ff)
{
	return (int) DosFindClose (ff->dh);
}

#  if !defined(_A_NORMAL)
#	 define _A_NORMAL		 FILE_NORMAL
#	 define _A_SUBDIR		 FILE_DIRECTORY
#	 define _A_HIDDEN		 FILE_HIDDEN
#	 define _A_RDONLY		 FILE_READONLY
#	 define _A_SYSTEM		 FILE_SYSTEM
#  endif

#	 define f_name(x)		 (x)->f.achName
#	 define f_size(x)		 (x)->f.cbFile
#	 define f_attr(x)		 (x)->f.attrFile
#	 define f_wrdate(x) 	 (x)->f.fdateLastWrite
#	 define f_wrtime(x) 	 (x)->f.ftimeLastWrite
#	 define f_crdate(x) 	 (x)->f.fdateCreation
#	 define f_crtime(x) 	 (x)->f.ftimeCreation
#	 define f_acdate(x) 	 (x)->f.fdateAccess
#	 define f_actime(x) 	 (x)->f.ftimeAccess

# else

#  define ALLFILES "*.*"

#  if defined(MSDOS)
#	include <dos.h>

#	if defined(__TURBOC__) || defined(__GO32__) || defined(__BORLANDC__)
/* Turbo/Borland C / djgpp */
#	 include <dir.h>
#    define GETCWD getcwd

#	 if defined(__GO32__)
#	  include <std.h>
#	 endif

/* djgpp/go32 uses turboc compatible calls */

#	 define FINDFIRST(n,a,f) findfirst(n,f,a)
#	 define FINDNEXT(f) 	 findnext(f)
#	 define FINDCLOSE(f)

#	 define FFIND			ffblk

#	 define _A_NORMAL		0
#	 define _A_SUBDIR		FA_DIREC
#	 define _A_HIDDEN		FA_HIDDEN
#	 define _A_RDONLY		FA_RDONLY
#	 define _A_SYSTEM		FA_SYSTEM

#	 define f_name(x)		(x)->ff_name
#	 define f_size(x)		(x)->ff_fsize
#	 define f_attr(x)		(x)->ff_attrib
#	 define f_wrdate(x) 	(x)->ff_fdate
#	 define f_wrtime(x) 	(x)->ff_ftime
#	 define f_crdate(x)		0
#	 define f_crtime(x)		0
#	 define f_acdate(x)		0
#	 define f_actime(x)		0

#	else

#	 if defined(__ZTC__) || defined(_MSC_VER)

#	  if defined(_MSC_VER)
#	   include <direct.h>
#     define GETCWD getcwd
#	  endif

/* Zortech can use MSC compatible calls */

#	  define FFIND			  _find_t

#	  define FINDFIRST(n,a,f) _dos_findfirst(n,a,f)
#	  define FINDNEXT(f)	  _dos_findnext(f)
#	  define FINDCLOSE(f)

#	  define f_name(x)		 (x)->name
#	  define f_size(x)		 (x)->size
#	  define f_attr(x)		 (x)->attrib
#	  define f_wrdate(x)	 (x)->wr_date
#	  define f_wrtime(x)	 (x)->wr_time
#	  define f_crdate(x)	 0
#	  define f_crtime(x)	 0
#	  define f_acdate(x)	 0
#	  define f_actime(x)	 0

#	 else

#	  error ("MSDOS compiler type cannot be determined in "__FILE__)

#	 endif

#	endif

#	define d_PERMS			(_A_SUBDIR|_A_HIDDEN|_A_RDONLY|_A_SYSTEM)
#	define a_PERMS			(_A_SUBDIR|_A_HIDDEN|_A_RDONLY|_A_SYSTEM)

#	define ISDIR(x) 		(f_attr(x) & _A_SUBDIR)
#	define f_acdate(x)		0
#	define f_actime(x)		0
#	define f_crdate(x)		0
#	define f_crtime(x)		0


#  else							/* Not MSDOS */

#	include <dirent.h>
#	include <sys/types.h>
#	include <sys/stat.h>

#	define FFIND			 DIR
#	define d_PERMS			 07777
#	define a_PERMS			 07777
#	define ISDIR()			 (S_ISDIR(st.st_mode))
#	define f_name() 		 fe->d_name
#	define f_size() 		 st.st_size
#	define f_attr() 		 st.st_mode

#  endif

# endif

#if defined(_cplusplus)
}
#endif

#endif

