@echo off
if (%1)==(SUBROUTINE) goto %2
:: This batch file requires Fdate v7.0 or greater
CLS
:: get name of this batch file, in upper case
FDATE /fupper /q%0 /V
echo 
echo                        %fdate%
echo 
echo       FUNCTION: calculate the Federal holidays in a given year
echo.
echo "(celebrated)" means the holiday falls on a Saturday or Sunday, so Federal
echo workers are given the previous Friday or the following Monday as a holiday.
echo.
echo After the calendar is displayed, you can print it by pressing SHIFT+PRINTSCREEN
echo 

if not (%1)==() set year=%1
if not (%year%)==() goto GetYrEnd

:GetYr
echo.
echo Please enter the year for which you want federal holidays calculated,
FDATE /fget /q"or press ENTER for current year > " /Vyear
if not (%year%)==() goto GetYrEnd

:: get current year
Fdate /Ff /At /Occyy /Vyear

:GetYrEnd

echo.
:: check for validity of year parm (%1)
Fdate /Fv /A01-01-%year% >nul
if errorlevel 1 echo Value [%year%] is not a valid year.  Please re-enter.
if errorlevel 1 goto GetYr

echo.
echo Sometimes the timing of holidays makes certain dates especially
echo attractive for taking annual leave.
FDATE /FGETK /Q"Do you want me to show those dates? (press Y or N) > " /kYN /V
set Z=
if (%fdate%)==(N) set Z=REM

CLS
echo 
echo                   FEDERAL HOLIDAYS IN %year%
echo 
echo.
:: =========== NEW YEARS DAY: JANUARY 1 ======================
set holiday=01-01-%year%
Fdate /Ff /A%holiday% /odow# /vdow#

:: Popular leave day: the Monday before a Tuesday holiday
%Z% if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"New Year's Day %year%%cf%..."

:: Popular leave day: the Friday after a Thursday holiday
%Z% if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

:: =========== MARTIN LUTHER KING BIRTHDAY: 3rd Monday in January
Fdate /Fw /D2 /N3 /A01-01-%year% /P"Martin Luther King, Jr. Birthday........"
Fdate /Fw /D2 /N3 /A01-01-%year% /Omm-dd-ccyy /vMLKDAY


:: =========== INAUGURATION DAY: JAN 20, every 4th year after 1965
set holiday=01-20-%year%
Fdate /Ff /A%holiday% /odow# /vdow#

:: Inauguration day became a federal holiday starting in 1966
Fdate /F#comp /A%year% /B1966 /Vmod
if (%mod%)==(LT) goto EndInaugural

Fdate /F#mod /A%year% /B4 /Vmod
if (%mod%)==(1) goto Inaugural
                goto EndInaugural

:Inaugural

:Popular leave day: the Tuesday between MLK birthday and Inauguration Day
%Z% if %dow#%==4 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY (Washington, DC)..."


:: Jan 20 is inauguration day, unless it falls on a SUNDAY

set pf= .................
if %dow#%==7 echo       (Inauguration Day, January 20, falls on Saturday)
if %dow#%==7 goto EndInaugural
if %dow#%==1 goto Imoved
             goto Iweekday

:Imoved
:: Inauguration day (Jan 20) falls on a Sunday.   Move it to Monday.
Fdate /Fadd /A%holiday% /N+1 /omm-dd-ccyy /Vholiday
set pf= (celebrated).....
set dow#=2
:Iweekday

if %holiday%==%mlkday% echo       (Inauguration Day falls on same day as M. L. King's birthday)
if %holiday%==%mlkday% goto endInaugural

Fdate /Ff /A%holiday% /p"Inauguration Day%pf%......"
echo       (Applies only to Federal employees working in the Washington, DC area)

:: Popular leave day: the Friday after a Thursday holiday
%Z% if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

echo.
:EndInaugural
set pf=
:: ===============================================================


:: ======== GEORGE WASHINGTON's BIRTHDAY: 3rd Monday in February
Fdate /Fw /D2 /N3 /A02-01-%year% /P"Washington's Birthday..................."


:: =============== MEMORIAL DAY: last monday in May ==============
Fdate /FW /D2 /N-1 /A05-31-%year% /P"Memorial Day............................"


:: =============== INDEPENDENCE DAY: July 4 ====================
set holiday=07-04-%year%
Fdate /Ff /A%holiday% /Odow# /Vdow#

:: Popular leave day: the Monday before a Tuesday holiday
%Z% if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"Independence Day%cf%......"

:: Popular leave day: the Friday after a Thursday holiday
%Z% if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


:: =============== LABOR DAY: first Monday in September ==========
Fdate /Fw /D2 /N1  /A09-01-%year% /P"Labor Day..............................."


:: =============== COLUMBUS DAY: second Monday in October ========
Fdate /Fw /D2 /N2  /A10-01-%year% /P"Columbus Day............................"


:: =============== VETERAN'S DAY: November 11 =================
set holiday=11-11-%year%
Fdate /Ff /A%holiday% /odow# /Vdow#

:: Popular leave day: the Monday before a Tuesday holiday
%Z% if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"Veteran's Day%cf%........."

:: Popular leave day: the Friday after a Thursday holiday
%Z% if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


:: =============== THANKSGIVING: 4th Thursday in November ========
:: Get date of Thanksgiving in mm-dd-ccyy format
Fdate /Fw /D5 /N4  /A11-01-%year% /Omm-dd-ccyy /Vholiday

Fdate /Ff /A%holiday%  /P"Thanksgiving Day........................"

:: Popular leave day: the Friday after a Thursday holiday
%Z% Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


:: =============== CHRISTMAS DAY: December 25 =================
set holiday=12-25-%year%
Fdate /Ff /A%holiday% /odow# /Vdow#

:: Popular leave day: the Monday before a Tuesday holiday
%Z% if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

:: The President often gives Federal employees leave on the afternoon
:: of Christmas Eve, when Christmas Day falls on Friday
if %dow#%==6 Fdate /Fadd /A%holiday% /N-1 /P"-- President MAY grant leave for afternoon of "

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"Christmas Day%cf%........."

:: Popular leave day: the Friday after a Thursday holiday
%Z% if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


:: =============== NEW YEARS DAY: January 1 ===================
:: advance year to next year
fdate /f#add /a%year% /b1 /Vyear

set holiday=01-01-%year%
Fdate /Ff /A%holiday% /odow# /Vdow#

:: Popular leave day: the Monday before a Tuesday holiday
%Z% if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"New Year's Day %year%%cf%..."

:: Popular leave day: the Friday after a Thursday holiday
%Z% if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

set year=
set cf=..................
set holiday=
echo.
goto cleanup

:: ================================================================
::                SUBROUTINES
:: ================================================================

:CheckWeekend
shift
shift
goto Dow-%dow#%

:dow-1
Fdate /Fadd /A%1 /N+1 /omm-dd-ccyy /Vholiday
set dow#=2
set cf= (celebrated).....
goto endit

:dow-7
Fdate /Fadd /A%1 /N-1 /omm-dd-ccyy /Vholiday
set dow#=6
set cf= (celebrated).....
goto endit

:dow-2
:dow-3
:dow-4
:dow-5
:dow-6
set holiday=%1
set cf=..................
goto endit


:CLEANUP
set fdate=
set dow#=
set mod=
set mlkday=
set cf=
set pf=
set Z=
set holiday=

:endit
