'  -- ZDATE.BAS --
'
'  This program is donated to the Public
'  Domain by MarshallSoft Computing, Inc.
'  It is provided as an example of the use
'  of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFWRD A-Z

$INCLUDE "DATETIME.BI"

%K1970  = 2440588
%K0     =    1461
%K1     =  146097
%K2     = 1721119

SUB Greg2Julian(BYVAL Year AS WORD,  _
                BYVAL Month AS WORD, _
                BYVAL Day AS WORD,   _
                      Julian AS LONG) PRIVATE
 DIM Century AS LONG
 DIM XYear AS LONG
 DIM Temp AS LONG
 'PRINT "G2J: Year=";Year;" Month=";Month;" Day=";Day
 IF Month <= 2 THEN
    Year = Year - 1
    Month = Month + 12
 END IF
 Month = Month - 3
 Century = Year \ 100
 Century = %K1 * Century
 SHIFT RIGHT Century, 2
 XYear = Year MOD 100
 XYear = %K0 * XYear
 SHIFT RIGHT XYear, 2
 Temp = Month
 Julian = (((153 * Temp) + 2) \ 5) + Day + %K2 + XYear + Century
 'PRINT "G2J: XYear=";XYear;" Century=";Century;" Julian=";Julian
END SUB

SUB Julian2Greg(Julian AS LONG, _
                  Year AS WORD, _
                 Month AS WORD, _
                   Day AS WORD) PRIVATE
 DIM Temp AS LONG
 DIM XYear AS LONG
 DIM YYear AS WORD
 DIM YMonth AS WORD
 DIM YDay AS WORD
 'PRINT "J2G: Julian=";Julian
 Temp = (((Julian - %K2) * 4) - 1)
 XYear = (Temp MOD %K1) OR 3
 Julian = Temp \ %K1
 YYear = (XYear \ %K0)
 Temp = ((((XYear MOD %K0) + 4) \ 4) * 5) - 3
 YMonth = Temp \ 153
 IF YMonth >= 10 THEN
    YYear = YYear + 1
    YMonth = YMonth - 12
 END IF
 YMonth = YMonth + 3
 YDay = Temp MOD 153
 YDay = (YDay + 5) \ 5
 Year = YYear + (Julian * 100)
 Month = YMonth
 Day = YDay
 'PRINT "J2G: Year=";Year;" Month=";Month;" Day=";Day
END SUB


SUB Dos2Zdate(BYVAL TheDate AS WORD, _
              BYVAL TheTime AS WORD, _
                    Text AS STRING) PUBLIC
 DIM I AS INTEGER
 DIM N AS INTEGER
 DIM C AS BYTE
 DIM Year AS BYTE
 DIM Month AS BYTE
 DIM Day AS BYTE
 DIM Hour AS BYTE
 DIM Minute AS BYTE
 DIM Second AS BYTE
 DIM SecsPast AS LONG
 DIM Julian AS LONG
 DIM DaysPast AS LONG
 ' begin
 CALL UnpackTime(TheTime,Hour,Minute,Second)
 CALL UnpackDate(TheDate,Year,Month,Day)
 CALL Greg2Julian(1900+Year,Month,Day,Julian)
 DaysPast = Julian - %K1970
 SecsPast = 86400 * DaysPast
 SecsPast = SecsPast + (Hour * 3600) + (Minute * 60) + Second
 ' extract octal digits
 N = 0
 Text = ""
 WHILE SecsPast <> 0
    C = (SecsPast AND &H07) + &H30
    Text = CHR$(C) + Text
    N = N + 1
    SecsPast = SecsPast \ 8
 WEND
 Text = "0" + Text
 '''PRINT "UNIX Text: <";Text;">"
END SUB

SUB Z2DosDate(Text AS STRING, _
              TheDate AS WORD, _
              TheTime AS WORD) PUBLIC
 DIM N AS INTEGER
 DIM C AS BYTE
 DIM Year AS WORD
 DIM Month AS WORD
 DIM Day AS WORD
 DIM Hour AS WORD
 DIM Minute AS WORD
 DIM Second AS WORD
 DIM SecsPast AS LONG
 DIM Julian AS LONG
 DIM DaysPast AS LONG
 DIM Length AS WORD
 '''PRINT "UNIX Text: <";Text;">"
 Length = LEN(Text)
 SecsPast = 0
 FOR N = 1 TO Length
   C = ASC(MID$(Text,N,1))
   ' PRINT CHR$(C);
   IF C <> 0 THEN
     SecsPast = (8 * SecsPast) + C - &H30
   END IF
 NEXT N
 Julian = (SecsPast \ 86400) + %K1970
 CALL Julian2Greg(Julian,Year,Month,Day)
 SecsPast = SecsPast MOD 86400
 Hour = SecsPast \ 3600
 SecsPast = SecsPast MOD 3600
 Minute = SecsPast \ 60
 Second = SecsPast MOD 60
 CALL PackDate(Year-1900,Month,Day,TheDate)
 CALL PackTime(Hour,Minute,Second,TheTime)
END SUB
            