'============================================================================
'============================================================================

' sample code 02 to demonstrate techniques for using LangWin.
' this sample has some complicated code, but if you take the time
' to understand it, you'll be able to better take advantage of LangWin.


' hit Shift+F5 to run this code.

' you must start QuickBASIC as follows:  qb /ah /L langwin
'    /L langwin parameter provides access to LangWin quicklib
'    /ah parameter is needed to allow dynamic arrays > 64k.


DECLARE SUB WinDemo01 () ' main subroutine to generate windows
DECLARE SUB menu1 ()     ' process events for MENU1 selection
DECLARE SUB Help1 ()     ' context sensitive help routine
DECLARE SUB open1 ()     ' process user defined hotkey option (ctrl-o)
DECLARE SUB about1 ()    ' process user defined hotkey option (atl-a)
DECLARE SUB F2 ()        ' process user defined hotkey option (F2)
' subroutine to process button1 in main window
DECLARE SUB MButton1 (box1%, field1%, wh%, ModTextWinNum%, ErrWinNum%)

DECLARE FUNCTION VidType% ()  ' used to determine type of monitor


'$DYNAMIC  make all arrays dynamic

DEFINT A-Z

'$INCLUDE: 'LANGWIN.BI' ' TYPE, DECLARE and COMMON definitions for LangWin.
'                         NOTE: LANGWIN.BI contains all definitions found
'                               in QB.BI, so include for QB.BI is not needed.



CLEAR , , 5000   ' set stack at 5000 bytes


'---------------------------------------------------------------
' first see if EGA or VGA monitor
mm = VidType
IF mm <> 3 AND mm <> 4 THEN
	' monitor is not EGA/VGA
	' take whatever actions necessary (error messages)
	BEEP
	PRINT "LangWin needs EGA or VGA, sorry ........"
	END
END IF


'-----------------------------------------------------------------
' get attribute from current screen (row 1, col 1)
' so it can be restored upon exit
OrigAttr = SCREEN(1, 1, 1)

'-------------------------------------------------------------------
' if WIDTH command is used, it must be placed before call to LangWinInit
' because code in LangWinInit extracts max rows/cols from screen and saves
' in global variables. if WIDTH is used after LangWinInit, the global
' variable will not be set correctly.
WIDTH 80, 25

'----------------------------------------------------------------------
' these variables MUST be defined BEFORE call to LangWinInit.
' keep these as low as possible to conserve memory at run time.
MaxWindows = 5       ' max simultaneous open windows
MaxButtons = 35      ' max number of objects (incl text labels) active
MaxTextLines = 40    ' max lines of text in any array of scrollable text
MaxTextWins = 3      ' max # windows that can be open with scrollable text
					 ' must be <= MaxWindows

LOCATE , , 0         ' start with hidden text cursor

'---------------------------------------------------------------------------
' LangWin only supports text mode. You MUST call the SCREEN 0 command BEFORE
' the call to LangWinInit. You can call SCREEN with a video page other than 0
' (i.e., SCREEN 0,,x,x   where x is a page number supported by your system).
' Code in LangWinInit will determine which video page you are using and save
' the value in a global variable for use by other LangWin routines. If you
' call SCREEN 0 after LangWinInit and change the original video page, you'll
' get unpredictable results (i.e., LangWin will write to the original video
' page). However, you can use other video pages for functions not associated
' with your LangWin windows; just be sure to set the video page back to the
' original value defined below.

SCREEN 0, , 0, 0        ' LangWin ONLY supports text mode
						' You MUST call the SCREEN command BEFORE LangWinInit


CALL LangWinInit     ' initialize (if mouse exists, it will be displayed)
			 
					 ' if you get "subscript out of range" error while
					 ' in this routine, be sure you called QB with /ah.
					 ' then try reducing the value of MaxWindows.
					 ' check the WIDTH command; reduce number of columns,
					 ' and/or number of rows.

'-----------------------------------------------------------------------
' display "wallpaper"

IF HaveMouse THEN CALL HideMouseCursor  ' first hide mouse pointer

CLS
CALL SetColor(8, 15)
FOR i = 1 TO MaxRows
LOCATE i, 1
PRINT STRING$(80, 178);     ' can try 176, 177, or 178
NEXT

IF HaveMouse THEN CALL ShowMouseCursor   ' display the mouse pointer

'====================================================================

' this sample implements context sensitive help activated via the F1 key.
' (user defined hot keys, including F1, are defined in WinDemo01).
' in order for the routine that processes the F1 key (Help1)
' to determine the context (i.e., window and button with focus),
' the variable names used to store window numbers (returned by
' BlankWindow or OpenScrollWindow) and button handles (returned
' by the various "make" routines) must be DIM SHARED in the main module.
' those window numbers or button handles that do not need context
' sensitive help need not be SHARED.
' in addition, if you want context sensitive help to be displayed for
' a given window, then the code that processes actions (returned from
' WinEvent) in that window must detect the action associated with the
' F1 key and CALL Help1 (in the case of this sample code, the action for F1
' is 7 - see the user defined hot keys in WinDemo01).

' main window
DIM SHARED Main1, MainField1, MainBox1, MainButton1, MainMenu1
' window with modified text
DIM SHARED ModTextWinNum
' menu1 window
DIM SHARED MM1, mm1b1, mm1b2, mm1b3, mm1b4, mm1b5, mm1b6, mm1b7
' window opened to process selection from menu1
DIM SHARED mm1ww
' windows corresponding to hot keys
DIM SHARED about1w, f2w, open1w


' sample code to process windows
  CALL WinDemo01


'=====================================================================


IF HaveMouse THEN HideMouseCursor    ' we're done with the mouse

bbb = (OrigAttr AND &HF0) \ 16  ' mask & shift to get original background
fff = OrigAttr AND &HF          ' mask to get original foreground


PALETTE                           ' restore original palette
CALL SetColor(fff, bbb)           ' restore orig foreground/background
CLS
LOCATE , , 1                      ' make text cursor visible

END

REM $STATIC
'
' this routine handles case where special hot key: alt-a selected
' (i.e., the "about" menu1 item)
'
' i've only included sample code to open a modal window
' (with no error checking), display some text, and
' wait for close. production programs will have more details
' (which might not even require a window)
'
SUB about1

about1w = BlankWin(13, 3, 20, 30, 2, 15, 1, 0, 1, 2)
d = ShowWinText(2, 2, 0, "ALT-A: About selected")
' loop waiting for a close action (1)
DO
	d = WinEvent(a)
	IF a = 7 THEN CALL Help1  ' display help if selected
LOOP UNTIL a = 1
d = CloseWindow


END SUB

'
' this routine handles case where special hot key: F2 selected
' (i.e., the "options" menu1 item)
'
' i've only included sample code to open a modal window
' (with no error checking), display some text, and
' wait for close. production programs will have more details
' (which might not even require a window)
'
'
SUB F2


f2w = BlankWin(13, 3, 20, 30, 2, 15, 1, 0, 1, 2)
d = ShowWinText(2, 2, 0, "F2: Options selected")
' loop waiting for a close action (1)
DO
	d = WinEvent(a)
	IF a = 7 THEN CALL Help1  ' display help if selected
LOOP UNTIL a = 1
d = CloseWindow


END SUB

'
' open a window with context sensitive help
'
' all help text in this example is hard coded.
'
' for a major project with many nested windows,
' you'll probably want to keep help text on disk,
' read it into an array, and then have this routine display the appropriate
' array entries based upon the context. i'll leave that
' as an exercise to the reader!!
'
'
SUB Help1

' CurWinPtr contains handle of window with focus when F1 pressed.
' need to determine corresponding window number from in WinNum().
' this must be done before help window is opened, which will change
' the value of CurWinPtr

wn = WinNum(CurWinPtr) ' get number of window with focus
butfoc = WinParms(CurWinPtr, 16)' handle of button with focus

' open a modal help window
helpwin = BlankWin(1, 1, 11, 44, 3, 15, 2, 15, 1, 2)
	  
' first see if window opened successfully
IF helpwin < 0 THEN
   ' add code here to handle the case where window did not open
   CLS
   PRINT "helpwin BlankWin error: "; helpwin
   END
END IF
		 
' modal help window opened successfully,

' determine the context
' first check the window number, then the button number
SELECT CASE wn

CASE Main1      ' main menu
	e = ShowWinText(1, 2, 14, "Help for main menu")
   
	' which button had focus
	SELECT CASE butfoc

	CASE MainField1
		e = ShowWinText(2, 2, 14, "Input Field.")
		e = ShowWinText(4, 2, 15, "Contents of input field will be inserted")
		e = ShowWinText(5, 2, 15, "into all lines selected from scrollable")
		e = ShowWinText(6, 2, 15, "text.")
	CASE MainBox1
		e = ShowWinText(2, 2, 14, "Check Box.")
		e = ShowWinText(4, 2, 15, "Used as a toggle to allow selected text")
		e = ShowWinText(5, 2, 15, "to be modified (when Button1 clicked).")
		e = ShowWinText(6, 2, 15, "Check the box to enable modification.")
   
	CASE MainButton1
		e = ShowWinText(2, 2, 14, "Button1.")
		e = ShowWinText(4, 2, 15, "Used to initiate modification of selected")
		e = ShowWinText(5, 2, 15, "text. Check Box acts as toggle, it must")
		e = ShowWinText(6, 2, 15, "also be on to enable modification.")
		e = ShowWinText(7, 2, 15, "Window will be opened with all text")
		e = ShowWinText(8, 2, 15, "being modified.")
	CASE MainMenu1
		e = ShowWinText(2, 2, 14, "MENU1.")
		e = ShowWinText(4, 2, 15, "Brings up a sub-menu with several")
		e = ShowWinText(5, 2, 15, "options to choose from.")
	CASE -1     ' no button had focus, only text
		e = ShowWinText(2, 2, 14, "Scrollable Text")
		e = ShowWinText(4, 2, 15, "Double click on any line of scrollable")
		e = ShowWinText(5, 2, 15, "text. The selection character [X] will")
		e = ShowWinText(6, 2, 15, "be toggled. All selected text will be")
		e = ShowWinText(7, 2, 15, "modified (contents of input field added)")
		e = ShowWinText(8, 2, 15, "when Button1 clicked & Check Box is set.")

	END SELECT   ' end of code that processes buttons in main win

CASE ModTextWinNum      ' modified text window
	' this window has no buttons
	e = ShowWinText(1, 2, 14, "Help for Modified Text Window")
	e = ShowWinText(4, 2, 15, "This window shows all selected text")
	e = ShowWinText(5, 2, 15, "lines as modified. Closing this window")
	e = ShowWinText(6, 2, 15, "will result in the main menu's text")
	e = ShowWinText(7, 2, 15, "being updated and the selection toggle")
	e = ShowWinText(8, 2, 15, "cleared.")

CASE MM1     ' menu1
	e = ShowWinText(1, 2, 14, "Help for MENU1")
	' now determine which button had focus
	SELECT CASE butfoc

	CASE mm1b1
		e = ShowWinText(2, 2, 14, "Options ...")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE mm1b2
		e = ShowWinText(2, 2, 14, "Files ...")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE mm1b3
		e = ShowWinText(2, 2, 14, "Save As ...")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE mm1b4
		e = ShowWinText(2, 2, 14, "Delete.")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE mm1b5
		e = ShowWinText(2, 2, 14, "Open ...")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE mm1b6
		e = ShowWinText(2, 2, 14, "Print ...")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE mm1b7
		e = ShowWinText(2, 2, 14, "About ...")
		e = ShowWinText(4, 2, 15, "Some help text for this button.")
	CASE -1   ' no button had focus
		e = ShowWinText(2, 2, 14, "(no item highlighted)")
		e = ShowWinText(4, 2, 15, "Some general help text for MENU1 list.")

	END SELECT  ' end of code that processes buttons in menu1

CASE mm1ww  ' window opened to process selection from MENU1
	e = ShowWinText(1, 2, 14, "Help for MENU1 selection window ...")
	e = ShowWinText(4, 2, 15, "Some help text for this option.")

CASE about1w
	e = ShowWinText(1, 2, 14, "Help for ALT-A About window ...")
	e = ShowWinText(4, 2, 15, "Some help text for this option.")
CASE f2w
	e = ShowWinText(1, 2, 14, "Help for F2 Options window ...")
	e = ShowWinText(4, 2, 15, "Some help text for this option.")
CASE open1w
	e = ShowWinText(1, 2, 14, "Help for CTRL-O Open window ...")
	e = ShowWinText(4, 2, 15, "Some help text for this option.")


END SELECT

' put a title in window
e = ShowTitle("**** HELP ****", 15, 4)

' now wait for a close event
DO
	ww = WinEvent(aa)
LOOP UNTIL aa = 1
xx = CloseWindow


END SUB

'
'  process actions for Button1 in main menu
'
' check state of box1.
'
' if that box is set, then contents of MainField1 will be inserted into all
' selected scrollable text, a modal window will be opened (number returned in
' ModTextWinNum), and all modified text displayed in it.
'
' if MainBox1 is not set, a modal error window is open (number returned in
' ErrWinNum).
'
' if MainBox1 is set, but no text selected, a modal error window is opened
' (number returned in ErrWinNum).
'
'  input parms:
'       box1:  handle of check box. status of this box is
'              used to as a gate determine if selected scrollable text
'              will be modified or not.
'
'       field1: handle of input field. if check box is set,
'               contents of input field is inserted into
'               all scrollable text that is selected in main window.
'
'       savindx:     index in SaveText of window's text
'
'  output parms:
'       ModTextWinNum:  number of the modal window opened to display modified
'                       text
'       ErrWinNum:      number of modal window opened to display an err msg
'
SUB MButton1 (box1, field1, savindx, ModTextWinNum, ErrWinNum)

' if check box is down
' then add contents of input field to all selected text;
' open a window and display all selected text.
		 
IF ButtonsData(box1, 7) = 0 THEN ' see if box1 is down
		   
	' box1 was down, count selected text entries in scrollable text
	c = 0
	FOR i = 1 TO WinParms(CurWinPtr, 17)  ' only scan to end on non-null text
	IF MID$(SaveText(savindx, i), 2, 1) = "X" THEN c = c + 1
	NEXT
		   
	' if any text was selected, move entries and display
	IF c > 0 THEN
		' there were some text entries selected

		' create array for selected text
		REDIM TempText(1 TO c) AS STRING  ' temp array
		j = 1
		'copy selected text to temp array
		' and add contents of second input field.
		len2 = LEN(ButtonsText(field1))  ' len of 2nd input field
		FOR i = 1 TO WinParms(CurWinPtr, 17)' only scan to end of non-null txt
			IF MID$(SaveText(savindx, i), 2, 1) = "X" THEN 'find selected text entries
				len1 = LEN(SaveText(savindx, i))' len of text line
				x = len1 - len2 + 1 ' start of position to insert
				' insert field1 into text line
				IF len2 > 0 THEN MID$(SaveText(savindx, i), x, len2) = ButtonsText(field1)
				TempText(j) = SaveText(savindx, i)  ' copy it to temp array
				j = j + 1   ' bump index to temp array
			END IF
		NEXT
			 
		' now open a modal window and display selected text lines
		ModTextWinNum = OpenScrollWindow(10, 10, 20, 44, 1, 15, 2, 15, TempText(), 1, 1, 7, 30, 1, 2)
		ERASE TempText   ' clear temp array to save sapce

		' first see if window opened successfully
		IF ModTextWinNum < 0 THEN
		   ' add code here to handle the case where window did not open
		   CLS
		   PRINT "ModTextWinNum OpenScrollWindow error: "; ModTextWinNum
		   END
		END IF
			 
		' place title into window
		e = MakeHorizLine(8, 2)
		e = ShowWinText(9, 5, 15, "Close Window to Continue")
		e = ShowTitle("MODIFIED TEXT", 15, 4)
	   
		' get an action from the modal window just opened
		DO
			' modal window, no other window can be selected.
			' so no need to test window number generating the action.
			' the only valid action is a close (action = 1)
			' if text select action (3) then ignore it.
			' no buttons in window, so action 2 not possible.
			wn = WinEvent(action)     ' get an event in modal win
			IF action = 7 THEN CALL Help1  ' help key selected
		LOOP UNTIL action = 1         ' wait for a close

		xx = CloseWindow  ' close the modal window
	 
		' now clear the "select" toggle from all text in main window
		' and redisplay window (with updated text).
		' after modal win has just been closed, prev win on the stack
		' is made current. we know the previous win was the main window,
		' since it was current when its button was selected to cause the
		' modal window to be opened and was just pushed on the stack.

		' the following code operates on the current window.
		' it references CurWinPtr and subroutine ReShowPage
		' (which operates on text in current window).

		' if we were not certain that main window would be made current
		' after the modal win is closed, we would have to make
		' sure the main window was made current before changing
		' its scrollable text.
		' the following code could be used to do this (assume we know that
		' the main window's number is in variable main1 - this could
		' be a global variable, or passed as a parm):
		' xx = IsWinOpen(main1,wh) ' returns TRUE/FALSE if win is open, also
		'                          ' returns handle corresponding to main1
		' CALL NewFocusWindow(wh)  ' makes win with handle wh current

		FOR i = 1 TO WinParms(CurWinPtr, 17)' only scan to end of non-null txt
			IF MID$(SaveText(savindx, i), 2, 1) = "X" THEN ' find selected text entry
				MID$(SaveText(savindx, i), 2, 1) = " "   ' clear the select
			END IF
		NEXT
		CALL ReShowPage  ' re-display visible text in current (main) win

	ELSE
		' there were no text entries selected when button 1 was clicked
		' open a modal window and display a message.
		ErrWinNum = BlankWin(10, 10, 20, 44, 4, 15, 2, 15, 1, 2)
			
		' first see if window opened successfully
		IF ErrWinNum < 0 THEN
		   ' add code here to handle the case where window did not open
		   CLS
		   PRINT "ErrWinNum BlankWin error: "; ErrWinNum
		   END
		END IF
		   
		' modal error window opened successfully,
		' display some text in window
		e = ShowWinText(5, 3, 15, "Close window to continue")
		e = ShowTitle("NO SELECTED TEXT WAS FOUND", 15, 4)
	   
	   
		' this is a modal window with no selectable text or buttons.
		' wait for a close action (1)
		DO
			ww = WinEvent(aa)
		LOOP UNTIL aa = 1
		xx = CloseWindow
	  
	END IF
		 
ELSE
		  
	' box1 was not down when button1 was hit, display an error window
  
	' open a modal window
	ErrWinNum = BlankWin(10, 10, 20, 44, 4, 15, 2, 15, 1, 2)
		   
	' first see if window opened successfully
	IF ErrWinNum < 0 THEN
	   ' add code here to handle the case where window did not open
	   CLS
	   PRINT "ErrWinNum BlankWin error: "; ErrWinNum
	   END
	END IF
		  
	' show some text.
	e = ShowWinText(2, 3, 15, "Click on Check Box1,")
	e = ShowWinText(3, 3, 15, "before selecting Button1,")
	e = ShowWinText(4, 3, 15, "to process all selected")
	e = ShowWinText(5, 3, 15, "scrollable text.")
	e = ShowWinText(7, 3, 15, "Close window to continue.")
			 
	' this is a modal window with no selectable text or buttons.
	' wait for a close action (1)
	DO
		ww = WinEvent(aa)
	LOOP UNTIL aa = 1
	xx = CloseWindow

END IF


END SUB

'
'  process actions for MENU1
'
'
'
SUB menu1

Handle = WinParms(CurWinPtr, 16) ' get handle of button clicked
Col = ButtonsData(Handle, 3)' get column of button clicked
' open a window in same column (make it mode 2 - click off win closes it)
MM1 = BlankWin(2, Col, 12, Col + 17, 7, 0, 1, 0, 1, 3)'
  
' first see if window opened successfully
IF MM1 < 0 THEN
	' add code here to handle the case where window did not open
	CLS
	PRINT "MM1 BlankWin error: "; MM1
	END
END IF

' make buttons for MENU1
' save handles returned in individual variable names.
' when WinEvent indicates that a button was clicked,
' compare the clicked button's handle to each variable
' to determine which button was selected.

mm1b1 = MakePushButton(1, 1, 16, " Options...   F2", 0, 7, 0)
mm1b2 = MakePushButton(2, 1, 16, " Files...       ", 0, 7, 0)
mm1v1 = MakeHorizLine(3, 1)
mm1b3 = MakePushButton(4, 1, 16, " Save As...     ", 0, 7, 0)
mm1b4 = MakePushButton(5, 1, 16, " Delete         ", 0, 7, 0)
mm1b5 = MakePushButton(6, 1, 16, " Open...  Ctrl-O", 0, 7, 0)
mm1v2 = MakeHorizLine(7, 2)
mm1b6 = MakePushButton(8, 1, 16, " Print...       ", 0, 7, 0)
mm1b7 = MakePushButton(9, 1, 16, " About...  Alt-A", 0, 7, 0)
			

' wait for an event to occur in the MENU1 window
DO
	wn = WinEvent(action)
  
	SELECT CASE wn
   
	CASE MM1     ' main menu1
	   
		' now determine what type of event occurred in the main window
		SELECT CASE action
	   
		CASE 1      ' close
			xx = CloseWindow
			EXIT SUB   ' force an exit when menu1 is closed
		CASE 2      ' text
			'there is no scrollable text
		CASE 3      ' buttons

			Hand1 = WinParms(CurWinPtr, 16)  ' get handle of button that was clicked
  
			' for each button in MENU1 that can be clicked,
			' i've only included sample code to open a modal window
			' (with no error checking), display some text, and
			' wait for close. production programs will have more details
			' to process the meaning of each button (which might not
			' even require a window)

			SELECT CASE Hand1    ' select on handle of button that was clicked
			CASE mm1b1   ' options
				CALL F2   ' this action has a hot key, call corresponding sub
			CASE mm1b2   ' files
				mm1ww = BlankWin(13, 3, 20, 25, 2, 15, 1, 0, 1, 2)
				d = ShowWinText(2, 2, 0, "Files selected")
			CASE mm1b3   ' save as
				mm1ww = BlankWin(13, 3, 20, 25, 2, 15, 1, 0, 1, 2)
				d = ShowWinText(2, 2, 0, "Save as selected")
			CASE mm1b4   ' delete
				mm1ww = BlankWin(13, 3, 20, 25, 2, 15, 1, 0, 1, 2)
				d = ShowWinText(2, 2, 0, "Delete selected")
			CASE mm1b5   ' open
				CALL open1 ' this action has a hot key, call corresponding sub
			CASE mm1b6   ' print
				mm1ww = BlankWin(13, 3, 20, 25, 2, 15, 1, 0, 1, 2)
				d = ShowWinText(2, 2, 0, "Print selected")
			CASE mm1b7   ' about
				CALL about1 'this action has a hot key, call corresponding sub
			   
			END SELECT    ' end of code to process buttons
	   
		' user defined hot heys
		CASE 4  ' F2 = options
			CALL F2

		CASE 5  ' ctrl-o = open
			CALL open1

		CASE 6  ' alt-a = about
			CALL about1
  
		CASE 7  ' help = F1
			CALL Help1

		END SELECT  ' end of code that processes actions in menu1 window

	CASE mm1ww  ' to handle one of the sample modal windows opened for
				' menu1's buttons. for production programs, each button
				' would probably have it's own unique window number.

		SELECT CASE action
		CASE 1  'close
			xx = CloseWindow
		CASE 7  ' help key (F1)
			' since (for simplicity) i used the same variable (ww) for
			' every window opened in menu1, the help routine will
			' only display a generic message. in a production program,
			' each window opened in a menu will have a unique variable
			' name for its window number will be used by Help1
			' to provide more context sensitive help.
			CALL Help1
		END SELECT
	   
	END SELECT   ' end of code that processes windows open by menu1

LOOP


END SUB

'
' this routine handles case where special hot key: ctrl-o selected
' (i.e., the "open" menu1 item)
'
' i've only included sample code to open a modal window
' (with no error checking), display some text, and
' wait for close. production programs will have more details
' (which might not even require a window)
'
SUB open1

open1w = BlankWin(13, 3, 20, 30, 2, 15, 1, 0, 1, 2)
d = ShowWinText(2, 2, 0, "CTRL-O: Open selected")
' loop waiting for a close action (1)
DO
	d = WinEvent(a)
	IF a = 7 THEN CALL Help1  ' display help if selected
LOOP UNTIL a = 1
d = CloseWindow


END SUB

' =====================================================
'  returns type of video display
'
'  return values:
'       1:  black/white    (could be EGA/VGA with monochrome)
'       2:  CGA   (with color)
'       3:  EGA   (with color)
'       4:  VGA   (with color)
'       5:  MCGA  (with color)
'      99:  other
'
FUNCTION VidType

' quick & dirty, check &h463
DEF SEG = 0
IF PEEK(&H463) = &HB4 THEN     ' see if monochrome
	VidType = 1
	EXIT FUNCTION
END IF
DEF SEG

' first try int 10h, function 1Ah

InRegs.ax = &H1A00
CALL INTERRUPTX(&H10, InRegs, OutRegs)
IF (OutRegs.ax AND &HFF) = &H1A THEN    ' see if int 10h, funct 1Ah supported
	code = (OutRegs.bx AND &HFF)  ' get display code
	SELECT CASE code
	CASE 1      ' MDA
		VidType = 1
	CASE 2      ' CGA
		VidType = 2
	CASE 4      ' EGA color
		VidType = 3
	CASE 5      ' EGA b/w
		VidType = 1
	CASE 7      ' VGA b/w
		VidType = 1
	CASE 8      ' VGA color
		VidType = 4
	CASE 10     ' MCGA color
		VidType = 5
	CASE 11     ' MCGA b/w
		VidType = 1
	CASE ELSE
		VidType = 99    ' other
	END SELECT
	EXIT FUNCTION

ELSE
	' now try int 10h, function 12h, sub-function 10h
	InRegs.ax = &H1200
	InRegs.bx = &H10
	CALL INTERRUPTX(&H10, InRegs, OutRegs)
	IF (OutRegs.bx AND &HFF00) = 1 THEN     ' see if monochrome
		VidType = 1
		EXIT FUNCTION
	END IF

	IF (OutRegs.bx AND &HFF) <> &H10 THEN   ' see if BL reg changed
		VidType = 3    ' EGA (not sure why it couldn't be VGA too!)
		EXIT FUNCTION
	END IF

	VidType = 99      ' other (probably CGA or MDA)

END IF

END FUNCTION

'===========================================================================
'
' demonstration of windows using LangWin's routines
'
' sample functions performed:
'
' scrollable text is selected/un-selected by double clicking on each line.
' when button1 is selected, check box (immediately to right
' of button1) is tested. if it is down, then contents of input
' field is inserted at end of all selected text lines, and all selected text
' are displayed in a window. closing the window will un-select all text.
'
' this demonstrates the technique for displaying a selectable list in the
' scrollable window, allowing user to enter data in an input field,
' and using the combination of a check box setting and push button
' to take action on the items selected in the list.
'
' other techniques demonstrated include creating a menu bar across top
' of window, opening windows with additional menu choices, user defined
' hot keys, and a routine to handle context sensitive help.
'
SUB WinDemo01


' create some scrollable text.
' in your production program, this could be anything needed to be
' scrolled and selected (i.e., help text, lists, options, etc.)
' the sample text is preceeded with the following characters: [ ]
' these are not necessary for scrollable text in general. they will be used
' to demonstrate how to handle selectable text in a scrollable list.

DIM Text2(1 TO 30) AS STRING
FOR i = LBOUND(Text2) TO UBOUND(Text2)
Text2(i) = "[ ] " + STR$(i) + "- some scrollable text."
NEXT

' open an info only window
' mode type 4 - there will be no code to handle events
' in this window (i.e., no events, including close, are processed).
' no shadow, and unmovable.
' this type of window can display permanent instructions, etc.
' this window WILL need to be closed before terminating the program
inf = BlankWin(18, 10, 21, 30, -5, 15, 1, 15, 0, -4)
d = ShowWinText(1, 2, 15, "Info Only Window")


' open an unmovable scrollable text window as main menu
Main1 = OpenScrollWindow(1, 2, 14, 68, 9, 15, 2, 15, Text2(), 2, 1, 12, 30, 1, 1)

ERASE Text2  ' to save space

' first see if window opened successfully
IF Main1 < 0 THEN
	' add code here to handle the case where window did not open
	CLS
	PRINT "Main1 OpenScrollWindow error: "; Main1
	END
END IF

' window opened successfully, put stuff in it

' text and lines
' to make this example simple, i did not check for non-zero
' return codes from functions that display lines and text.
vn$ = GetVerNum$    ' get version number
e = ShowWinText(1, 40, 15, "LangWin Ver: " + vn$)  ' heading
e = MakeVertLine(32, 1)                            ' wertical line
e = ShowWinText(12, 38, 13, "Input Field:")       ' input field label
e = ShowWinText(3, 42, 11, "BUTTONS")              ' buttons heading
e = ShowWinText(3, 55, 11, "CHECK")                ' check boxes heading
e = MakeBox(2, 38, 9, 51, 1, 15)                   ' box around buttons
e = MakeBox(2, 52, 9, 62, 1, 15)                   ' box around check boxes
e = ShowWinText(13, 0, 13, "F1 = help")               ' help hot key


' input fields, check boxes, and push buttons in Main window.
' the handles returned by the "make" functions for fields and boxes are saved
' in variable names. these are used later to determine state of check box
' and contents of input field.

' input fields
MainField1 = MakeInputField(12, 52, 10, " *LangWin*", 11, 0)'"LangWin" is default
' check boxes
MainBox1 = MakeCheckBox(5, 55, 15, 13, CheckOff)  ' initially off
' buttons
MainButton1 = MakePushButton(5, 40, 10, "Button1", 15, 4, 1)
Look1 = MakePushButton(7, 40, 10, "Look", 15, 4, 1)


' menu bar buttons
MainMenu1 = MakePushButton(0, 1, 8, "MENU1", 0, 7, 0)
MainMenu2 = MakePushButton(0, 9, 8, "MENU2", 0, 7, 0)
MainMenu3 = MakePushButton(0, 17, 8, "MENU3", 0, 7, 0)
MainMenu4 = MakePushButton(0, 25, 8, "MENU4", 0, 7, 0)
MainMenu5 = MakePushButton(0, 33, 8, "MENU5", 0, 7, 0)
MainMenu6 = MakePushButton(0, 41, 8, "MENU6", 0, 7, 0)
MainMenu7 = MakePushButton(0, 49, 8, "MENU7", 0, 7, 0)
MainMenu8 = MakePushButton(0, 57, 8, "MENU8", 0, 7, 0)

' redefine some additional global Hot Keys
REDIM UserHotKeys(0 TO 4, 1 TO 2)
' each key is defined by its ascii value and WinEvent return code
UserHotKeys(1, 1) = -60 ' F2 key  (options)
UserHotKeys(1, 2) = 4   ' WinEvent action=4
UserHotKeys(2, 1) = 15  ' ctrl-o key  (open)
UserHotKeys(2, 2) = 5   ' WinEvent action=5
UserHotKeys(3, 1) = -30 ' alt-a key   (about)
UserHotKeys(3, 2) = 6  '  WinEvent action=6
UserHotKeys(4, 1) = -59 ' F1 key      (help)
UserHotKeys(4, 2) = 7  '  WinEvent action=7


' MAIN LOOP
' as long as any win is open
' wait for an event in any window, then process it

DO       ' infinite loop. when main win closed, exit subroutine
	' wait for an event
	' win number (wn) and event code (action) returned
	wn = WinEvent(action)

	' test window number to see which window was current when event occurred
	SELECT CASE wn

	CASE Main1      ' main window
		seltxt = WinParms(CurWinPtr, 15)  ' get index of selected text
		savindx = WinParms(CurWinPtr, 18)   ' index in SaveText scroll text
	   
		' now determine what type of event occurred in the main window
		SELECT CASE action
		CASE 1      ' close
			xx = CloseWindow
			' since info win is mode 4, we know it's still open
			' (it cannot be selected or closed by user).
			z = IsWinOpen(inf, wh)  ' get handle of info win
			CALL NewFocusWindow(wh) ' give focus to info win
							 ' since it's the last win open, it
							 ' should already have focus, this is just
							 ' a double check.
			xx = CloseWindow  ' close the info window
			EXIT SUB   ' force an exit when main win is closed
		CASE 2      ' text
			' if a line of scrollable text in main win is selected,
			' toggle a selection character in the text.
	 
			' if MainButton1 in main win is later hit & MainBox1
			' is down, then all selected text will be processed (contents of
			' MainField1 will be inserted into these lines, a window
			' opened, and all modified text displayed).
			' this demonstrates how one can select entries from a scrollable
			' list of text, and later process them based upon other
			' button events.

			'toggle selection character
			IF MID$(SaveText(savindx, seltxt), 2, 1) = "X" THEN
				MID$(SaveText(savindx, seltxt), 2, 1) = " "  ' un-select
			ELSE
				MID$(SaveText(savindx, seltxt), 2, 1) = "X"   ' select
			END IF
			CALL ReShowText               ' re-display text in win
	   
		CASE 3      ' button
			' all button handles returned from the "make" routine have been
			' saved in variable names.
			' use these variables to determine which button in main window
			' was hit
	   
			bhandle = WinParms(CurWinPtr, 16) ' get handle of button clicked
		   
			SELECT CASE bhandle    ' process the button
		   
			CASE MainButton1  ' button1
				' call subroutine that will check state of MainBox1.
				' if that box is set, then contents of MainField1 will
				' be inserted into all selected scrollable text, a modal
				' window will be opened (number returned in ModTextWinNum),
				' and all modified text displayed in it.
				' if MainBox1 is not set, a modal error window is open
				' (number returned in ErrWinNum).
				' if MainBox1 is set, but no text selected, a modal
				' error window is opened (number returned in ErrWinNum).
			   
				CALL MButton1(MainBox1, MainField1, savindx, ModTextWinNum, ErrWinNum)
			
			CASE MainMenu1
				CALL menu1
		   
			' no code for selecting other menu buttons.
			' i'll leave that for you to experiment with.
			CASE MainMenu2
			CASE MainMenu3
			CASE MainMenu4
			CASE MainMenu5
			CASE MainMenu6
			CASE MainMenu7
			CASE MainMenu8
		   
			CASE Look1     ' show some instructions
				' open modal window, don't bother checking for error
				l1w = BlankWin(2, 20, 23, 77, 1, 15, 2, 15, 1, 2)
		  
				' display some text in window
				e = ShowWinText(2, 2, 15, "You can try 2 tasks:")
				e = ShowWinText(4, 2, 15, "1) A. Select some scrollable text (double click).")
				e = ShowWinText(5, 2, 15, "   B. Click check box to the right of Button1.")
				e = ShowWinText(6, 2, 15, "   C. Change the text in the input field.")
				e = ShowWinText(7, 2, 15, "   D. Click Button1.")
				e = ShowWinText(9, 2, 15, "   You'll see a window with all selected text.")
				e = ShowWinText(10, 2, 15, "   Input field will be inserted at end of text.")
				e = ShowWinText(11, 2, 15, "   When you close that window, scrollable text")
				e = ShowWinText(12, 2, 15, "   in main window is permanently updated.")
				e = ShowWinText(15, 2, 15, "2) Click on MENU1.")
				e = ShowWinText(16, 2, 15, "   You'll get a sub-menu with other options.")
				e = ShowWinText(17, 2, 15, "   You can click on options, or use Hot Keys.")
				e = ShowWinText(20, 2, 14, "CLOSE WINDOW TO CONTINUE")
				e = ShowTitle("INSTRUCTIONS", 15, 4)
	
			END SELECT   ' end of code to process buttons in main menu
	   
		' user defined hot keys
		CASE 4  ' F2 = options
			CALL F2

		CASE 5  ' ctrl-o = open
			CALL open1

		CASE 6  ' alt-a = about
			CALL about1

		CASE 7  ' F1 = help
			CALL Help1

		END SELECT  ' end of code that processes actions in main win

	CASE l1w  ' look window (instructions)
		' this is a modal window, only the close action will be processed
		IF action = 1 THEN xx = CloseWindow

   
	END SELECT  ' end of code that processes events in open windows


LOOP

END SUB

