/****************************************************************

	ui_gets.c       gets function for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "gr.h"
#include "kb.h"
#include "ui.h"

#define	BACKSPACE	8
#define	CURSOR		'_'

ui_wait()
	{
	register int carry_on;
	static int x_pos, y_pos, b_stat;

	carry_on = TRUE;
	while( carry_on == TRUE )
		{
		if ( kb_rxstat() == TRUE )
			{
			return kb_rx();
			}
		if ( gr_ismouse == TRUE )
			{
			if ( gr_mouse( SAMPLE, &x_pos, &y_pos, &b_stat ) == TRUE )
				{
				gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
				gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
				return TRUE;
				}
			}
		ui_poll();
		}
	}

ui_getch()
	{
	while( kb_rxstat() == FALSE )
		{
		ui_poll();
		}
	return kb_rx();
	}

ui_gets( window, x, y, maxlength, buffer, display, foreground, background  )
	struct gr_window *window;
	int x, y, maxlength, display, foreground, background;
	char *buffer;
	{
	register int c, p;
	char disp_string[ 128 ];

	if ( display == TRUE )
		{
		sprintf( disp_string, "%c", CURSOR );
		gr_text( ui_screen, x, y, disp_string,
			foreground, background );
		}

	buffer[ 0 ] = 0;
	c = p = 0;
	while( ( c != CR ) && ( c != LF) && ( strlen( buffer ) < maxlength ))
		{
		c = ui_getch();
		switch( c )
			{
			case BACKSPACE:
				--p;
				buffer[ p ] = 0;
				break;				
			case CR:
			case LF:
				break;
			default:
				buffer[ p ] = c;
				++p;
				buffer[ p ] = 0;
				break;
			}
		if ( display == TRUE )
			{
			sprintf( disp_string, "%s%c ", buffer, CURSOR );
			gr_text( ui_screen, x, y, disp_string,
				foreground, background );
			}
		}

	if ( display == TRUE )
		{
		sprintf( disp_string, "%s ", buffer );
		gr_text( ui_screen, x, y, disp_string,
			foreground, background );
		}

	}
