/*************************************************************************

	dr_unix.c       Directory (dr) subroutines
			for Bywater Software.

			Implementation for generic (?) Unix

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#include "string.h"
#include "time.h"
#include "sys/types.h"
#include "sys/stat.h"

#include "dr.h"

#define	INFILENAME	"."
#define	OUTFILENAME	"/tmp/dr_unix.tmp"

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#ifndef	CR
#define	CR	13
#define	LF	10
#endif

int	dr_fs = '/';
char	dr_all[ MAX_PATHLENGTH ] = "";

extern char *tmpname();

char unix_flpath[ MAX_PATHLENGTH ];
char command_string[80];
FILE *unix_fp;
static char      _path[ MAX_PATHLENGTH ];

dr_first( findb, retb )
	char *findb; 
	struct dir_ent *retb;
	{
	register int c;
	char *name;

	sprintf( command_string, "ls -a -1 %s >%s", findb, OUTFILENAME );
	system( command_string );

	if ( ( unix_fp = fopen( OUTFILENAME, "r" )) == NULL) 
		{
#ifdef	DEBUG
		bw_error( "Cannot open temp file"); 
#endif
		return FALSE;
		}

	if ( feof( unix_fp ))
		{
		fclose( unix_fp );
#ifdef	DEBUG
		bw_error( "Temporary file is empty." );
#else
		unlink( OUTFILENAME ); 
#endif
		return FALSE;
		}
	else
		{

		strcpy( _path, findb );
		c = strlen( _path );

		while (( c >= 0 ) && ( _path[ c ] != dr_fs ))
			{
#ifdef  OLD_DEBUG
			fprintf( stderr, "_path: %s c: %d\n", _path,
				c );
#endif
			_path[ c ] = 0;
			--c;
			}

		strcpy( retb->pathname, _path );

		name = fgets( command_string, 80, unix_fp );
		if ( unix_fillbuffer( retb, name ) == FALSE )
			{
			return FALSE;
			}
		else
			{
			return TRUE;
			}
		}
	}

dr_next( retb )
	struct dir_ent *retb;
	{
	char *name;

	if ( feof( unix_fp ) )
		{
		fclose( unix_fp );
#ifndef	DEBUG
		unlink( OUTFILENAME ); 
#endif
		return FALSE;
		}
	else
		{
		strcpy( retb->pathname, _path );
		name = fgets( command_string, 80, unix_fp );
		if ( unix_fillbuffer( retb, name ) == FALSE )
			{
			return FALSE;
			}
		else
			{
			return TRUE;
			}
		}
	}

unix_fillbuffer( retb, name )
	struct dir_ent *retb;
	char *name;
	{
	static struct stat s_buf;

#ifdef	OLD_DEBUG
	fprintf( stderr, "unix_fillbuffer() received filename: <%s> \n", name );
#endif

	if ( name == NULL )
		{
		return FALSE;
		}

	strcpy( retb->filename, name );
	unix_truncate( retb->filename );

	if ( strlen( retb->filename ) == 0 )
		{
#ifdef	DEBUG
		bw_error( "Null filename returned." );
#endif
		return FALSE;
		}

	if ( stat( retb->filename, &s_buf ) != 0 )
		{
#ifdef	OLD_DEBUG
		fprintf( stderr, "Can't stat file %s\n", retb->filename );
#endif
		}

	retb->size = s_buf.st_size;

	if ( ( s_buf.st_mode & 0040000 ) == 0040000 )
		{
		retb->type = FILE_DIRECTORY;
		}
	else if ( ( s_buf.st_mode & 0000400 ) == 0000007 )
		{
		retb->type = FILE_EXECUTABLE;
		}
	else if ( ( s_buf.st_mode & 0000200 ) == 0000070 )
		{
		retb->type = FILE_EXECUTABLE;
		}
	else if ( ( s_buf.st_mode & 0000100 ) == 0000100 )
		{
		retb->type = FILE_EXECUTABLE;
		}
	else
		{
		retb->type = FILE_NORMAL;
		}

	return TRUE;

	}

unix_truncate( buffer )
	char *buffer;
	{
	register char *p;

	p = buffer;
	while( *p != 0 )
		{
		if (( *p == CR ) || ( *p == LF ))
			{
			*p = 0;
			}
		++p;
		}
	}

