;
; *** Listing 9-12 ***
;
; Illustrates the use of a word-sized DEC for the outer
; loop, taking advantage of the knowledge that the counter
; for the inner loop is always 0 when the outer loop is
; counted down. This code uses no registers other than
; CX, and would be used when registers are in such short
; supply that no other registers are available. Otherwise,
; word-sized DECs would be used for both loops. (Ideally,
; a LOOP would also be used instead of DEC CX/JNZ.)
;
; Note: This is a sample code fragment, and is not intended
; to either be run under the Zen timer or assembled as a
; standalone program.
;
	mov	cl,5	;outer loop is performed 5 times
OuterLoop:
	mov	ch,10	;inner loop is performed 10 times
			; each time through the outer loop
InnerLoop:
;<<<working code goes here>>>
	dec	ch	;count down inner loop
	jnz	InnerLoop
	dec	cx	;CH is always 0 at this point, so
			; we can use the shorter & faster
			; word DEC to count down CL
	jnz	OuterLoop
