;
; Returns the status of the line A20 through the KBC
;	NASM A20State.asm -f bin -o A20State.com
;
[BITS 16]
[ORG 0x100]

_main:		mov	dx, msg_fail
		call	_GET_A20_STATE_			; Zero flag set if there
		jz	.exit				;  was a problem

		push	ax				; Save state, AH
		mov	dx, msg_ok			; There wasn't a problem
		mov	ah, 09h
		int	21h				; Print message
		pop	ax				; retreve state

		mov	dx, msg_dis
		and	ah, 00000010b			; bit 1, 2h, indicates state
		jz	.exit
		mov	dx, msg_en

.exit:		mov	ah, 09h
		; DX already contains address of string
		int	21h

		mov	ax, 4C00h
		int	21h

msg_ok:		db	'OK', 13, 10, 'A20 $'
msg_fail:	db	'FAIL', 13, 10, '$'
msg_en:		db	'ENABLED', 13, 10, '$'
msg_dis:	db	'DISABLED', 13, 10, '$'


;
; Determins the state of the line A20 by reading the Ouput Port
; register of the KBC.
; If an error occured, the zero flag will be set.
; Else, it returns the in AH the value of the Output port on the KBC.
; Bit 1 of AH reflects the state,
;	0 - A20 disabled
;	1 - A20 enabled
; To check you would do something like
;	test ah, 2	; 2 = 0010b
;	jz A20_DISABLED
;
_GET_A20_STATE_:
		call	A20Write		; Wait till the input register is empty
		jz	.exit+1			; Bypas the reset int's
		cli				; Disable ints so we'll get our value

		mov	al, 0D0h		; Send command to the 8042 command register
		out	64h, al			; to tell it we want to Read the Output Port
		call	A20Read			; Wait till the 8042 output register
		jz	.exit			; has something in it's buffer
		
		in	al, 60h			; Get it
		mov	ah, al
		call	A20Write		; Make sure the input register is empty
		jz	.exit

		mov	al, 0FFh		; KBC NOP command, does nothing
		out	64h, al
		call	A20Write

.exit:		sti
		ret


; Waits until the Input register is empty or until a short amount
; of time has elapsed. It waits till bit 1 of the KBC Read Status
; Port is clear, Zero.
; Sets the Zero flag if an error occured.
A20Write:	xor	cx, cx			; Reasonable wait
 .get:		in	al, 64h			; Get KBC read status
		test	al, 02			; See if buffer empty, bit 1 clear
		jz	.clear
		dec	cx
		jz	.exit
		jmp	SHORT .get
 .clear:	inc	al			; Clear ZR
 .exit:		ret

; Waits until the Read Status Port, 64h, contains data by checking the state
; of bit 0. It waits till it is set or too much time has gone by.
; Sets the Zero flag if an error occured,
A20Read:	xor	cx, cx
 .get:		in	al, 64h
		test	al, 01			; If the 'output buffer' is full, has
		jnz	.exit			; something for me
		dec	cx
		jnz	.get
 .exit:		ret