; Julian Schmidt                                          1:273/911
 ;   This .COM program will change the attribute of every character on
 ;   the text-mode display screen.  It will 'stripe' the display
 ;   row-wise!

 .MODEL    SMALL
 .CODE
     ORG   100H
 
 START:
     xor    bh,bh
     mov    dl,79          ;Column counter.
     mov    dh,24          ;Row counter.
 _doloop:
     mov    ah,02h         ;Request function 02h.
     int    10h            ;Bios's Set Cursor Position.
     mov    ah,08h         ;Request function 08h.
     int    10h            ;Bios's read Character and Attribute.
 ;AH is the attribute, and AL is the ascii character byte.
     push   ax             ;Store the character and attribute.
     push   dx             ;Store the counters.
     mov    ax,0005h       ;Divide by five... (AL = 5).
     xchg   al,dl          ;Now, dl is the source (five).
     div    dl             ;Divides AX by DL...(AH = 0).
                           ;Quotient is now in AL.
     mov    bl,al          ;Moves attribute into BL.
     cmp    bl,0           ;Is the attribute zero (black)?
     jne    NotBlack
     mov    bl,15          ;attribute of fifteen decimal.
 NotBlack:
     pop    dx             ;Retrieve the counters.
     pop    ax             ;Retrieve the char. and attribute.
     mov    ah,09h         ;Request function 09h.
     mov    cx,1           ;Number of characters to write.
     int    10h            ;Bios's Write char. and Attrib.
 ;**********************************************************************
     dec    dh             ;Decrement the row counter.
     cmp    dh,0           ;Are we at row zero???
     jge    _doloop        ;If not, go through the loop again.
     mov    dh,24          ;Reset the row counter.
     dec    dl             ;Decrement the column counter.
     cmp    dl,0           ;Are we at column zero???
     jge    _doloop        ;If not, go through the loop again.
 EXIT:
     mov    ax,4c00h       ;Function 4ch.
     int    21h            ;Dos's Terminate w/ return code.
 
     END    START
