Ideal

START_CHAR  = 'a'
NUM_CHARS   = 26
CHAR_HEIGHT = 16

Model Tiny
P186
CodeSeg
Org 100h

Proc        Prog

            mov dx,03C4h       ;Sequencer port
            mov ax,0402h       ;Set Map Mask to 0100b
            out dx,ax          ;which enables Plane 2
            mov ax,0704h       ;Turn off Odd/Even mode
            out dx,ax
            mov dx,03CEh       ;Graphics Controller port
            mov ax,0204h       ;Set Read Plane to 2
            out dx,ax
            mov ax,0005h       ;Turn off Odd/Even
            out dx,ax
            mov ax,0406h       ;Set 0A000h address
            out dx,ax

            lea si,[NewFont]   ;DS:SI = new font
            push 0A000h        ;ES = video memory
            pop es             ;and DI = START_CHAR * 20h
            mov di,START_CHAR
            shl di,5
            mov dx,NUM_CHARS   ;Number of chars
            mov ax,CHAR_HEIGHT ;Bytes/char
            mov bx,20h         ;BX = adjustment value
            sub bx,ax          ;which is 20h - height

FontLoop:   mov cx,ax          ;CX = height
            rep movsb          ;Store char
            add di,bx          ;Next char slot
            dec dx             ;Any more chars?
            jnz FontLoop       ;Loop back

            mov dx,03C4h       ;Sequencer port
            mov ax,0302h       ;Restore original values
            out dx,ax
            mov ax,0304h
            out dx,ax
            mov dx,03CEh       ;Graphics Controller port
            mov ax,0004h       ;Restore original values
            out dx,ax
            mov ax,1005h
            out dx,ax
            mov ax,0E06h
            out dx,ax

            ret                ;Return

EndP        Prog

NewFont     db 5 dup(0),16,56,108,198,254,198,198
            db 9 dup(0),252,198,198,252,198,198,252
            db 9 dup(0),124,198,3 dup(192),198,124
            db 9 dup(0),252,5 dup(198),252,9 dup(0)
            db 254,192,192,248,192,192,254,9 dup(0)
            db 254,192,192,248,3 dup(192),9 dup(0),124
            db 198,192,222,198,198,124,9 dup(0)
            db 3 dup(198),254,3 dup(198),9 dup(0),60
            db 5 dup(24),60,9 dup(0),30,4 dup(12),204
            db 120,9 dup(0),198,204,216,240,216,204,198
            db 9 dup(0),6 dup(192),254,9 dup(0),198,238
            db 254,214,3 dup(198),9 dup(0),198,230,246
            db 222,206,198,198,9 dup(0),124,5 dup(198)
            db 124,9 dup(0),252,198,198,252,3 dup(192)
            db 9 dup(0),124,4 dup(198),124,14,9 dup(0)
            db 252,198,198,252,3 dup(198),9 dup(0),124
            db 198,192,124,6,198,124,9 dup(0),126
            db 6 dup(24),9 dup(0),6 dup(198),124,9 dup(0)
            db 4 dup(198),108,56,16,9 dup(0),3 dup(198)
            db 214,254,238,198,9 dup(0),198,198,108,56
            db 108,198,198,9 dup(0),3 dup(102),60,24,24
            db 24,9 dup(0),254,12,24,48,96,192,254,4 dup(0)

End Prog
