; HOWARD SWINEHART
;  This grabs the scan code and displays it in the top right corner
;  without interfering with the BIOS routine.

code    segment para public 'code'
        assume cs:code, ds:code, es:code, ss:code
        org 100h
main:
    jmp start

oldint9     dw  0,0             ; Original int 9h pointer

start:
    mov     al,09h              ; Get INT 09h address
    mov     ah,35h
    int     21h
    mov     [oldint9],bx        ; Save it for later
    mov     [oldint9+2],es

    mov     al,09h              ; Set new INT 09h
    mov     dx,offset newint9   ; DS:DX = new handler
    mov     ah,25h
    int     21h

;----- MAIN PROGRAM BEGINS HERE -----
mloop:
    mov     ah,0                ; Wait for a key
    int     16h

    cmp     al,27               ; Exit if ESC pressed
    je      exit

    mov     dl,al               ; Otherwise, display it.
    mov     ah,2
    int     21h
    jmp     mloop

;----- PROGRAM EXITS HERE -----
exit:
    mov     al,09h              ; Restore original INT 09h
    mov     dx,[oldint9]
    mov     ds,[oldint9+2]      ; Move old INT 09H pointer to DS:DX
    mov     ah,25h
    int     21h

    mov     ax,4c00h            ; Return to DOS
    int     21h
;
;        NEW INT 09H HANDLER
;
newint9:
    push    ax                  ; Save regs
    push    ds

    mov     ax,0b800h           ; Color screen segment
    mov     ds,ax

    in      al,60h              ; Get scan code

    test    al,128              ; Is it a key release?
    jnz     exit9               ;   Yes, exit

; Poke scan code into top right corner
    mov     [ds:158],al

exit9:
    pop     ds
    pop     ax                  ; Restore regs

    jmp     dword ptr [cs:oldint9]  ; Continue through BIOS handler

code    ends
end     main
