;psp-env.asm - Access the PSP to locate and display the environment variables
;              using a data structure as opposed to using hardcoded values:
;                       MOV BX,2Ch
;                       MOV DS,ES:[BX]          ;Get environment segment.

_psp struc
   Int20             dw ?            ;Int 20h instruction
   NextParagraph     dw ?            ;segment addr of next paragraph
                     db ?            ;reserved
   Dispatcher        db 5 dup (?)    ;long call to MS-DOS
   TerminateVector   dd ?            ;Termination address (Int 22h)
   ControlCVector    dd ?            ;CTRL+C Handler (Int 23h) addr
   CritErrorVector   dd ?            ;Crit-Err Handler (Int 25h) addr
                     dw 11 dup (?)   ;reserved
   Environment       dw ?            ;segment address of environment
                     dw 23 dup (?)   ;reserved
   FCB_1             db 16 dup (?)   ;default FCB #1
   FCB_2             db 16 dup (?)   ;default FCB #2
                     dd ?            ;reserved
   CommandTail       db 128 dup (?)  ;command tail (count,seperator,list..)
_psp ends

;####################################################################
cseg segment
assume cs:cseg
psp _psp <>                             ;Show debugger the PSP.

org 100h                                ;COM file.

Begin:
        mov     ds,es:[psp.Environment] ;Get environment segment.
        xor     si,si                   ;DS:SI point -> to envars list.
  l1:   cmp     word ptr[si],0          ;Check for end of list, double null.
        je      exit                    ; yes, done.
        lodsb                           ;Get AL from DS:SI & increment SI.
        cmp     al,0                    ;Is this the end of the line?
        jne     more                    ; no, print AL.
        mov     al,0Dh                  ; yes, print CR/LF.
        int     29h                     ;DOS 29h, print single character.
        mov     al,0Ah
  more: int     29h                     ;Print AL to screen.
        jmp     l1                      ;Get more data.
  exit:
        mov     ax,4C00h                ;Exit to DOS.
        int     21h

cseg ends
end Begin
