;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; TSS.ASM
;   Function: Create a TSS.  Give it a ring 0 stack and an IO bitmap
;
	.386P


include segs.asi
include tss.asi
include idt.asi
include emuinter.asi
	public settss,trapout

	
SEG386Data 	segment
	extrn MemBase : DWORD, MemFree : DWORD, TSSBase : DWORD, tGDT : BYTE

SEG386Data	ends


SEG386	segment
	assume cs:dgroup,ds:dgroup, fs: ABSDATA
;
; Routine to trap io to a given port
;
trapout	proc
	mov	al,bl	; Lower 5 bits in al
	and	eax,1fh
	movzx	ebx,bx	; Upper bits in ebx
	shr	ebx,5	;
	bts	fs:[edi.bitmap + ebx*4],eax ; Set the bitmap flag
	ret
trapout	endp
;
; Set up TSS
;
settss	proc
	mov	edi,TSSDESC		; Get descriptor from selector
	and	edi,0fff8h		;
	add	edi,offset DGROUP:tGDT	;
	mov	eax,[TSSBase]      	; Grab TSS base
	mov	word ptr [edi+2],ax	;  Put lower word of base in desc
	shr	eax,16			; Put upper word of base in desc
	mov	byte ptr [edi + 4],al	;
	mov	byte ptr [edi+7], ah	;

	mov	edi,[TSSBase]		; Get base
	push	edi			; Save for later
	push	es			; Get ES = absdata
	push	fs			;
	pop	es			;
	mov	ecx,TSSSIZE/4		; Zero TSS out
	sub	eax,eax			;
	rep	stosd			;
	pop	es			; restore es

	pop	edi			; Get base addr
	mov	eax,edi			; to eax
	add	eax,TSSSIZE-IDTSIZE-4	; Point at position of stack
					; ( in TSS page)
	mov	dword ptr fs:[edi.rESP0],eax	; Set it as ring 0 stack
	mov	word ptr fs:[edi.rSS0], DSABS	;
	mov	word ptr fs:[edi.bmo], 68h	; Bitmap starts right after TSS
	mov	bx,CONTROLPORT		; Trap our control and data ports
	call	trapout			;
	mov	bx,DATAPORT		;
	call	trapout			;
	mov	ax,TSSDESC		; Load selector into task reg
	ltr	ax 			;
	ret
settss	endp
SEG386	ends
	end