;
; Dump.asm
;
; Function: Handle the Dump command
;
	
	IDEAL
	P386


include "segs.asi"
include "prints.ase"
include "os.asi"
include "input.ase"
include "mtrap.ase"

DUMPLEN = 80h
	PUBLIC	dump

SEGMENT seg386data
index	dd	0		; Default for next dump
indexseg dw	0		;
ENDS	seg386data
SEGMENT	seg386
;
; Dump one line
;
PROC	dumpline
	push	edx
	push	ebx        		; EBX MUST be on second of stack
	push	ecx			; ECX MUST be on top of stack
	sub	eax,eax
	mov	al,bl  		; AL = lower byte of address
	and	al,15		; AL = lower nibble
	mov	ecx,16		; Total bytes to dump
	jz	short doline	; Go do hexdump if start of line = 0
	neg	al		; Else calculate number of bytes in line
	add	al,16		;
	mov	ecx,eax		; To ECX

doline:
	sub	[esp],ecx	; Decrement count which is on stack
	add	[esp+4],ecx	; Increment address which is on stack
	mov	al,16		; Get count of amount to space over
	sub	al,cl		;
	jz	short puthex	; Don't space over any, just put out hex

	push	ecx		; Else ecx = spacecount * 3
	mov	ecx,eax		;
	add	ecx,ecx		;
	add	ecx,eax		;
blanklp1:
	call	PrintSpace      ; Dump spaces
	loop	blanklp1	;
	pop	ecx

puthex:                         ; Save count and address for ASCII dump
	push	ecx		;
	push	esi		;
hexlp:
	call	PrintSpace	; Print a space
	mov	al,[es:esi]	; Get the byte
	inc	esi		; Increment the address pointer
	call	PrintByte	; Print byte in hex
	loop	hexlp		; Loop till done
	pop	esi		;
	pop	ecx		;

	call	printSpace	; Print two spaces to seperate ASCII dump
	call	PrintSpace	;

	sub	eax,eax		; Calculate amoun to space over
	mov	al,16		;
	sub	al,cl		;
	jz	short putascii	; None to space over, put ascii
	push	ecx		; ECX = space value
	mov	ecx,eax
blanklp2:
	call	PrintSpace	; Space over
	loop	blanklp2	;
	pop	ecx		;

putascii:
	mov	dl,[es:esi]	; Get char
	inc	esi		; Increment buffer
	os	VF_PURECHAR	; Put char out, no control seq accepted
	loop	putascii
	pop	ecx		; Get count from stack
	pop	ebx		; Get address from stack
	pop	edx		; Restore EDX
	ret
ENDP	dumpline
;
; Main DUMP routine
;
PROC	dump
	call	PageTrapErr	; Enable error on page trap
	mov	ecx,DUMPLEN	; Default amount to dump
	call	WadeSpace	; Wade to end of spaces
	cmp	al,13		; If no numbers, we just use the old default
	jz	short atindex	;
	call	ReadAddress	; Else read start address
	jc	dudone		; Quit on error
	call	WadeSpace	; Wade through spaces
	cmp	al,13		; If no numbers, just use the default
	jz	short dodump	;
	call	ReadNumber	; Else read end offset
	jc	short dudone	;
	sub	eax,ebx		; Calculate length of dump
	mov	ecx,eax		;
	jmp	short dodump	; Go do dump
atIndex:
	mov	ebx,[index]	; Assume we want to dump from last index
	mov	dx,[indexseg]	;
dodump:
	
	or	dx,dx		; If DX = null selector, assume DS
	jnz	short gotsel	;
       	mov	dx,[rds]	;
gotsel:
	push	es		;
	mov	eax,DSABS	; Absolute segment, uses current page tables
	mov	es,eax		;
	call	BaseAndLimit    ; Calculate absolute address and count
dumplp:
	push	ebx		;
	Message	CRLF            ; CR/LF
	pop	ebx		;
	mov	eax,edx		; Print the selector
	call	PrintWord	;
	push	edx		;
	mov	dl,':'		; Print a ':'
	os	VF_CHAR		;
	pop	edx		;
	mov	eax,ebx		;
	and	eax,0fffffff0h  ; Address low nibble = 0
	call	PrintDWord	; Print address
	call	dumpline	; Dump a line
	or	ecx,ecx		; Continue while count > 0
	jg	dumplp		;
	mov	[index],ebx	; Save new index value
	mov	[indexseg],dx	;
	pop	es
	clc			; No errors
dudone:
	pushfd			; Save error flag
	call	PageTrapUnerr	; Disable page traps
	popfd			; Restore error flag
	ret
ENDP	dump
ENDS	seg386
END