; anti-viral partition table and boot sector loader
;
; written on 16 March 1992 by Ed Beroset
; released to the public domain by the author
;
; *** USE THIS CODE AT YOUR OWN RISK! ***
;
; Replace the partition table data at the end of this code with the
; appropriate data for your system, and then compile, and link as COM.
; Then replace your existing partition table with this one.  
;
; TASM 2.5 makefile:
;
;mypart.exe: mypart.obj
;  tlink /Tdc /s /e /n mypart.obj,mypart.bin,mypart.map
;
;mypart.obj: mypart.asm
;  tasm /la /m2 mypart
;
;

  IDEAL
  MODEL TINY

  Offs1     EQU   7c00h       ; this is where the program is initially loaded
  Offs2     EQU   0600h       ; org for program (starting from sillyjmp)
  PartStart EQU   01beh       ; offset of partition table within sector
  Signature EQU   0aa55h      ; signature byte for partition and boot sectors
  MAXTRIES  EQU   5           ; max tries to read boot sector
;
; if you are using MASM or a version of TASM older than TASM 2.5
; comment out the following line
;
IFDEF     ??version
  IF  ??version GE 0205h      ; if you've got TASM 2.5 or better
    CLEVER  EQU   1           ; this makes several sections much clearer
  ENDIF
ENDIF

  CODESEG

    ORG 0

Start:
    cli                       ; turn off interrupts while we fiddle with stack
    xor    ax,ax              ; ax=0
    mov    ss,ax              ; stack segment = 0
    mov    sp,Offs1           ; this is where we're actually loaded
    sti                       ; turn interrupts back on
    mov    si,sp              ; prepare to move this code
    mov    es,ax              ; es = 0
    mov    ds,ax              ; ds = 0
    mov    bp,ax              ; bp = 0
    cld                       ; make sure we increment
    mov    di,Offs2 + OFFSET Start    ; 0600h
    mov    cx,0100h           ; prepare to move this whole sector (256 words)
    repne  movsw              ; move our code to 0:600h

IFDEF CLEVER
    jmp    FAR 0:Silly        ; jump to copy of this code 
ELSE
    db     0eah                           ; opcode for JMP FAR
    dw     Offs2 + OFFSET sillyjmp,0      ; offset, segment of target
ENDIF

sillyjmp:
  Silly = $ - Start + Offs2
    mov    si,Offs2 + OFFSET err_int13    ; prepare to print error message
    cmp    [WORD PTR 4 * 13h + 2],0a000h  ; assure that vector is in ROM
    jb     msg_loop                       ; if not, print the error
    mov    si,Offs2 + OFFSET ptable0      ; point to copy of partition table
    mov    cx,04              ; prepare to read up to four partitions

find_part:
    mov    al,[BYTE si]       ; if this is a valid partition, bits 0-6 clear
    shl    al,1               ; move bootable flag into carry
    jnz    bad_ptable         ; if it wasn't 80h or 00, it's not valid
    jnb    next_part          ; if it's not bootable, skip next instruction
    mov    bp,si              ; this is our bootable partition

next_part:
    add    si,0010h           ; point to next partition table entry
    loop   find_part          ; check all four partition table entries
    cmp    bp,0               ; was any bootable partition ever found?
    jnz    boot_read          ; if so, go read it
    int    18h                ; otherwise drop through into cassette BASIC

bad_ptable:
    mov    si,Offs2 + OFFSET err_invalid

msg_loop:
    lodsb                     ; fetch next character into AL 
    cmp    al,00              ; are we at the end of the message?
    jz     lock_up            ; if so, hang the computer in infinite loop
    mov    bx,0007            ; screen attribute = white on black
    mov    ah,0eh             ; BIOS function to show a single char
    int    10h                ; video BIOS call
    jmp    msg_loop           ; go back for more

lock_up:
    jmp    lock_up            ; hang the computer

boot_read:
    mov    dx,[bp]            ; dh = head, dl = drive (80h means HD #0)
    mov    cx,[2+bp]          ; cx = second word of partition entry
    mov    bx,Offs1           ; read it into ES:BX (0:7C00)
    mov    di,MAXTRIES        ; we'll attempt disk read max 5 tries

boot_loop:
    mov    ax,0201h           ; prepare to read (ah=2) 1 sector (al=1)
    int    13h                ; try to read
    jnb    no_dos             ; if attempt succeeded, jump
    xor    ax,ax              ; prepare to reset disk system
    int    13h                ; do it
    dec    di                 ; decrement attempts counter
    jnz    boot_loop          ; loop back if we haven't tried MAXTRIES times
    mov    si,Offs2 + OFFSET err_loading
    jmp    msg_loop           ; otherwise, there was a loading error

no_dos:
    mov    si,Offs2 + OFFSET err_missing   ; prepare for missing DOS
    mov    di,Offs1 + OFFSET validity      ; read the signature word
    cmp    [WORD di],Signature             ; is it valid?
    jnz    msg_loop           ; if not, we're missing operating system
    mov    si,bp              ; we're fine - reset SI
IFDEF CLEVER
    jmp    FAR 0000:Offs1     ; jump to operating system loader
ELSE
    db     0eah
    dw     Offs1,0
ENDIF

public_domain:
    db     "Ed Beroset's anti-viral partition table",0
err_invalid:
    db     "Invalid partition table",0
err_loading:
    db     "Error loading operating system",0
err_missing:
    db     "Missing operating system",0
err_int13:
    db     7,"Possible viral infection",0

IF  ($ - Start) GT PartStart
  ERR
  DISPLAY "ERROR: Code overlaps partition table!"
ENDIF

    ORG    PartStart

STRUC part
    Bootable  db  0              ; 80h means bootable, active
    StartHead db  0              ;
    StartCyl  db  0              ; see note below about cyl/sect
    StartSect db  0              ;
    Type      db  0              ; 1=DOS-12 4=DOS-16 5=DOSEXT, 6=DR-6
    EndHead   db  0              ; last head on partition
    EndCyl    db  0              ; top 2 bits are hi bits of EndSect
    EndSect   db  0              ; combine these 8 lo bits with above
    StrtAbsSc dd  0              ;
    NumSect   dd  0              ;
ENDS  part

ptable0  part <80h,01h,01h,00h,06h,3fh,20h,39h, 00000020h, 0001cfe0h>
ptable1  part <>
ptable2  part <>
ptable3  part <>


    ORG    01feh
validity:
    dw     Signature

    END
